/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;

public abstract class EnumWrappers {
    private static Class<?> PROTOCOL_CLASS = null;
    private static Class<?> CLIENT_COMMAND_CLASS = null;
    private static Class<?> CHAT_VISIBILITY_CLASS = null;
    private static Class<?> DIFFICULTY_CLASS = null;
    private static Class<?> ENTITY_USE_ACTION_CLASS = null;
    private static Class<?> GAMEMODE_CLASS = null;
    private static Class<?> RESOURCE_PACK_STATUS_CLASS = null;
    private static Class<?> PLAYER_INFO_ACTION_CLASS = null;
    private static Class<?> TITLE_ACTION_CLASS = null;
    private static Class<?> WORLD_BORDER_ACTION_CLASS = null;
    private static Class<?> COMBAT_EVENT_TYPE_CLASS = null;
    private static Class<?> PLAYER_DIG_TYPE_CLASS = null;
    private static Class<?> PLAYER_ACTION_CLASS = null;
    private static Class<?> SCOREBOARD_ACTION_CLASS = null;
    private static Class<?> PARTICLE_CLASS = null;
    private static boolean INITIALIZED = false;
    private static Map<Class<?>, EquivalentConverter<?>> FROM_NATIVE = Maps.newHashMap();
    private static Map<Class<?>, EquivalentConverter<?>> FROM_WRAPPER = Maps.newHashMap();

    private static void initialize() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalArgumentException("Not supported on 1.6.4 and earlier.");
        }
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        PROTOCOL_CLASS = EnumWrappers.getEnum(PacketType.Handshake.Client.SET_PROTOCOL.getPacketClass(), 0);
        CLIENT_COMMAND_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.CLIENT_COMMAND.getPacketClass(), 0);
        CHAT_VISIBILITY_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.SETTINGS.getPacketClass(), 0);
        DIFFICULTY_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.LOGIN.getPacketClass(), 1);
        ENTITY_USE_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.USE_ENTITY.getPacketClass(), 0);
        GAMEMODE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.LOGIN.getPacketClass(), 0);
        RESOURCE_PACK_STATUS_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.RESOURCE_PACK_STATUS.getPacketClass(), 0);
        PLAYER_INFO_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.PLAYER_INFO.getPacketClass(), 0);
        TITLE_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.TITLE.getPacketClass(), 0);
        WORLD_BORDER_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.WORLD_BORDER.getPacketClass(), 0);
        COMBAT_EVENT_TYPE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.COMBAT_EVENT.getPacketClass(), 0);
        PLAYER_DIG_TYPE_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.BLOCK_DIG.getPacketClass(), 1);
        PLAYER_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.ENTITY_ACTION.getPacketClass(), 0);
        SCOREBOARD_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.SCOREBOARD_SCORE.getPacketClass(), 0);
        PARTICLE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.WORLD_PARTICLES.getPacketClass(), 0);
        EnumWrappers.associate(PROTOCOL_CLASS, PacketType.Protocol.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CLIENT_COMMAND_CLASS, ClientCommand.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CHAT_VISIBILITY_CLASS, ChatVisibility.class, EnumWrappers.getChatVisibilityConverter());
        EnumWrappers.associate(DIFFICULTY_CLASS, Difficulty.class, EnumWrappers.getDifficultyConverter());
        EnumWrappers.associate(ENTITY_USE_ACTION_CLASS, EntityUseAction.class, EnumWrappers.getEntityUseActionConverter());
        EnumWrappers.associate(GAMEMODE_CLASS, NativeGameMode.class, EnumWrappers.getGameModeConverter());
        EnumWrappers.associate(RESOURCE_PACK_STATUS_CLASS, ResourcePackStatus.class, EnumWrappers.getResourcePackStatusConverter());
        EnumWrappers.associate(PLAYER_INFO_ACTION_CLASS, PlayerInfoAction.class, EnumWrappers.getPlayerInfoActionConverter());
        EnumWrappers.associate(TITLE_ACTION_CLASS, TitleAction.class, EnumWrappers.getTitleActionConverter());
        EnumWrappers.associate(WORLD_BORDER_ACTION_CLASS, WorldBorderAction.class, EnumWrappers.getWorldBorderActionConverter());
        EnumWrappers.associate(COMBAT_EVENT_TYPE_CLASS, CombatEventType.class, EnumWrappers.getCombatEventTypeConverter());
        EnumWrappers.associate(PLAYER_DIG_TYPE_CLASS, PlayerDigType.class, EnumWrappers.getPlayerDiggingActionConverter());
        EnumWrappers.associate(PLAYER_ACTION_CLASS, PlayerAction.class, EnumWrappers.getEntityActionConverter());
        EnumWrappers.associate(SCOREBOARD_ACTION_CLASS, ScoreboardAction.class, EnumWrappers.getUpdateScoreActionConverter());
        EnumWrappers.associate(PARTICLE_CLASS, Particle.class, EnumWrappers.getParticleConverter());
        INITIALIZED = true;
    }

    private static void associate(Class<?> nativeClass, Class<?> wrapperClass, EquivalentConverter<?> converter) {
        if (nativeClass != null) {
            FROM_NATIVE.put(nativeClass, converter);
            FROM_WRAPPER.put(wrapperClass, converter);
        }
    }

    private static Class<?> getEnum(Class<?> clazz, int index) {
        try {
            return FuzzyReflection.fromClass(clazz, true).getFieldListByType(Enum.class).get(index).getType();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromNativeMap() {
        return FROM_NATIVE;
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromWrapperMap() {
        return FROM_WRAPPER;
    }

    public static Class<?> getProtocolClass() {
        EnumWrappers.initialize();
        return PROTOCOL_CLASS;
    }

    public static Class<?> getClientCommandClass() {
        EnumWrappers.initialize();
        return CLIENT_COMMAND_CLASS;
    }

    public static Class<?> getChatVisibilityClass() {
        EnumWrappers.initialize();
        return CHAT_VISIBILITY_CLASS;
    }

    public static Class<?> getDifficultyClass() {
        EnumWrappers.initialize();
        return DIFFICULTY_CLASS;
    }

    public static Class<?> getEntityUseActionClass() {
        EnumWrappers.initialize();
        return ENTITY_USE_ACTION_CLASS;
    }

    public static Class<?> getGameModeClass() {
        EnumWrappers.initialize();
        return GAMEMODE_CLASS;
    }

    public static Class<?> getResourcePackStatusClass() {
        EnumWrappers.initialize();
        return RESOURCE_PACK_STATUS_CLASS;
    }

    public static Class<?> getPlayerInfoActionClass() {
        EnumWrappers.initialize();
        return PLAYER_INFO_ACTION_CLASS;
    }

    public static Class<?> getTitleActionClass() {
        EnumWrappers.initialize();
        return TITLE_ACTION_CLASS;
    }

    public static Class<?> getWorldBorderActionClass() {
        EnumWrappers.initialize();
        return WORLD_BORDER_ACTION_CLASS;
    }

    public static Class<?> getCombatEventTypeClass() {
        EnumWrappers.initialize();
        return COMBAT_EVENT_TYPE_CLASS;
    }

    public static Class<?> getPlayerDigTypeClass() {
        EnumWrappers.initialize();
        return PLAYER_DIG_TYPE_CLASS;
    }

    public static Class<?> getPlayerActionClass() {
        EnumWrappers.initialize();
        return PLAYER_ACTION_CLASS;
    }

    public static Class<?> getScoreboardActionClass() {
        EnumWrappers.initialize();
        return SCOREBOARD_ACTION_CLASS;
    }

    public static Class<?> getParticleClass() {
        EnumWrappers.initialize();
        return PARTICLE_CLASS;
    }

    public static EquivalentConverter<PacketType.Protocol> getProtocolConverter() {
        return new EnumConverter<PacketType.Protocol>(PacketType.Protocol.class);
    }

    public static EquivalentConverter<ClientCommand> getClientCommandConverter() {
        return new EnumConverter<ClientCommand>(ClientCommand.class);
    }

    public static EquivalentConverter<ChatVisibility> getChatVisibilityConverter() {
        return new EnumConverter<ChatVisibility>(ChatVisibility.class);
    }

    public static EquivalentConverter<Difficulty> getDifficultyConverter() {
        return new EnumConverter<Difficulty>(Difficulty.class);
    }

    public static EquivalentConverter<EntityUseAction> getEntityUseActionConverter() {
        return new EnumConverter<EntityUseAction>(EntityUseAction.class);
    }

    public static EquivalentConverter<NativeGameMode> getGameModeConverter() {
        return new EnumConverter<NativeGameMode>(NativeGameMode.class);
    }

    public static EquivalentConverter<ResourcePackStatus> getResourcePackStatusConverter() {
        return new EnumConverter<ResourcePackStatus>(ResourcePackStatus.class);
    }

    public static EquivalentConverter<PlayerInfoAction> getPlayerInfoActionConverter() {
        return new EnumConverter<PlayerInfoAction>(PlayerInfoAction.class);
    }

    public static EquivalentConverter<TitleAction> getTitleActionConverter() {
        return new EnumConverter<TitleAction>(TitleAction.class);
    }

    public static EquivalentConverter<WorldBorderAction> getWorldBorderActionConverter() {
        return new EnumConverter<WorldBorderAction>(WorldBorderAction.class);
    }

    public static EquivalentConverter<CombatEventType> getCombatEventTypeConverter() {
        return new EnumConverter<CombatEventType>(CombatEventType.class);
    }

    public static EquivalentConverter<PlayerDigType> getPlayerDiggingActionConverter() {
        return new EnumConverter<PlayerDigType>(PlayerDigType.class);
    }

    public static EquivalentConverter<PlayerAction> getEntityActionConverter() {
        return new EnumConverter<PlayerAction>(PlayerAction.class);
    }

    public static EquivalentConverter<ScoreboardAction> getUpdateScoreActionConverter() {
        return new EnumConverter<ScoreboardAction>(ScoreboardAction.class);
    }

    public static EquivalentConverter<Particle> getParticleConverter() {
        return new EnumConverter<Particle>(Particle.class);
    }

    public static <T extends Enum<T>> EquivalentConverter<T> getGenericConverter(Class<T> enumClass) {
        return new EnumConverter<T>(enumClass);
    }

    private static class EnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<T> specificType;

        public EnumConverter(Class<T> specificType) {
            this.specificType = specificType;
        }

        @Override
        public T getSpecific(Object generic) {
            return Enum.valueOf(this.specificType, ((Enum)generic).name());
        }

        @Override
        public Object getGeneric(Class<?> genericType, T specific) {
            return Enum.valueOf(genericType, ((Enum)specific).name());
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificType;
        }
    }

    public static enum Particle {
        EXPLOSION_NORMAL("explode", 0, true),
        EXPLOSION_LARGE("largeexplode", 1, true),
        EXPLOSION_HUGE("hugeexplosion", 2, true),
        FIREWORKS_SPARK("fireworksSpark", 3, false),
        WATER_BUBBLE("bubble", 4, false),
        WATER_SPLASH("splash", 5, false),
        WATER_WAKE("wake", 6, false),
        SUSPENDED("suspended", 7, false),
        SUSPENDED_DEPTH("depthsuspend", 8, false),
        CRIT("crit", 9, false),
        CRIT_MAGIC("magicCrit", 10, false),
        SMOKE_NORMAL("smoke", 11, false),
        SMOKE_LARGE("largesmoke", 12, false),
        SPELL("spell", 13, false),
        SPELL_INSTANT("instantSpell", 14, false),
        SPELL_MOB("mobSpell", 15, false),
        SPELL_MOB_AMBIENT("mobSpellAmbient", 16, false),
        SPELL_WITCH("witchMagic", 17, false),
        DRIP_WATER("dripWater", 18, false),
        DRIP_LAVA("dripLava", 19, false),
        VILLAGER_ANGRY("angryVillager", 20, false),
        VILLAGER_HAPPY("happyVillager", 21, false),
        TOWN_AURA("townaura", 22, false),
        NOTE("note", 23, false),
        PORTAL("portal", 24, false),
        ENCHANTMENT_TABLE("enchantmenttable", 25, false),
        FLAME("flame", 26, false),
        LAVA("lava", 27, false),
        FOOTSTEP("footstep", 28, false),
        CLOUD("cloud", 29, false),
        REDSTONE("reddust", 30, false),
        SNOWBALL("snowballpoof", 31, false),
        SNOW_SHOVEL("snowshovel", 32, false),
        SLIME("slime", 33, false),
        HEART("heart", 34, false),
        BARRIER("barrier", 35, false),
        ITEM_CRACK("iconcrack_", 36, false, 2),
        BLOCK_CRACK("blockcrack_", 37, false, 1),
        BLOCK_DUST("blockdust_", 38, false, 1),
        WATER_DROP("droplet", 39, false),
        ITEM_TAKE("take", 40, false),
        MOB_APPEARANCE("mobappearance", 41, true);

        private static final Map<String, Particle> BY_NAME;
        private static final Map<Integer, Particle> BY_ID;
        private final String name;
        private final int id;
        private final boolean longDistance;
        private final int dataLength;

        private Particle(String name, int id, boolean longDistance) {
            this(name, id, longDistance, 0);
        }

        private Particle(String name, int id, boolean longDistance, int dataLength) {
            this.name = name;
            this.id = id;
            this.longDistance = longDistance;
            this.dataLength = dataLength;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public boolean isLongDistance() {
            return this.longDistance;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public static Particle getByName(String name) {
            return BY_NAME.get(name.toLowerCase());
        }

        public static Particle getById(int id) {
            return BY_ID.get(id);
        }

        static {
            BY_ID = new HashMap<Integer, Particle>();
            BY_NAME = new HashMap<String, Particle>();
            for (Particle particle : Particle.values()) {
                BY_NAME.put(particle.getName().toLowerCase(), particle);
                BY_ID.put(particle.getId(), particle);
            }
        }
    }

    public static enum ScoreboardAction {
        CHANGE,
        REMOVE;

    }

    public static enum PlayerAction {
        START_SNEAKING,
        STOP_SNEAKING,
        STOP_SLEEPING,
        START_SPRINTING,
        STOP_SPRINTING,
        RIDING_JUMP,
        OPEN_INVENTORY;

    }

    public static enum PlayerDigType {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM;

    }

    public static enum CombatEventType {
        ENTER_COMBAT,
        END_COMBAT,
        ENTITY_DIED;

    }

    public static enum WorldBorderAction {
        SET_SIZE,
        LERP_SIZE,
        SET_CENTER,
        INITIALIZE,
        SET_WARNING_TIME,
        SET_WARNING_BLOCKS;

    }

    public static enum TitleAction {
        TITLE,
        SUBTITLE,
        TIMES,
        CLEAR,
        RESET;

    }

    public static enum PlayerInfoAction {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public static enum ResourcePackStatus {
        SUCCESSFULLY_LOADED,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED;

    }

    public static enum NativeGameMode {
        NOT_SET,
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR,
        NONE;


        public GameMode toBukkit() {
            switch (this) {
                case ADVENTURE: {
                    return GameMode.ADVENTURE;
                }
                case CREATIVE: {
                    return GameMode.CREATIVE;
                }
                case SPECTATOR: {
                    return GameMode.SPECTATOR;
                }
                case SURVIVAL: {
                    return GameMode.SURVIVAL;
                }
            }
            return null;
        }

        public static NativeGameMode fromBukkit(GameMode mode) {
            switch (mode) {
                case ADVENTURE: {
                    return ADVENTURE;
                }
                case CREATIVE: {
                    return CREATIVE;
                }
                case SPECTATOR: {
                    return SPECTATOR;
                }
                case SURVIVAL: {
                    return SURVIVAL;
                }
            }
            return null;
        }
    }

    public static enum EntityUseAction {
        INTERACT,
        ATTACK,
        INTERACT_AT;

    }

    public static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

    }

    public static enum ChatVisibility {
        FULL,
        SYSTEM,
        HIDDEN;

    }

    public static enum ClientCommand {
        PERFORM_RESPAWN,
        REQUEST_STATS,
        OPEN_INVENTORY_ACHIEVEMENT;

    }
}

