/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.compat.netty.Netty;
import com.comphenix.protocol.compat.netty.WrappedByteBuf;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class StreamSerializer {
    private static final StreamSerializer DEFAULT = new StreamSerializer();
    private static MethodAccessor READ_ITEM_METHOD;
    private static MethodAccessor WRITE_ITEM_METHOD;
    private static MethodAccessor READ_NBT_METHOD;
    private static MethodAccessor WRITE_NBT_METHOD;
    private static MethodAccessor READ_STRING_METHOD;
    private static MethodAccessor WRITE_STRING_METHOD;

    public static StreamSerializer getDefault() {
        return DEFAULT;
    }

    public void serializeVarInt(@Nonnull DataOutputStream destination, int value) throws IOException {
        Preconditions.checkNotNull((Object)destination, (Object)"source cannot be NULL");
        while ((value & 0xFFFFFF80) != 0) {
            destination.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        destination.writeByte(value);
    }

    public int deserializeVarInt(@Nonnull DataInputStream source) throws IOException {
        byte currentByte;
        Preconditions.checkNotNull((Object)source, (Object)"source cannot be NULL");
        int result = 0;
        int length = 0;
        do {
            currentByte = source.readByte();
            result |= (currentByte & 0x7F) << length++ * 7;
            if (length <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((currentByte & 0x80) == 128);
        return result;
    }

    public void serializeCompound(@Nonnull DataOutputStream output, NbtCompound compound) throws IOException {
        Object handle;
        if (output == null) {
            throw new IllegalArgumentException("Output stream cannot be NULL.");
        }
        Object object = handle = compound != null ? NbtFactory.fromBase(compound).getHandle() : null;
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_NBT_METHOD == null) {
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeNbtCompound", MinecraftReflection.getNBTCompoundClass()));
            }
            WrappedByteBuf buf = Netty.packetWriter(output);
            buf.writeByte(NbtType.TAG_COMPOUND.getRawID());
            WRITE_NBT_METHOD.invoke(buf.getHandle(), handle);
        } else {
            if (WRITE_NBT_METHOD == null) {
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass(), true).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(MinecraftReflection.getNBTBaseClass(), 0).parameterDerivedOf(DataOutput.class, 1).returnTypeVoid().build()));
            }
            WRITE_NBT_METHOD.invoke(null, handle, output);
        }
    }

    public NbtCompound deserializeCompound(@Nonnull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL.");
        }
        Object nmsCompound = null;
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_NBT_METHOD == null) {
                READ_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readNbtCompound", MinecraftReflection.getNBTCompoundClass(), (Class<?>[])new Class[0]));
            }
            nmsCompound = READ_NBT_METHOD.invoke(Netty.packetReader(input).getHandle(), new Object[0]);
        } else {
            if (READ_NBT_METHOD == null) {
                READ_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(DataInput.class).returnDerivedOf(MinecraftReflection.getNBTBaseClass()).build()));
            }
            try {
                nmsCompound = READ_NBT_METHOD.invoke(null, input);
            }
            catch (Exception e) {
                throw new IOException("Cannot read item stack.", e);
            }
        }
        if (nmsCompound != null) {
            return NbtFactory.fromNMSCompound(nmsCompound);
        }
        return null;
    }

    public void serializeString(@Nonnull DataOutputStream output, String text) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output stream cannot be NULL.");
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be NULL.");
        }
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_STRING_METHOD == null) {
                WRITE_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeString", String.class));
            }
            WRITE_STRING_METHOD.invoke(Netty.packetWriter(output).getHandle(), text);
        } else {
            if (WRITE_STRING_METHOD == null) {
                WRITE_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterExactType(String.class, 0).parameterDerivedOf(DataOutput.class, 1).returnTypeVoid().build()));
            }
            WRITE_STRING_METHOD.invoke(null, text, output);
        }
    }

    public String deserializeString(@Nonnull DataInputStream input, int maximumLength) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL.");
        }
        if (maximumLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum length cannot exceed 32767 characters.");
        }
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maximum length cannot be negative.");
        }
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_STRING_METHOD == null) {
                READ_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readString", (Class<?>)String.class, (Class<?>[])new Class[]{Integer.TYPE}));
            }
            return (String)READ_STRING_METHOD.invoke(Netty.packetReader(input).getHandle(), maximumLength);
        }
        if (READ_STRING_METHOD == null) {
            READ_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(DataInput.class, 0).parameterExactType(Integer.TYPE, 1).returnTypeExact(String.class).build()));
        }
        return (String)READ_STRING_METHOD.invoke(null, input, maximumLength);
    }

    public String serializeItemStack(ItemStack stack) throws IOException {
        Object nmsItem = MinecraftReflection.getMinecraftItemStack(stack);
        byte[] bytes = null;
        if (MinecraftReflection.isUsingNetty()) {
            WrappedByteBuf buf = Netty.buffer();
            Object serializer = MinecraftReflection.getPacketDataSerializer(buf.getHandle());
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeStack", MinecraftReflection.getItemStackClass()));
            }
            WRITE_ITEM_METHOD.invoke(serializer, nmsItem);
            bytes = buf.array();
        } else {
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(MinecraftReflection.getItemStackClass(), 0).parameterDerivedOf(DataOutput.class, 1).build()));
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            WRITE_ITEM_METHOD.invoke(null, nmsItem, dataOutput);
            bytes = outputStream.toByteArray();
        }
        return Base64Coder.encodeLines((byte[])bytes);
    }

    public ItemStack deserializeItemStack(String input) throws IOException {
        Validate.notNull((Object)input, (String)"input cannot be null!");
        Object nmsItem = null;
        byte[] bytes = Base64Coder.decodeLines((String)input);
        if (MinecraftReflection.isUsingNetty()) {
            WrappedByteBuf buf = Netty.copiedBuffer(bytes);
            Object serializer = MinecraftReflection.getPacketDataSerializer(buf.getHandle());
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readItemStack", MinecraftReflection.getItemStackClass(), (Class<?>[])new Class[0]));
            }
            nmsItem = READ_ITEM_METHOD.invoke(serializer, new Object[0]);
        } else {
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(DataInput.class).returnDerivedOf(MinecraftReflection.getItemStackClass()).build()));
            }
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            DataInputStream inputStream = new DataInputStream(byteStream);
            nmsItem = READ_ITEM_METHOD.invoke(null, inputStream);
        }
        return nmsItem != null ? MinecraftReflection.getBukkitItemStack(nmsItem) : null;
    }

    public void serializeItemStack(DataOutputStream output, ItemStack stack) throws IOException {
        Validate.notNull((Object)"output cannot be null!");
        Object nmsItem = MinecraftReflection.getMinecraftItemStack(stack);
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeStack", MinecraftReflection.getItemStackClass()));
            }
            WrappedByteBuf buf = Netty.buffer();
            Object serializer = MinecraftReflection.getPacketDataSerializer(buf.getHandle());
            WRITE_ITEM_METHOD.invoke(serializer, nmsItem);
            output.write(buf.array());
        } else {
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(MinecraftReflection.getItemStackClass(), 0).parameterDerivedOf(DataOutput.class, 1).build()));
            }
            WRITE_ITEM_METHOD.invoke(null, nmsItem, output);
        }
    }

    @Deprecated
    public ItemStack deserializeItemStack(DataInputStream input) throws IOException {
        Validate.notNull((Object)input, (String)"input cannot be null!");
        Object nmsItem = null;
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readItemStack", MinecraftReflection.getItemStackClass(), (Class<?>[])new Class[0]));
            }
            byte[] bytes = new byte[8192];
            input.read(bytes);
            WrappedByteBuf buf = Netty.copiedBuffer(bytes);
            Object serializer = MinecraftReflection.getPacketDataSerializer(buf.getHandle());
            nmsItem = READ_ITEM_METHOD.invoke(serializer, new Object[0]);
        } else {
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(DataInput.class).returnDerivedOf(MinecraftReflection.getItemStackClass()).build()));
            }
            nmsItem = READ_ITEM_METHOD.invoke(null, input);
        }
        if (nmsItem != null) {
            return MinecraftReflection.getBukkitItemStack(nmsItem);
        }
        return null;
    }
}

