/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.PluginContext;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.compiler.BackgroundCompiler;
import com.comphenix.protocol.reflect.instances.BannedGenerator;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class StructureModifier<TField> {
    protected Class targetType;
    protected Object target;
    protected EquivalentConverter<TField> converter;
    protected Class fieldType;
    protected List<Field> data = new ArrayList<Field>();
    protected Map<Field, Integer> defaultFields;
    protected Map<Class, StructureModifier> subtypeCache;
    protected boolean customConvertHandling;
    protected boolean useStructureCompiler;
    private static DefaultInstances DEFAULT_GENERATOR = StructureModifier.getDefaultGenerator();

    private static DefaultInstances getDefaultGenerator() {
        ArrayList providers = Lists.newArrayList();
        providers.add(new BannedGenerator(MinecraftReflection.getItemStackClass(), MinecraftReflection.getBlockClass()));
        providers.addAll(DefaultInstances.DEFAULT.getRegistered());
        return DefaultInstances.fromCollection(providers);
    }

    public StructureModifier(Class targetType) {
        this(targetType, null, true);
    }

    public StructureModifier(Class targetType, boolean useStructureCompiler) {
        this(targetType, null, true, useStructureCompiler);
    }

    public StructureModifier(Class targetType, Class superclassExclude, boolean requireDefault) {
        this(targetType, superclassExclude, requireDefault, true);
    }

    public StructureModifier(Class targetType, Class superclassExclude, boolean requireDefault, boolean useStructureCompiler) {
        List<Field> fields = StructureModifier.getFields(targetType, superclassExclude);
        HashMap<Field, Integer> defaults = requireDefault ? StructureModifier.generateDefaultFields(fields) : new HashMap<Field, Integer>();
        this.initialize(targetType, Object.class, fields, defaults, null, new ConcurrentHashMap<Class, StructureModifier>(), useStructureCompiler);
    }

    protected StructureModifier() {
    }

    protected void initialize(StructureModifier<TField> other) {
        this.initialize(other.targetType, other.fieldType, other.data, other.defaultFields, other.converter, other.subtypeCache, other.useStructureCompiler);
    }

    protected void initialize(Class targetType, Class fieldType, List<Field> data, Map<Field, Integer> defaultFields, EquivalentConverter<TField> converter, Map<Class, StructureModifier> subTypeCache) {
        this.initialize(targetType, fieldType, data, defaultFields, converter, subTypeCache, true);
    }

    protected void initialize(Class targetType, Class fieldType, List<Field> data, Map<Field, Integer> defaultFields, EquivalentConverter<TField> converter, Map<Class, StructureModifier> subTypeCache, boolean useStructureCompiler) {
        this.targetType = targetType;
        this.fieldType = fieldType;
        this.data = data;
        this.defaultFields = defaultFields;
        this.converter = converter;
        this.subtypeCache = subTypeCache;
        this.useStructureCompiler = useStructureCompiler;
    }

    public TField read(int fieldIndex) throws FieldAccessException {
        try {
            return this.readInternal(fieldIndex);
        }
        catch (FieldAccessException ex) {
            String plugin = PluginContext.getPluginCaller(ex);
            if (ProtocolLibrary.INCOMPATIBLE.contains(plugin)) {
                ProtocolLibrary.log(Level.WARNING, "Encountered an exception caused by incompatible plugin {0}.", plugin);
                ProtocolLibrary.log(Level.WARNING, "It is advised that you remove it.", new Object[0]);
            }
            throw ex;
        }
    }

    private TField readInternal(int fieldIndex) throws FieldAccessException {
        if (this.target == null) {
            throw new IllegalStateException("Cannot read from a null target!");
        }
        if (fieldIndex < 0) {
            throw new FieldAccessException(String.format("Field index (%s) cannot be negative.", fieldIndex));
        }
        if (this.data.size() == 0) {
            throw new FieldAccessException(String.format("No field with type %s exists in class %s.", this.fieldType.getName(), this.target.getClass().getSimpleName()));
        }
        if (fieldIndex >= this.data.size()) {
            throw new FieldAccessException(String.format("Field index out of bounds. (Index: %s, Size: %s)", fieldIndex, this.data.size()));
        }
        try {
            Object result = FieldUtils.readField(this.data.get(fieldIndex), this.target, true);
            if (this.needConversion()) {
                return this.converter.getSpecific(result);
            }
            return (TField)result;
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot read field due to a security limitation.", e);
        }
    }

    public TField readSafely(int fieldIndex) throws FieldAccessException {
        if (fieldIndex >= 0 && fieldIndex < this.data.size()) {
            return this.read(fieldIndex);
        }
        return null;
    }

    public boolean isReadOnly(int fieldIndex) {
        return Modifier.isFinal(this.getField(fieldIndex).getModifiers());
    }

    public boolean isPublic(int fieldIndex) {
        return Modifier.isPublic(this.getField(fieldIndex).getModifiers());
    }

    public void setReadOnly(int fieldIndex, boolean value) throws FieldAccessException {
        if (fieldIndex < 0 || fieldIndex >= this.data.size()) {
            throw new IllegalArgumentException("Index parameter is not within [0 - " + this.data.size() + ")");
        }
        try {
            StructureModifier.setFinalState(this.data.get(fieldIndex), value);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot write read only status due to a security limitation.", e);
        }
    }

    protected static void setFinalState(Field field, boolean isReadOnly) throws IllegalAccessException {
        if (isReadOnly) {
            FieldUtils.writeField((Object)field, "modifiers", (Object)(field.getModifiers() | 0x10), true);
        } else {
            FieldUtils.writeField((Object)field, "modifiers", (Object)(field.getModifiers() & 0xFFFFFFEF), true);
        }
    }

    public StructureModifier<TField> write(int fieldIndex, TField value) throws FieldAccessException {
        try {
            return this.writeInternal(fieldIndex, value);
        }
        catch (FieldAccessException ex) {
            String plugin = PluginContext.getPluginCaller(ex);
            if (ProtocolLibrary.INCOMPATIBLE.contains(plugin)) {
                ProtocolLibrary.log(Level.WARNING, "Encountered an exception caused by incompatible plugin {0}.", plugin);
                ProtocolLibrary.log(Level.WARNING, "It is advised that you remove it.", new Object[0]);
            }
            throw ex;
        }
    }

    private StructureModifier<TField> writeInternal(int fieldIndex, TField value) throws FieldAccessException {
        if (this.target == null) {
            throw new IllegalStateException("Cannot read from a null target!");
        }
        if (fieldIndex < 0) {
            throw new FieldAccessException(String.format("Field index (%s) cannot be negative.", fieldIndex));
        }
        if (this.data.size() == 0) {
            throw new FieldAccessException(String.format("No field with type %s exists in class %s.", this.fieldType.getName(), this.target.getClass().getSimpleName()));
        }
        if (fieldIndex >= this.data.size()) {
            throw new FieldAccessException(String.format("Field index out of bounds. (Index: %s, Size: %s)", fieldIndex, this.data.size()));
        }
        TField obj = this.needConversion() ? this.converter.getGeneric(this.getFieldType(fieldIndex), value) : value;
        try {
            FieldUtils.writeField(this.data.get(fieldIndex), this.target, obj, true);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot read field due to a security limitation.", e);
        }
        return this;
    }

    protected Class<?> getFieldType(int index) {
        return this.data.get(index).getType();
    }

    private final boolean needConversion() {
        return this.converter != null && !this.customConvertHandling;
    }

    public StructureModifier<TField> writeSafely(int fieldIndex, TField value) throws FieldAccessException {
        if (fieldIndex >= 0 && fieldIndex < this.data.size()) {
            this.write(fieldIndex, value);
        }
        return this;
    }

    public StructureModifier<TField> modify(int fieldIndex, Function<TField, TField> select) throws FieldAccessException {
        TField value = this.read(fieldIndex);
        return this.write(fieldIndex, select.apply(value));
    }

    public <T> StructureModifier<T> withType(Class fieldType) {
        return this.withType(fieldType, null);
    }

    public StructureModifier<TField> writeDefaults() throws FieldAccessException {
        DefaultInstances generator = DefaultInstances.DEFAULT;
        for (Field field : this.defaultFields.keySet()) {
            try {
                if (field.getType().getCanonicalName().equals("net.md_5.bungee.api.chat.BaseComponent[]")) {
                    FieldUtils.writeField(field, this.target, null, true);
                    continue;
                }
                FieldUtils.writeField(field, this.target, generator.getDefault(field.getType()), true);
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException("Cannot write to field due to a security limitation.", e);
            }
        }
        return this;
    }

    public <T> StructureModifier<T> withType(Class fieldType, EquivalentConverter<T> converter) {
        StructureModifier<Object> result = this.subtypeCache.get(fieldType);
        if (result == null) {
            ArrayList<Field> filtered = new ArrayList<Field>();
            HashMap<Field, Integer> defaults = new HashMap<Field, Integer>();
            int index = 0;
            for (Field field : this.data) {
                if (fieldType != null && fieldType.isAssignableFrom(field.getType())) {
                    filtered.add(field);
                    if (this.defaultFields.containsKey(field)) {
                        defaults.put(field, index);
                    }
                }
                ++index;
            }
            result = this.withFieldType(fieldType, filtered, defaults);
            if (fieldType != null) {
                this.subtypeCache.put(fieldType, result);
                if (this.useStructureCompiler && BackgroundCompiler.getInstance() != null) {
                    BackgroundCompiler.getInstance().scheduleCompilation(this.subtypeCache, fieldType);
                }
            }
        }
        result = result.withTarget(this.target);
        if (!Objects.equal(result.converter, converter)) {
            result = super.withConverter(converter);
        }
        return result;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public Class getTargetType() {
        return this.targetType;
    }

    public Object getTarget() {
        return this.target;
    }

    public int size() {
        return this.data.size();
    }

    protected <T> StructureModifier<T> withFieldType(Class fieldType, List<Field> filtered, Map<Field, Integer> defaults) {
        return this.withFieldType(fieldType, filtered, defaults, null);
    }

    protected <T> StructureModifier<T> withFieldType(Class fieldType, List<Field> filtered, Map<Field, Integer> defaults, EquivalentConverter<T> converter) {
        StructureModifier<T> result = new StructureModifier<T>();
        result.initialize(this.targetType, fieldType, filtered, defaults, converter, new ConcurrentHashMap<Class, StructureModifier>(), this.useStructureCompiler);
        return result;
    }

    public StructureModifier<TField> withTarget(Object target) {
        StructureModifier<TField> copy = new StructureModifier<TField>();
        copy.initialize(this);
        copy.target = target;
        return copy;
    }

    private <T> StructureModifier<T> withConverter(EquivalentConverter<T> converter) {
        StructureModifier<T> copy = this.withTarget(this.target);
        copy.setConverter(converter);
        return copy;
    }

    protected void setConverter(EquivalentConverter<TField> converter) {
        this.converter = converter;
    }

    public List<Field> getFields() {
        return ImmutableList.copyOf(this.data);
    }

    public Field getField(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.data.size()) {
            throw new IllegalArgumentException("Index parameter is not within [0 - " + this.data.size() + ")");
        }
        return this.data.get(fieldIndex);
    }

    public List<TField> getValues() throws FieldAccessException {
        ArrayList<TField> values = new ArrayList<TField>();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.read(i));
        }
        return values;
    }

    private static Map<Field, Integer> generateDefaultFields(List<Field> fields) {
        HashMap<Field, Integer> requireDefaults = new HashMap<Field, Integer>();
        DefaultInstances generator = DEFAULT_GENERATOR;
        int index = 0;
        for (Field field : fields) {
            Class<?> type = field.getType();
            int modifier = field.getModifiers();
            if (!type.isPrimitive() && !Modifier.isFinal(modifier) && generator.getDefault(type) != null) {
                requireDefaults.put(field, index);
            }
            ++index;
        }
        return requireDefaults;
    }

    private static List<Field> getFields(Class type, Class superclassExclude) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : FuzzyReflection.fromClass(type, true).getDeclaredFields(superclassExclude)) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || superclassExclude != null && field.getDeclaringClass().equals(superclassExclude)) continue;
            result.add(field);
        }
        return result;
    }

    public String toString() {
        return "StructureModifier[fieldType=" + this.fieldType + ", data=" + this.data + "]";
    }
}

