/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.compat.netty.LegacyProtocolRegistry;
import com.comphenix.protocol.compat.netty.independent.NettyProtocolRegistry;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.injector.packet.LegacyPacketRegistry;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.TroveWrapper;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PacketRegistry {
    public static final ReportType REPORT_CANNOT_CORRECT_TROVE_MAP = new ReportType("Unable to correct no entry value.");
    public static final ReportType REPORT_INSUFFICIENT_SERVER_PACKETS = new ReportType("Too few server packets detected: %s");
    public static final ReportType REPORT_INSUFFICIENT_CLIENT_PACKETS = new ReportType("Too few client packets detected: %s");
    private static volatile LegacyPacketRegistry LEGACY;
    private static volatile ProtocolRegistry NETTY;
    private static volatile Set<PacketType> NETTY_SERVER_PACKETS;
    private static volatile Set<PacketType> NETTY_CLIENT_PACKETS;
    private static volatile Set<Integer> LEGACY_SERVER_PACKETS;
    private static volatile Set<Integer> LEGACY_CLIENT_PACKETS;
    private static volatile Map<Integer, Class> LEGACY_PREVIOUS_PACKETS;
    private static boolean INITIALIZED;

    private static void initialize() {
        if (INITIALIZED) {
            if (NETTY == null && LEGACY == null) {
                throw new IllegalStateException("No initialized registry.");
            }
            return;
        }
        if (MinecraftReflection.isUsingNetty()) {
            if (NETTY == null) {
                NETTY = MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.BOUNTIFUL_UPDATE) ? new NettyProtocolRegistry() : new LegacyProtocolRegistry();
            }
        } else {
            PacketRegistry.initializeLegacy();
        }
    }

    public static boolean isSupported(PacketType type) {
        PacketRegistry.initialize();
        if (NETTY != null) {
            return NETTY.getPacketTypeLookup().containsKey(type);
        }
        return type.isClient() ? LEGACY.getClientPackets().contains(type.getLegacyId()) : LEGACY.getServerPackets().contains(type.getLegacyId());
    }

    private static void initializeLegacy() {
        if (LEGACY == null) {
            try {
                LEGACY = new LegacyPacketRegistry();
                LEGACY.initialize();
            }
            catch (LegacyPacketRegistry.InsufficientPacketsException e) {
                if (e.isClient()) {
                    ProtocolLibrary.getErrorReporter().reportWarning(PacketRegistry.class, Report.newBuilder(REPORT_INSUFFICIENT_CLIENT_PACKETS).messageParam(e.getPacketCount()));
                } else {
                    ProtocolLibrary.getErrorReporter().reportWarning(PacketRegistry.class, Report.newBuilder(REPORT_INSUFFICIENT_SERVER_PACKETS).messageParam(e.getPacketCount()));
                }
            }
            catch (TroveWrapper.CannotFindTroveNoEntryValue e) {
                ProtocolLibrary.getErrorReporter().reportWarning(PacketRegistry.class, Report.newBuilder(REPORT_CANNOT_CORRECT_TROVE_MAP).error(e.getCause()));
            }
        }
    }

    @Deprecated
    public static Map<Class, Integer> getPacketToID() {
        PacketRegistry.initialize();
        if (NETTY != null) {
            Map result = Maps.transformValues(NETTY.getPacketClassLookup(), (Function)new Function<PacketType, Integer>(){

                public Integer apply(PacketType type) {
                    return type.getLegacyId();
                }
            });
            return result;
        }
        return LEGACY.getPacketToID();
    }

    public static Map<Class, PacketType> getPacketToType() {
        PacketRegistry.initialize();
        if (NETTY != null) {
            Map<Class, PacketType> result = NETTY.getPacketClassLookup();
            return result;
        }
        return Maps.transformValues(LEGACY.getPacketToID(), (Function)new Function<Integer, PacketType>(){

            public PacketType apply(Integer packetId) {
                return PacketType.findLegacy(packetId);
            }
        });
    }

    @Deprecated
    public static Map<Integer, Class> getOverwrittenPackets() {
        PacketRegistry.initialize();
        if (LEGACY != null) {
            return LEGACY.getOverwrittenPackets();
        }
        throw new IllegalStateException("Not supported on Netty.");
    }

    @Deprecated
    public static Map<Integer, Class> getPreviousPackets() {
        PacketRegistry.initialize();
        if (NETTY != null) {
            if (LEGACY_PREVIOUS_PACKETS == null) {
                HashMap map = Maps.newHashMap();
                for (Map.Entry<PacketType, Class<?>> entry : NETTY.getPacketTypeLookup().entrySet()) {
                    map.put(entry.getKey().getLegacyId(), entry.getValue());
                }
                LEGACY_PREVIOUS_PACKETS = Collections.unmodifiableMap(map);
            }
            return LEGACY_PREVIOUS_PACKETS;
        }
        return LEGACY.getPreviousPackets();
    }

    @Deprecated
    public static Set<Integer> getServerPackets() throws FieldAccessException {
        PacketRegistry.initialize();
        if (NETTY != null) {
            if (LEGACY_SERVER_PACKETS == null) {
                LEGACY_SERVER_PACKETS = PacketRegistry.toLegacy(NETTY.getServerPackets());
            }
            return LEGACY_SERVER_PACKETS;
        }
        return LEGACY.getServerPackets();
    }

    public static Set<PacketType> getServerPacketTypes() {
        PacketRegistry.initialize();
        if (NETTY != null) {
            NETTY.synchronize();
            return NETTY.getServerPackets();
        }
        if (NETTY_SERVER_PACKETS == null) {
            NETTY_SERVER_PACKETS = PacketRegistry.toPacketTypes(LEGACY.getServerPackets(), PacketType.Sender.SERVER);
        }
        return NETTY_SERVER_PACKETS;
    }

    @Deprecated
    public static Set<Integer> getClientPackets() throws FieldAccessException {
        PacketRegistry.initialize();
        if (NETTY != null) {
            if (LEGACY_CLIENT_PACKETS == null) {
                LEGACY_CLIENT_PACKETS = PacketRegistry.toLegacy(NETTY.getClientPackets());
            }
            return LEGACY_CLIENT_PACKETS;
        }
        return LEGACY.getClientPackets();
    }

    public static Set<PacketType> getClientPacketTypes() {
        PacketRegistry.initialize();
        if (NETTY != null) {
            NETTY.synchronize();
            return NETTY.getClientPackets();
        }
        if (NETTY_CLIENT_PACKETS == null) {
            NETTY_CLIENT_PACKETS = PacketRegistry.toPacketTypes(LEGACY.getClientPackets(), PacketType.Sender.CLIENT);
        }
        return NETTY_CLIENT_PACKETS;
    }

    public static Set<Integer> toLegacy(Set<PacketType> types) {
        HashSet result = Sets.newHashSet();
        for (PacketType type : types) {
            result.add(type.getLegacyId());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<PacketType> toPacketTypes(Set<Integer> ids) {
        return PacketRegistry.toPacketTypes(ids, null);
    }

    public static Set<PacketType> toPacketTypes(Set<Integer> ids, PacketType.Sender preference) {
        HashSet result = Sets.newHashSet();
        for (int id : ids) {
            result.add(PacketType.fromLegacy(id, preference));
        }
        return Collections.unmodifiableSet(result);
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID) {
        PacketRegistry.initialize();
        if (NETTY != null) {
            return NETTY.getPacketTypeLookup().get(PacketType.findLegacy(packetID));
        }
        return LEGACY.getPacketClassFromID(packetID);
    }

    public static Class getPacketClassFromType(PacketType type) {
        return PacketRegistry.getPacketClassFromType(type, false);
    }

    public static Class getPacketClassFromType(PacketType type, boolean forceVanilla) {
        PacketRegistry.initialize();
        if (NETTY != null) {
            return NETTY.getPacketTypeLookup().get(type);
        }
        return LEGACY.getPacketClassFromID(type.getLegacyId(), forceVanilla);
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID, boolean forceVanilla) {
        PacketRegistry.initialize();
        if (LEGACY != null) {
            return LEGACY.getPacketClassFromID(packetID, forceVanilla);
        }
        return PacketRegistry.getPacketClassFromID(packetID);
    }

    @Deprecated
    public static int getPacketID(Class<?> packet) {
        PacketRegistry.initialize();
        if (NETTY != null) {
            return NETTY.getPacketClassLookup().get(packet).getLegacyId();
        }
        return LEGACY.getPacketID(packet);
    }

    public static PacketType getPacketType(Class<?> packet) {
        return PacketRegistry.getPacketType(packet, null);
    }

    public static PacketType getPacketType(Class<?> packet, PacketType.Sender sender) {
        PacketRegistry.initialize();
        if (NETTY != null) {
            return NETTY.getPacketClassLookup().get(packet);
        }
        int id = LEGACY.getPacketID(packet);
        return PacketType.hasLegacy(id) ? PacketType.fromLegacy(id, sender) : null;
    }
}

