/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.error;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.collections.ExpireHashMap;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.reflect.PrettyPrinter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DetailedErrorReporter
implements ErrorReporter {
    public static final ReportType REPORT_EXCEPTION_COUNT = new ReportType("Internal exception count: %s!");
    public static final String SECOND_LEVEL_PREFIX = "  ";
    public static final String DEFAULT_PREFIX = "  ";
    public static final String DEFAULT_SUPPORT_URL = "https://github.com/dmulloy2/ProtocolLib/issues";
    public static final String ERROR_PERMISSION = "protocol.info";
    public static final int DEFAULT_MAX_ERROR_COUNT = 20;
    private ConcurrentMap<String, AtomicInteger> warningCount = new ConcurrentHashMap<String, AtomicInteger>();
    protected String prefix;
    protected String supportURL;
    protected AtomicInteger internalErrorCount = new AtomicInteger();
    protected int maxErrorCount;
    protected Logger logger;
    protected WeakReference<Plugin> pluginReference;
    protected String pluginName;
    protected static boolean apacheCommonsMissing;
    protected boolean detailedReporting;
    protected Map<String, Object> globalParameters = new HashMap<String, Object>();
    private ExpireHashMap<Report, Boolean> rateLimited = new ExpireHashMap();
    private Object rateLock = new Object();

    public DetailedErrorReporter(Plugin plugin) {
        this(plugin, "  ", DEFAULT_SUPPORT_URL);
    }

    public DetailedErrorReporter(Plugin plugin, String prefix, String supportURL) {
        this(plugin, prefix, supportURL, 20, DetailedErrorReporter.getBukkitLogger());
    }

    public DetailedErrorReporter(Plugin plugin, String prefix, String supportURL, int maxErrorCount, Logger logger) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be NULL.");
        }
        this.pluginReference = new WeakReference<Plugin>(plugin);
        this.pluginName = this.getNameSafely(plugin);
        this.prefix = prefix;
        this.supportURL = supportURL;
        this.maxErrorCount = maxErrorCount;
        this.logger = logger;
    }

    private String getNameSafely(Plugin plugin) {
        try {
            return plugin.getName();
        }
        catch (LinkageError e) {
            return "ProtocolLib";
        }
    }

    private static Logger getBukkitLogger() {
        try {
            return Bukkit.getLogger();
        }
        catch (LinkageError e) {
            return Logger.getLogger("Minecraft");
        }
    }

    public boolean isDetailedReporting() {
        return this.detailedReporting;
    }

    public void setDetailedReporting(boolean detailedReporting) {
        this.detailedReporting = detailedReporting;
    }

    @Override
    public void reportMinimal(Plugin sender, String methodName, Throwable error, Object ... parameters) {
        if (this.reportMinimalNoSpam(sender, methodName, error) && parameters != null && parameters.length > 0) {
            this.logger.log(Level.SEVERE, this.printParameters(parameters));
        }
    }

    @Override
    public void reportMinimal(Plugin sender, String methodName, Throwable error) {
        this.reportMinimalNoSpam(sender, methodName, error);
    }

    public boolean reportMinimalNoSpam(Plugin sender, String methodName, Throwable error) {
        int errorCount;
        AtomicInteger created;
        String pluginName = PacketAdapter.getPluginName(sender);
        AtomicInteger counter = (AtomicInteger)this.warningCount.get(pluginName);
        if (counter == null && (counter = this.warningCount.putIfAbsent(pluginName, created = new AtomicInteger())) == null) {
            counter = created;
        }
        if ((errorCount = counter.incrementAndGet()) < this.getMaxErrorCount()) {
            this.logger.log(Level.SEVERE, "[" + pluginName + "] Unhandled exception occured in " + methodName + " for " + pluginName, error);
            return true;
        }
        if (this.isPowerOfTwo(errorCount)) {
            this.logger.log(Level.SEVERE, "[" + pluginName + "] Unhandled exception number " + errorCount + " occured in " + methodName + " for " + pluginName, error);
        }
        return false;
    }

    private boolean isPowerOfTwo(int number) {
        return (number & number - 1) == 0;
    }

    @Override
    public void reportDebug(Object sender, Report.ReportBuilder builder) {
        this.reportDebug(sender, ((Report.ReportBuilder)Preconditions.checkNotNull((Object)builder, (Object)"builder cannot be NULL")).build());
    }

    @Override
    public void reportDebug(Object sender, Report report) {
        if (this.logger.isLoggable(Level.FINE) && this.canReport(report)) {
            this.reportLevel(Level.FINE, sender, report);
        }
    }

    @Override
    public void reportWarning(Object sender, Report.ReportBuilder reportBuilder) {
        if (reportBuilder == null) {
            throw new IllegalArgumentException("reportBuilder cannot be NULL.");
        }
        this.reportWarning(sender, reportBuilder.build());
    }

    @Override
    public void reportWarning(Object sender, Report report) {
        if (this.logger.isLoggable(Level.WARNING) && this.canReport(report)) {
            this.reportLevel(Level.WARNING, sender, report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canReport(Report report) {
        long rateLimit = report.getRateLimit();
        if (rateLimit > 0L) {
            Object object = this.rateLock;
            synchronized (object) {
                if (this.rateLimited.containsKey(report)) {
                    return false;
                }
                this.rateLimited.put(report, true, rateLimit, TimeUnit.NANOSECONDS);
            }
        }
        return true;
    }

    private void reportLevel(Level level, Object sender, Report report) {
        String message = "[" + this.pluginName + "] [" + this.getSenderName(sender) + "] " + report.getReportMessage();
        if (report.getException() != null) {
            this.logger.log(level, message, report.getException());
        } else {
            this.logger.log(level, message);
            if (this.detailedReporting) {
                this.printCallStack(level, this.logger);
            }
        }
        if (report.hasCallerParameters()) {
            this.logger.log(level, this.printParameters(report.getCallerParameters()));
        }
    }

    private String getSenderName(Object sender) {
        if (sender != null) {
            return ReportType.getSenderClass(sender).getSimpleName();
        }
        return "NULL";
    }

    @Override
    public void reportDetailed(Object sender, Report.ReportBuilder reportBuilder) {
        this.reportDetailed(sender, reportBuilder.build());
    }

    @Override
    public void reportDetailed(Object sender, Report report) {
        Plugin plugin = (Plugin)this.pluginReference.get();
        int errorCount = this.internalErrorCount.incrementAndGet();
        if (errorCount > this.getMaxErrorCount()) {
            if (this.isPowerOfTwo(errorCount)) {
                this.reportWarning((Object)this, Report.newBuilder(REPORT_EXCEPTION_COUNT).messageParam(errorCount).build());
            } else {
                return;
            }
        }
        if (!this.canReport(report)) {
            return;
        }
        StringWriter text = new StringWriter();
        PrintWriter writer = new PrintWriter(text);
        writer.println("[" + this.pluginName + "] INTERNAL ERROR: " + report.getReportMessage());
        writer.println("If this problem hasn't already been reported, please open a ticket");
        writer.println("at " + this.supportURL + " with the following data:");
        writer.println("Stack Trace:");
        if (report.getException() != null) {
            report.getException().printStackTrace(writer);
        } else if (this.detailedReporting) {
            this.printCallStack(writer);
        }
        writer.println("Dump:");
        if (report.hasCallerParameters()) {
            this.printParameters(writer, report.getCallerParameters());
        }
        for (String param : this.globalParameters()) {
            writer.println("  " + param + ":");
            writer.println(this.addPrefix(DetailedErrorReporter.getStringDescription(this.getGlobalParameter(param)), "    "));
        }
        writer.println("Sender:");
        writer.println(this.addPrefix(DetailedErrorReporter.getStringDescription(sender), "  "));
        if (plugin != null) {
            writer.println("Version:");
            writer.println(this.addPrefix(plugin.toString(), "  "));
        }
        writer.println("Java Version:");
        writer.println(this.addPrefix(System.getProperty("java.version"), "  "));
        if (Bukkit.getServer() != null) {
            writer.println("Server:");
            writer.println(this.addPrefix(Bukkit.getServer().getVersion(), "  "));
            if (ERROR_PERMISSION != null) {
                Bukkit.getServer().broadcast(String.format("Error %s (%s) occured in %s.", report.getReportMessage(), report.getException(), sender), ERROR_PERMISSION);
            }
        }
        this.logger.severe(this.addPrefix(text.toString(), this.prefix));
    }

    private void printCallStack(Level level, Logger logger) {
        StringWriter text = new StringWriter();
        this.printCallStack(new PrintWriter(text));
        logger.log(level, text.toString());
    }

    private void printCallStack(PrintWriter writer) {
        Exception current = new Exception("Not an error! This is the call stack.");
        current.printStackTrace(writer);
    }

    private String printParameters(Object ... parameters) {
        StringWriter writer = new StringWriter();
        this.printParameters(new PrintWriter(writer), parameters);
        return writer.toString();
    }

    private void printParameters(PrintWriter writer, Object[] parameters) {
        writer.println("Parameters: ");
        for (Object param : parameters) {
            writer.println(this.addPrefix(DetailedErrorReporter.getStringDescription(param), "  "));
        }
    }

    protected String addPrefix(String text, String prefix) {
        return text.replaceAll("(?m)^", prefix);
    }

    public static String getStringDescription(Object value) {
        if (value == null) {
            return "[NULL]";
        }
        if (DetailedErrorReporter.isSimpleType(value) || value instanceof Class) {
            return value.toString();
        }
        try {
            if (!apacheCommonsMissing) {
                return ToStringBuilder.reflectionToString((Object)value, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE, (boolean)false, null);
            }
        }
        catch (LinkageError ex) {
            apacheCommonsMissing = true;
        }
        catch (Exception e) {
            ProtocolLibrary.log(Level.WARNING, "Cannot convert to a String with Apache: " + e.getMessage(), new Object[0]);
        }
        try {
            return PrettyPrinter.printObject(value, value.getClass(), Object.class);
        }
        catch (IllegalAccessException e) {
            return "[Error: " + e.getMessage() + "]";
        }
    }

    protected static boolean isSimpleType(Object test) {
        return test instanceof String || Primitives.isWrapperType(test.getClass());
    }

    public int getErrorCount() {
        return this.internalErrorCount.get();
    }

    public void setErrorCount(int errorCount) {
        this.internalErrorCount.set(errorCount);
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount;
    }

    public void addGlobalParameter(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be NULL.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be NULL.");
        }
        this.globalParameters.put(key, value);
    }

    public Object getGlobalParameter(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be NULL.");
        }
        return this.globalParameters.get(key);
    }

    public void clearGlobalParameters() {
        this.globalParameters.clear();
    }

    public Set<String> globalParameters() {
        return this.globalParameters.keySet();
    }

    public String getSupportURL() {
        return this.supportURL;
    }

    public void setSupportURL(String supportURL) {
        this.supportURL = supportURL;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

