/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.independent;

import com.comphenix.protocol.compat.netty.NettyCompat;
import com.comphenix.protocol.compat.netty.ProtocolInjector;
import com.comphenix.protocol.compat.netty.WrappedByteBuf;
import com.comphenix.protocol.compat.netty.independent.NettyByteBuf;
import com.comphenix.protocol.compat.netty.independent.NettyByteBufAdapter;
import com.comphenix.protocol.compat.netty.independent.NettyProtocolInjector;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.bukkit.plugin.Plugin;

public class IndependentNetty
implements NettyCompat {
    @Override
    public WrappedByteBuf createPacketBuffer() {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
        try {
            return new NettyByteBuf((ByteBuf)packetSerializer.getConstructor(ByteBuf.class).newInstance(buffer));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    @Override
    public Class<?> getGenericFutureListenerArray() {
        return GenericFutureListener[].class;
    }

    @Override
    public Class<?> getChannelHandlerContext() {
        return ChannelHandlerContext.class;
    }

    @Override
    public String toEncodedText(WrappedServerPing.CompressedImage image) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])image.getDataCopy());
        String computed = "data:" + image.getMime() + ";base64," + Base64.encode((ByteBuf)buffer).toString(Charsets.UTF_8);
        return computed;
    }

    @Override
    public WrappedByteBuf decode(byte[] encoded) {
        return new NettyByteBuf(Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])encoded)));
    }

    @Override
    public ProtocolInjector getProtocolInjector(Plugin plugin, ListenerInvoker invoker, ErrorReporter reporter) {
        return new NettyProtocolInjector(plugin, invoker, reporter);
    }

    @Override
    public WrappedByteBuf packetReader(DataInputStream input) {
        return new NettyByteBuf(NettyByteBufAdapter.packetReader(input));
    }

    @Override
    public WrappedByteBuf packetWriter(DataOutputStream output) {
        return new NettyByteBuf(NettyByteBufAdapter.packetWriter(output));
    }

    @Override
    public WrappedByteBuf copiedBuffer(byte[] array) {
        return new NettyByteBuf(Unpooled.copiedBuffer((byte[])array));
    }

    @Override
    public WrappedByteBuf buffer() {
        return new NettyByteBuf(Unpooled.buffer());
    }
}

