/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.compat.netty.NettyCompat;
import com.comphenix.protocol.compat.netty.ProtocolInjector;
import com.comphenix.protocol.compat.netty.WrappedByteBuf;
import com.comphenix.protocol.compat.netty.independent.IndependentNetty;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class Netty {
    private static NettyCompat compat;

    private static NettyCompat getCompat() {
        return compat;
    }

    public static boolean isIndependent() {
        return compat instanceof IndependentNetty;
    }

    public static WrappedByteBuf createPacketBuffer() {
        return Netty.getCompat().createPacketBuffer();
    }

    public static Class<?> getGenericFutureListenerArray() {
        return Netty.getCompat().getGenericFutureListenerArray();
    }

    public static Class<?> getChannelHandlerContext() {
        return Netty.getCompat().getChannelHandlerContext();
    }

    public static String toEncodedText(WrappedServerPing.CompressedImage image) {
        return Netty.getCompat().toEncodedText(image);
    }

    public static WrappedByteBuf decode(byte[] encoded) {
        return Netty.getCompat().decode(encoded);
    }

    public static ProtocolInjector getProtocolInjector(Plugin library, PacketFilterManager packetFilterManager, ErrorReporter reporter) {
        return Netty.getCompat().getProtocolInjector(library, packetFilterManager, reporter);
    }

    public static WrappedByteBuf packetReader(DataInputStream input) {
        return Netty.getCompat().packetReader(input);
    }

    public static WrappedByteBuf packetWriter(DataOutputStream output) {
        return Netty.getCompat().packetWriter(output);
    }

    public static WrappedByteBuf copiedBuffer(byte[] array) {
        return Netty.getCompat().copiedBuffer(array);
    }

    public static WrappedByteBuf buffer() {
        return Netty.getCompat().buffer();
    }

    static {
        try {
            Class.forName("io.netty.buffer.ByteBuf");
            compat = new IndependentNetty();
        }
        catch (ClassNotFoundException ex) {
            try {
                Class<?> clazz = Class.forName("com.comphenix.protocol.compat.netty.shaded.ShadedNetty");
                compat = (NettyCompat)clazz.newInstance();
            }
            catch (Exception ex1) {
                ProtocolLibrary.log(Level.SEVERE, "Failed to create legacy netty compat:", ex1);
            }
        }
    }
}

