/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.guava;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.compat.guava.GuavaCompat;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class Guava17
implements GuavaCompat {
    @Override
    public <C extends Comparable<C>> Range<C> closedRange(C lower, C upper) {
        return Range.closed(lower, upper);
    }

    @Override
    public <C extends Comparable<C>> Range<C> singletonRange(C singleton) {
        return Range.singleton(singleton);
    }

    @Override
    public Set<Integer> toSet(Range<Integer> range) {
        return ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.integers());
    }

    @Override
    public DataInputStream addHeader(final DataInputStream input, final PacketType type) {
        ByteSource header = new ByteSource(){

            public InputStream openStream() throws IOException {
                byte[] data = new byte[]{(byte)type.getLegacyId()};
                return new ByteArrayInputStream(data);
            }
        };
        ByteSource data = new ByteSource(){

            public InputStream openStream() throws IOException {
                return input;
            }
        };
        try {
            return new DataInputStream(ByteSource.concat((ByteSource[])new ByteSource[]{header, data}).openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add header.", e);
        }
    }
}

