/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.guava;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.compat.guava.Guava17;
import com.comphenix.protocol.compat.guava.GuavaCompat;
import com.google.common.collect.Range;
import java.io.DataInputStream;
import java.util.Set;
import java.util.logging.Level;

public class Guava {
    private static GuavaCompat compat;

    private static GuavaCompat getCompat() {
        return compat;
    }

    public static <C extends Comparable<C>> Range<C> closedRange(C lower, C upper) {
        return Guava.getCompat().closedRange(lower, upper);
    }

    public static <C extends Comparable<C>> Range<C> singleton(C singleton) {
        return Guava.getCompat().singletonRange(singleton);
    }

    public static Set<Integer> toSet(Range<Integer> range) {
        return Guava.getCompat().toSet(range);
    }

    public static DataInputStream addHeader(DataInputStream input, PacketType type) {
        return Guava.getCompat().addHeader(input, type);
    }

    static {
        try {
            Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2));
            compat = new Guava17();
        }
        catch (Throwable ex) {
            try {
                Class<?> clazz = Class.forName("com.comphenix.protocol.compat.guava.Guava10");
                compat = (GuavaCompat)clazz.newInstance();
            }
            catch (Throwable ex1) {
                ProtocolLibrary.log(Level.SEVERE, "Failed to create Guava 10 compat:", ex1);
            }
        }
    }
}

