/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.RangeParser;
import com.comphenix.protocol.compat.guava.Guava;
import com.comphenix.protocol.events.ConnectionSide;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class PacketTypeParser {
    public static final Range<Integer> DEFAULT_MAX_RANGE = Guava.closedRange(0, 255);
    private PacketType.Sender side = null;
    private PacketType.Protocol protocol = null;

    PacketTypeParser() {
    }

    public Set<PacketType> parseTypes(Deque<String> arguments, Range<Integer> defaultRange) {
        HashSet result = Sets.newHashSet();
        this.side = null;
        this.protocol = null;
        while (this.side == null) {
            ConnectionSide connection;
            String arg = arguments.poll();
            if (this.side == null && (connection = this.parseSide(arg)) != null) {
                this.side = connection.getSender();
                continue;
            }
            if (this.protocol == null && (this.protocol = this.parseProtocol(arg)) != null) continue;
            throw new IllegalArgumentException("Specify connection side (CLIENT or SERVER).");
        }
        ArrayList ranges = RangeParser.getRanges(arguments, DEFAULT_MAX_RANGE);
        if (this.protocol != null) {
            Iterator<String> it = arguments.iterator();
            while (it.hasNext()) {
                String name = it.next().toUpperCase();
                Collection<PacketType> names = PacketType.fromName(name);
                for (PacketType type : names) {
                    if (type.getProtocol() != this.protocol || type.getSender() != this.side) continue;
                    result.add(type);
                    it.remove();
                }
            }
        }
        if (ranges.isEmpty() && result.isEmpty()) {
            ranges = Lists.newArrayList();
            ranges.add(defaultRange);
        }
        for (Range<Integer> range : ranges) {
            for (Integer id : Guava.toSet(range)) {
                if (this.protocol == null) {
                    if (!PacketType.hasLegacy(id)) continue;
                    result.add(PacketType.findLegacy(id, this.side));
                    continue;
                }
                if (!PacketType.hasCurrent(this.protocol, this.side, id)) continue;
                result.add(PacketType.findCurrent(this.protocol, this.side, id));
            }
        }
        return result;
    }

    public PacketType.Protocol getLastProtocol() {
        return this.protocol;
    }

    public PacketType.Sender getLastSide() {
        return this.side;
    }

    public ConnectionSide parseSide(String text) {
        if (text == null) {
            return null;
        }
        String candidate = text.toLowerCase();
        if ("client".startsWith(candidate)) {
            return ConnectionSide.CLIENT_SIDE;
        }
        if ("server".startsWith(candidate)) {
            return ConnectionSide.SERVER_SIDE;
        }
        return null;
    }

    public PacketType.Protocol parseProtocol(String text) {
        if (text == null) {
            return null;
        }
        String candidate = text.toLowerCase();
        if ("handshake".equals(candidate) || "handshaking".equals(candidate)) {
            return PacketType.Protocol.HANDSHAKING;
        }
        if ("login".equals(candidate)) {
            return PacketType.Protocol.LOGIN;
        }
        if ("play".equals(candidate) || "game".equals(candidate)) {
            return PacketType.Protocol.PLAY;
        }
        if ("status".equals(candidate)) {
            return PacketType.Protocol.STATUS;
        }
        return null;
    }
}

