/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.ByteBufAdapter;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class StreamSerializer {
    private static final StreamSerializer DEFAULT = new StreamSerializer();
    private static MethodAccessor READ_ITEM_METHOD;
    private static MethodAccessor WRITE_ITEM_METHOD;
    private static MethodAccessor READ_NBT_METHOD;
    private static MethodAccessor WRITE_NBT_METHOD;
    private static MethodAccessor READ_STRING_METHOD;
    private static MethodAccessor WRITE_STRING_METHOD;

    public static StreamSerializer getDefault() {
        return DEFAULT;
    }

    public int deserializeVarInt(@Nonnull DataInputStream source) throws IOException {
        byte currentByte;
        Preconditions.checkNotNull((Object)source, (Object)"source cannot be NULL");
        int result = 0;
        int length = 0;
        do {
            currentByte = source.readByte();
            result |= (currentByte & 0x7F) << length++ * 7;
            if (length <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((currentByte & 0x80) == 128);
        return result;
    }

    public void serializeVarInt(@Nonnull DataOutputStream destination, int value) throws IOException {
        Preconditions.checkNotNull((Object)destination, (Object)"source cannot be NULL");
        while ((value & 0xFFFFFF80) != 0) {
            destination.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        destination.writeByte(value);
    }

    public ItemStack deserializeItemStack(@Nonnull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL.");
        }
        Object nmsItem = null;
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readItemStack", MinecraftReflection.getItemStackClass(), (Class<?>[])new Class[0]));
            }
            nmsItem = READ_ITEM_METHOD.invoke(ByteBufAdapter.packetReader(input), new Object[0]);
        } else {
            if (READ_ITEM_METHOD == null) {
                READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(DataInput.class).returnDerivedOf(MinecraftReflection.getItemStackClass()).build()));
            }
            nmsItem = READ_ITEM_METHOD.invoke(null, input);
        }
        if (nmsItem != null) {
            return MinecraftReflection.getBukkitItemStack(nmsItem);
        }
        return null;
    }

    public NbtCompound deserializeCompound(@Nonnull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL.");
        }
        Object nmsCompound = null;
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_NBT_METHOD == null) {
                READ_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readNbtCompound", MinecraftReflection.getNBTCompoundClass(), (Class<?>[])new Class[0]));
            }
            nmsCompound = READ_NBT_METHOD.invoke(ByteBufAdapter.packetReader(input), new Object[0]);
        } else {
            if (READ_NBT_METHOD == null) {
                READ_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(DataInput.class).returnDerivedOf(MinecraftReflection.getNBTBaseClass()).build()));
            }
            try {
                nmsCompound = READ_NBT_METHOD.invoke(null, input);
            }
            catch (Exception e) {
                throw new IOException("Cannot read item stack.", e);
            }
        }
        if (nmsCompound != null) {
            return NbtFactory.fromNMSCompound(nmsCompound);
        }
        return null;
    }

    public String deserializeString(@Nonnull DataInputStream input, int maximumLength) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL.");
        }
        if (maximumLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum lenght cannot exceed 32767 characters.");
        }
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maximum lenght cannot be negative.");
        }
        if (MinecraftReflection.isUsingNetty()) {
            if (READ_STRING_METHOD == null) {
                READ_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("readString", (Class<?>)String.class, (Class<?>[])new Class[]{Integer.TYPE}));
            }
            return (String)READ_STRING_METHOD.invoke(ByteBufAdapter.packetReader(input), maximumLength);
        }
        if (READ_STRING_METHOD == null) {
            READ_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(DataInput.class, 0).parameterExactType(Integer.TYPE, 1).returnTypeExact(String.class).build()));
        }
        return (String)READ_STRING_METHOD.invoke(null, input, maximumLength);
    }

    public ItemStack deserializeItemStack(@Nonnull String input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input text cannot be NULL.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)input));
        return this.deserializeItemStack(new DataInputStream(inputStream));
    }

    public void serializeItemStack(@Nonnull DataOutputStream output, ItemStack stack) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Output stream cannot be NULL.");
        }
        Object nmsItem = MinecraftReflection.getMinecraftItemStack(stack);
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeStack", MinecraftReflection.getItemStackClass()));
            }
            WRITE_ITEM_METHOD.invoke(ByteBufAdapter.packetWriter(output), nmsItem);
        } else {
            if (WRITE_ITEM_METHOD == null) {
                WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(MinecraftReflection.getItemStackClass(), 0).parameterDerivedOf(DataOutput.class, 1).build()));
            }
            WRITE_ITEM_METHOD.invoke(null, nmsItem, output);
        }
    }

    public void serializeCompound(@Nonnull DataOutputStream output, NbtCompound compound) throws IOException {
        Object handle;
        if (output == null) {
            throw new IllegalArgumentException("Output stream cannot be NULL.");
        }
        Object object = handle = compound != null ? NbtFactory.fromBase(compound).getHandle() : null;
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_NBT_METHOD == null) {
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeNbtCompound", MinecraftReflection.getNBTCompoundClass()));
            }
            WRITE_NBT_METHOD.invoke(ByteBufAdapter.packetWriter(output), handle);
        } else {
            if (WRITE_NBT_METHOD == null) {
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass(), true).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterDerivedOf(MinecraftReflection.getNBTBaseClass(), 0).parameterDerivedOf(DataOutput.class, 1).returnTypeVoid().build()));
            }
            WRITE_NBT_METHOD.invoke(null, handle, output);
        }
    }

    public void serializeString(@Nonnull DataOutputStream output, String text) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output stream cannot be NULL.");
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be NULL.");
        }
        if (MinecraftReflection.isUsingNetty()) {
            if (WRITE_STRING_METHOD == null) {
                WRITE_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeString", String.class));
            }
            WRITE_STRING_METHOD.invoke(ByteBufAdapter.packetWriter(output), text);
        } else {
            if (WRITE_STRING_METHOD == null) {
                WRITE_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(2).parameterExactType(String.class, 0).parameterDerivedOf(DataOutput.class, 1).returnTypeVoid().build()));
            }
            WRITE_STRING_METHOD.invoke(null, text, output);
        }
    }

    public String serializeItemStack(ItemStack stack) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        this.serializeItemStack(dataOutput, stack);
        return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
    }
}

