/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.utility.ClassSource;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;

class CachedPackage {
    private final Map<String, Optional<Class<?>>> cache;
    private final String packageName;
    private final ClassSource source;

    public CachedPackage(String packageName, ClassSource source) {
        this.packageName = packageName;
        this.cache = Maps.newConcurrentMap();
        this.source = source;
    }

    public void setPackageClass(String className, Class<?> clazz) {
        if (clazz != null) {
            this.cache.put(className, Optional.of(clazz));
        } else {
            this.cache.remove(className);
        }
    }

    public Class<?> getPackageClass(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className cannot be null!");
        if (this.cache.containsKey(className)) {
            Optional<Class<?>> result = this.cache.get(className);
            if (!result.isPresent()) {
                throw new RuntimeException("Cannot find class " + className);
            }
            return (Class)result.get();
        }
        try {
            Class<?> clazz = this.source.loadClass(CachedPackage.combine(this.packageName, className));
            if (clazz == null) {
                throw new IllegalArgumentException("Source " + this.source + " returned null for " + className);
            }
            this.cache.put(className, Optional.of(clazz));
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            this.cache.put(className, Optional.absent());
            throw new RuntimeException("Cannot find class " + className, ex);
        }
    }

    public static String combine(String packageName, String className) {
        if (Strings.isNullOrEmpty((String)packageName)) {
            return className;
        }
        if (Strings.isNullOrEmpty((String)className)) {
            return packageName;
        }
        return packageName + "." + className;
    }
}

