/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class BukkitCloner
implements Cloner {
    private Class<?>[] clonableClasses;

    public BukkitCloner() {
        ArrayList classes = Lists.newArrayList();
        classes.add(MinecraftReflection.getItemStackClass());
        classes.add(MinecraftReflection.getChunkPositionClass());
        classes.add(MinecraftReflection.getDataWatcherClass());
        if (MinecraftReflection.isUsingNetty()) {
            classes.add(MinecraftReflection.getServerPingClass());
        }
        this.clonableClasses = classes.toArray(new Class[0]);
    }

    private int findMatchingClass(Class<?> type) {
        for (int i = 0; i < this.clonableClasses.length; ++i) {
            if (!this.clonableClasses[i].isAssignableFrom(type)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return this.findMatchingClass(source.getClass()) >= 0;
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be NULL.");
        }
        switch (this.findMatchingClass(source.getClass())) {
            case 0: {
                return MinecraftReflection.getMinecraftItemStack(MinecraftReflection.getBukkitItemStack(source).clone());
            }
            case 1: {
                EquivalentConverter<ChunkPosition> chunkConverter = ChunkPosition.getConverter();
                return chunkConverter.getGeneric(this.clonableClasses[1], chunkConverter.getSpecific(source));
            }
            case 2: {
                EquivalentConverter<WrappedDataWatcher> dataConverter = BukkitConverters.getDataWatcherConverter();
                return dataConverter.getGeneric(this.clonableClasses[2], dataConverter.getSpecific(source).deepClone());
            }
            case 3: {
                EquivalentConverter<WrappedServerPing> serverConverter = BukkitConverters.getWrappedServerPingConverter();
                return serverConverter.getGeneric(this.clonableClasses[3], serverConverter.getSpecific(source).deepClone());
            }
        }
        throw new IllegalArgumentException("Cannot clone objects of type " + source.getClass());
    }
}

