/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.net.sf.cglib.proxy.Callback;
import com.comphenix.net.sf.cglib.proxy.CallbackFilter;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.Factory;
import com.comphenix.net.sf.cglib.proxy.NoOp;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.packet.LegacyNetworkMarker;
import com.comphenix.protocol.injector.packet.PacketInjector;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.packet.ReadPacketModifier;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

class ProxyPacketInjector
implements PacketInjector {
    public static final ReportType REPORT_CANNOT_FIND_READ_PACKET_METHOD = new ReportType("Cannot find read packet method for ID %s.");
    public static final ReportType REPORT_UNKNOWN_ORIGIN_FOR_PACKET = new ReportType("Timeout: Unknown origin %s for packet %s. Are you using GamePhase.LOGIN?");
    private static FuzzyMethodContract READ_PACKET = FuzzyMethodContract.newBuilder().returnTypeVoid().parameterDerivedOf(DataInput.class).parameterCount(1).build();
    private static PacketClassLookup lookup;
    private ListenerInvoker manager;
    private ErrorReporter reporter;
    private PlayerInjectionHandler playerInjection;
    private CallbackFilter filter;
    private boolean readPacketIntercepted = false;

    public ProxyPacketInjector(ListenerInvoker manager, PlayerInjectionHandler playerInjection, ErrorReporter reporter) throws FieldAccessException {
        this.manager = manager;
        this.playerInjection = playerInjection;
        this.reporter = reporter;
        this.initialize();
    }

    @Override
    public boolean isCancelled(Object packet) {
        return ReadPacketModifier.isCancelled(packet);
    }

    @Override
    public void setCancelled(Object packet, boolean cancelled) {
        if (cancelled) {
            ReadPacketModifier.setOverride(packet, null);
        } else {
            ReadPacketModifier.removeOverride(packet);
        }
    }

    private void initialize() throws FieldAccessException {
        if (lookup == null) {
            try {
                lookup = new IntHashMapLookup();
            }
            catch (Exception e1) {
                try {
                    lookup = new ArrayLookup();
                }
                catch (Exception e2) {
                    throw new FieldAccessException(e1.getMessage() + ". Workaround failed too.", e2);
                }
            }
        }
    }

    @Override
    public void inputBuffersChanged(Set<PacketType> set) {
    }

    @Override
    public boolean addPacketHandler(PacketType type, Set<ListenerOptions> options) {
        int packetID = type.getLegacyId();
        if (this.hasPacketHandler(type)) {
            return false;
        }
        Enhancer ex = EnhancerFactory.getInstance().createEnhancer();
        Map<Integer, Class> overwritten = PacketRegistry.getOverwrittenPackets();
        Map<Integer, Class> previous = PacketRegistry.getPreviousPackets();
        Map<Class, Integer> registry = PacketRegistry.getPacketToID();
        Class old = PacketRegistry.getPacketClassFromType(type);
        if (old == null) {
            throw new IllegalStateException("Packet ID " + type + " is not a valid packet type in this version.");
        }
        if (Factory.class.isAssignableFrom(old)) {
            throw new IllegalStateException("Packet " + type + " has already been injected.");
        }
        if (this.filter == null) {
            this.readPacketIntercepted = false;
            this.filter = new CallbackFilter(){

                @Override
                public int accept(Method method) {
                    if (method.getDeclaringClass().equals(Object.class)) {
                        return 0;
                    }
                    if (READ_PACKET.isMatch(MethodInfo.fromMethod(method), (Object)null)) {
                        ProxyPacketInjector.this.readPacketIntercepted = true;
                        return 1;
                    }
                    return 2;
                }
            };
        }
        ex.setSuperclass(old);
        ex.setCallbackFilter(this.filter);
        ex.setCallbackTypes(new Class[]{NoOp.class, ReadPacketModifier.class, ReadPacketModifier.class});
        Class proxy = ex.createClass();
        ReadPacketModifier modifierReadPacket = new ReadPacketModifier(packetID, this, this.reporter, true);
        ReadPacketModifier modifierRest = new ReadPacketModifier(packetID, this, this.reporter, false);
        Enhancer.registerStaticCallbacks(proxy, new Callback[]{NoOp.INSTANCE, modifierReadPacket, modifierRest});
        if (!this.readPacketIntercepted) {
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_FIND_READ_PACKET_METHOD).messageParam(packetID));
        }
        previous.put(packetID, old);
        registry.put(proxy, packetID);
        overwritten.put(packetID, proxy);
        lookup.setLookup(packetID, proxy);
        return true;
    }

    @Override
    public boolean removePacketHandler(PacketType type) {
        int packetID = type.getLegacyId();
        if (!this.hasPacketHandler(type)) {
            return false;
        }
        Map<Class, Integer> registry = PacketRegistry.getPacketToID();
        Map<Integer, Class> previous = PacketRegistry.getPreviousPackets();
        Map<Integer, Class> overwritten = PacketRegistry.getOverwrittenPackets();
        Class old = previous.get(packetID);
        Class proxy = PacketRegistry.getPacketClassFromType(type);
        lookup.setLookup(packetID, old);
        previous.remove(packetID);
        registry.remove(proxy);
        overwritten.remove(packetID);
        return true;
    }

    @Deprecated
    public boolean requireInputBuffers(int packetId) {
        return this.manager.requireInputBuffer(packetId);
    }

    @Override
    public boolean hasPacketHandler(PacketType type) {
        return PacketRegistry.getPreviousPackets().containsKey(type.getLegacyId());
    }

    @Override
    public Set<PacketType> getPacketHandlers() {
        return PacketRegistry.toPacketTypes(PacketRegistry.getPreviousPackets().keySet(), PacketType.Sender.CLIENT);
    }

    public PacketEvent packetRecieved(PacketContainer packet, InputStream input, byte[] buffered) {
        if (this.playerInjection.canRecievePackets()) {
            return this.playerInjection.handlePacketRecieved(packet, input, buffered);
        }
        try {
            Player client = this.playerInjection.getPlayerByConnection((DataInputStream)input);
            if (client != null) {
                return this.packetRecieved(packet, client, buffered);
            }
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNKNOWN_ORIGIN_FOR_PACKET).messageParam(input, packet.getType()));
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public PacketEvent packetRecieved(PacketContainer packet, Player client, byte[] buffered) {
        LegacyNetworkMarker marker = buffered != null ? new LegacyNetworkMarker(ConnectionSide.CLIENT_SIDE, buffered, packet.getType()) : null;
        PacketEvent event = PacketEvent.fromClient(this.manager, packet, marker, client);
        this.manager.invokePacketRecieving(event);
        return event;
    }

    @Override
    public synchronized void cleanupAll() {
        Map<Integer, Class> overwritten = PacketRegistry.getOverwrittenPackets();
        Map<Integer, Class> previous = PacketRegistry.getPreviousPackets();
        for (Integer id : previous.keySet().toArray(new Integer[0])) {
            this.removePacketHandler(PacketType.findLegacy(id, PacketType.Sender.CLIENT));
            this.removePacketHandler(PacketType.findLegacy(id, PacketType.Sender.SERVER));
        }
        overwritten.clear();
        previous.clear();
    }

    private static class ArrayLookup
    implements PacketClassLookup {
        private Class<?>[] array;

        public ArrayLookup() throws IllegalAccessException {
            this.initialize();
        }

        @Override
        public void setLookup(int packetID, Class<?> clazz) {
            this.array[packetID] = clazz;
        }

        private void initialize() throws IllegalAccessException {
            FuzzyReflection reflection = FuzzyReflection.fromClass(MinecraftReflection.getPacketClass());
            for (Field field : reflection.getFieldListByType(Class[].class)) {
                Class[] test = (Class[])FieldUtils.readField(field, null);
                if (test.length != 256) continue;
                this.array = test;
                return;
            }
            throw new IllegalArgumentException("Unable to find an array with the type " + Class[].class + " in " + MinecraftReflection.getPacketClass());
        }
    }

    private static class IntHashMapLookup
    implements PacketClassLookup {
        private WrappedIntHashMap intHashMap;

        public IntHashMapLookup() throws IllegalAccessException {
            this.initialize();
        }

        @Override
        public void setLookup(int packetID, Class<?> clazz) {
            this.intHashMap.put(packetID, clazz);
        }

        private void initialize() throws IllegalAccessException {
            if (this.intHashMap == null) {
                Field intHashMapField = FuzzyReflection.fromClass(MinecraftReflection.getPacketClass(), true).getFieldByType("packetIdMap", MinecraftReflection.getIntHashMapClass());
                try {
                    this.intHashMap = WrappedIntHashMap.fromHandle(FieldUtils.readField(intHashMapField, null, true));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Minecraft is incompatible.", e);
                }
            }
        }
    }

    private static interface PacketClassLookup {
        public void setLookup(int var1, Class<?> var2);
    }
}

