/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.util.io.netty.channel.Channel;
import net.minecraft.util.io.netty.channel.ChannelFuture;
import net.minecraft.util.io.netty.channel.ChannelPromise;
import net.minecraft.util.io.netty.channel.EventLoop;
import net.minecraft.util.io.netty.channel.EventLoopGroup;
import net.minecraft.util.io.netty.util.concurrent.EventExecutor;
import net.minecraft.util.io.netty.util.concurrent.Future;
import net.minecraft.util.io.netty.util.concurrent.ProgressivePromise;
import net.minecraft.util.io.netty.util.concurrent.Promise;
import net.minecraft.util.io.netty.util.concurrent.ScheduledFuture;

abstract class EventLoopProxy
implements EventLoop {
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Callable<?> EMPTY_CALLABLE = new Callable<Object>(){

        @Override
        public Object call() throws Exception {
            return null;
        }
    };

    EventLoopProxy() {
    }

    protected abstract EventLoop getDelegate();

    public static <T> Callable<T> getEmptyCallable() {
        return EMPTY_CALLABLE;
    }

    public static Runnable getEmptyRunnable() {
        return EMPTY_RUNNABLE;
    }

    protected abstract Runnable schedulingRunnable(Runnable var1);

    protected abstract <T> Callable<T> schedulingCallable(Callable<T> var1);

    public void execute(Runnable command) {
        this.getDelegate().execute(this.schedulingRunnable(command));
    }

    public <T> Future<T> submit(Callable<T> action) {
        return this.getDelegate().submit(this.schedulingCallable(action));
    }

    public <T> Future<T> submit(Runnable action, T arg1) {
        return this.getDelegate().submit(this.schedulingRunnable(action), arg1);
    }

    public Future<?> submit(Runnable action) {
        return this.getDelegate().submit(this.schedulingRunnable(action));
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> action, long arg1, TimeUnit arg2) {
        return this.getDelegate().schedule(this.schedulingCallable(action), arg1, arg2);
    }

    public ScheduledFuture<?> schedule(Runnable action, long arg1, TimeUnit arg2) {
        return this.getDelegate().schedule(this.schedulingRunnable(action), arg1, arg2);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable action, long arg1, long arg2, TimeUnit arg3) {
        return this.getDelegate().scheduleAtFixedRate(this.schedulingRunnable(action), arg1, arg2, arg3);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable action, long arg1, long arg2, TimeUnit arg3) {
        return this.getDelegate().scheduleWithFixedDelay(this.schedulingRunnable(action), arg1, arg2, arg3);
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().awaitTermination(timeout, unit);
    }

    public boolean inEventLoop() {
        return this.getDelegate().inEventLoop();
    }

    public boolean inEventLoop(Thread arg0) {
        return this.getDelegate().inEventLoop(arg0);
    }

    public boolean isShutdown() {
        return this.getDelegate().isShutdown();
    }

    public boolean isTerminated() {
        return this.getDelegate().isTerminated();
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getDelegate().invokeAll(tasks);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.getDelegate().invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.getDelegate().invokeAny(tasks, timeout, unit);
    }

    public boolean isShuttingDown() {
        return this.getDelegate().isShuttingDown();
    }

    public Iterator<EventExecutor> iterator() {
        return this.getDelegate().iterator();
    }

    public <V> Future<V> newFailedFuture(Throwable arg0) {
        return this.getDelegate().newFailedFuture(arg0);
    }

    public EventLoop next() {
        return this.getDelegate().next();
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return this.getDelegate().newProgressivePromise();
    }

    public <V> Promise<V> newPromise() {
        return this.getDelegate().newPromise();
    }

    public <V> Future<V> newSucceededFuture(V arg0) {
        return this.getDelegate().newSucceededFuture(arg0);
    }

    public EventLoopGroup parent() {
        return this.getDelegate().parent();
    }

    public ChannelFuture register(Channel arg0, ChannelPromise arg1) {
        return this.getDelegate().register(arg0, arg1);
    }

    public ChannelFuture register(Channel arg0) {
        return this.getDelegate().register(arg0);
    }

    public Future<?> shutdownGracefully() {
        return this.getDelegate().shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long arg0, long arg1, TimeUnit arg2) {
        return this.getDelegate().shutdownGracefully(arg0, arg1, arg2);
    }

    public Future<?> terminationFuture() {
        return this.getDelegate().terminationFuture();
    }

    @Deprecated
    public void shutdown() {
        this.getDelegate().shutdown();
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.getDelegate().shutdownNow();
    }
}

