/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.AsynchronousManager;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.EntityUtilities;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class DelayedPacketManager
implements InternalManager {
    public static final ReportType REPORT_CANNOT_SEND_QUEUED_PACKET = new ReportType("Cannot send queued packet %s.");
    public static final ReportType REPORT_CANNOT_REGISTER_QUEUED_LISTENER = new ReportType("Cannot register queued listener %s.");
    private volatile InternalManager delegate;
    private final List<Runnable> queuedActions = Collections.synchronizedList(Lists.newArrayList());
    private final List<PacketListener> queuedListeners = Collections.synchronizedList(Lists.newArrayList());
    private AsynchronousManager asyncManager;
    private ErrorReporter reporter;
    private PacketFilterManager.PlayerInjectHooks hook = PacketFilterManager.PlayerInjectHooks.NETWORK_SERVER_OBJECT;
    private boolean closed;
    private boolean debug;
    private PluginManager queuedManager;
    private Plugin queuedPlugin;
    private MinecraftVersion version;

    public DelayedPacketManager(@Nonnull ErrorReporter reporter, @Nonnull MinecraftVersion version) {
        Preconditions.checkNotNull((Object)reporter, (Object)"reporter cannot be NULL.");
        Preconditions.checkNotNull((Object)version, (Object)"version cannot be NULL.");
        this.reporter = reporter;
        this.version = version;
    }

    public InternalManager getDelegate() {
        return this.delegate;
    }

    @Override
    public int getProtocolVersion(Player player) {
        if (this.delegate != null) {
            return this.delegate.getProtocolVersion(player);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public MinecraftVersion getMinecraftVersion() {
        if (this.delegate != null) {
            return this.delegate.getMinecraftVersion();
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDelegate(InternalManager delegate) {
        this.delegate = delegate;
        if (delegate != null) {
            if (!Objects.equal((Object)((Object)delegate.getPlayerHook()), (Object)((Object)this.hook))) {
                delegate.setPlayerHook(this.hook);
            }
            if (this.queuedManager != null && this.queuedPlugin != null) {
                delegate.registerEvents(this.queuedManager, this.queuedPlugin);
            }
            delegate.setDebug(this.debug);
            List<Object> list = this.queuedListeners;
            synchronized (list) {
                for (PacketListener listener : this.queuedListeners) {
                    try {
                        delegate.addPacketListener(listener);
                    }
                    catch (IllegalArgumentException e) {
                        this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REGISTER_QUEUED_LISTENER).callerParam(delegate).messageParam(listener).error(e));
                    }
                }
            }
            list = this.queuedActions;
            synchronized (list) {
                for (Runnable action : this.queuedActions) {
                    action.run();
                }
            }
            this.queuedListeners.clear();
            this.queuedActions.clear();
        }
    }

    private Runnable queuedAddPacket(final ConnectionSide side, final Player player, final PacketContainer packet, final NetworkMarker marker, final boolean filtered) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    switch (side) {
                        case CLIENT_SIDE: {
                            DelayedPacketManager.this.delegate.recieveClientPacket(player, packet, marker, filtered);
                            break;
                        }
                        case SERVER_SIDE: {
                            DelayedPacketManager.this.delegate.sendServerPacket(player, packet, marker, filtered);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("side cannot be " + (Object)((Object)side));
                        }
                    }
                }
                catch (Exception e) {
                    DelayedPacketManager.this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SEND_QUEUED_PACKET).callerParam(DelayedPacketManager.this.delegate).messageParam(packet).error(e));
                }
            }
        };
    }

    @Override
    public void setPlayerHook(PacketFilterManager.PlayerInjectHooks playerHook) {
        this.hook = playerHook;
    }

    @Override
    public PacketFilterManager.PlayerInjectHooks getPlayerHook() {
        return this.hook;
    }

    @Override
    public void sendServerPacket(Player receiver, PacketContainer packet) throws InvocationTargetException {
        this.sendServerPacket(receiver, packet, null, true);
    }

    @Override
    public void sendServerPacket(Player receiver, PacketContainer packet, boolean filters) throws InvocationTargetException {
        this.sendServerPacket(receiver, packet, null, filters);
    }

    @Override
    public void sendServerPacket(Player receiver, PacketContainer packet, NetworkMarker marker, boolean filters) throws InvocationTargetException {
        if (this.delegate != null) {
            this.delegate.sendServerPacket(receiver, packet, marker, filters);
        } else {
            this.queuedActions.add(this.queuedAddPacket(ConnectionSide.SERVER_SIDE, receiver, packet, marker, filters));
        }
    }

    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet) throws IllegalAccessException, InvocationTargetException {
        this.recieveClientPacket(sender, packet, null, true);
    }

    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet, boolean filters) throws IllegalAccessException, InvocationTargetException {
        this.recieveClientPacket(sender, packet, null, filters);
    }

    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet, NetworkMarker marker, boolean filters) throws IllegalAccessException, InvocationTargetException {
        if (this.delegate != null) {
            this.delegate.recieveClientPacket(sender, packet, marker, filters);
        } else {
            this.queuedActions.add(this.queuedAddPacket(ConnectionSide.CLIENT_SIDE, sender, packet, marker, filters));
        }
    }

    @Override
    public void broadcastServerPacket(final PacketContainer packet, final Entity entity, final boolean includeTracker) {
        if (this.delegate != null) {
            this.delegate.broadcastServerPacket(packet, entity, includeTracker);
        } else {
            this.queuedActions.add(new Runnable(){

                @Override
                public void run() {
                    DelayedPacketManager.this.delegate.broadcastServerPacket(packet, entity, includeTracker);
                }
            });
        }
    }

    @Override
    public void broadcastServerPacket(final PacketContainer packet, final Location origin, final int maxObserverDistance) {
        if (this.delegate != null) {
            this.delegate.broadcastServerPacket(packet, origin, maxObserverDistance);
        } else {
            this.queuedActions.add(new Runnable(){

                @Override
                public void run() {
                    DelayedPacketManager.this.delegate.broadcastServerPacket(packet, origin, maxObserverDistance);
                }
            });
        }
    }

    @Override
    public void broadcastServerPacket(final PacketContainer packet) {
        if (this.delegate != null) {
            this.delegate.broadcastServerPacket(packet);
        } else {
            this.queuedActions.add(new Runnable(){

                @Override
                public void run() {
                    DelayedPacketManager.this.delegate.broadcastServerPacket(packet);
                }
            });
        }
    }

    @Override
    public ImmutableSet<PacketListener> getPacketListeners() {
        if (this.delegate != null) {
            return this.delegate.getPacketListeners();
        }
        return ImmutableSet.copyOf(this.queuedListeners);
    }

    @Override
    public void addPacketListener(PacketListener listener) {
        if (this.delegate != null) {
            this.delegate.addPacketListener(listener);
        } else {
            this.queuedListeners.add(listener);
        }
    }

    @Override
    public void removePacketListener(PacketListener listener) {
        if (this.delegate != null) {
            this.delegate.removePacketListener(listener);
        } else {
            this.queuedListeners.remove(listener);
        }
    }

    @Override
    public void removePacketListeners(Plugin plugin) {
        if (this.delegate != null) {
            this.delegate.removePacketListeners(plugin);
        } else {
            Iterator<PacketListener> it = this.queuedListeners.iterator();
            while (it.hasNext()) {
                if (!Objects.equal((Object)it.next().getPlugin(), (Object)plugin)) continue;
                it.remove();
            }
        }
    }

    @Override
    @Deprecated
    public PacketContainer createPacket(int id) {
        if (this.delegate != null) {
            return this.delegate.createPacket(id);
        }
        return this.createPacket(id, true);
    }

    @Override
    @Deprecated
    public PacketContainer createPacket(int id, boolean forceDefaults) {
        if (this.delegate != null) {
            return this.delegate.createPacket(id);
        }
        PacketContainer packet = new PacketContainer(id);
        if (forceDefaults) {
            try {
                packet.getModifier().writeDefaults();
            }
            catch (FieldAccessException e) {
                throw new RuntimeException("Security exception.", e);
            }
        }
        return packet;
    }

    @Override
    public PacketConstructor createPacketConstructor(int id, Object ... arguments) {
        if (this.delegate != null) {
            return this.delegate.createPacketConstructor(id, arguments);
        }
        return PacketConstructor.DEFAULT.withPacket(id, arguments);
    }

    @Override
    public PacketConstructor createPacketConstructor(PacketType type, Object ... arguments) {
        if (this.delegate != null) {
            return this.delegate.createPacketConstructor(type, arguments);
        }
        return PacketConstructor.DEFAULT.withPacket(type, arguments);
    }

    @Override
    @Deprecated
    public Set<Integer> getSendingFilters() {
        if (this.delegate != null) {
            return this.delegate.getSendingFilters();
        }
        HashSet sending = Sets.newHashSet();
        for (PacketListener listener : this.queuedListeners) {
            sending.addAll(listener.getSendingWhitelist().getWhitelist());
        }
        return sending;
    }

    @Override
    @Deprecated
    public Set<Integer> getReceivingFilters() {
        if (this.delegate != null) {
            return this.delegate.getReceivingFilters();
        }
        HashSet recieving = Sets.newHashSet();
        for (PacketListener listener : this.queuedListeners) {
            recieving.addAll(listener.getReceivingWhitelist().getWhitelist());
        }
        return recieving;
    }

    @Override
    public PacketContainer createPacket(PacketType type) {
        return this.createPacket(type.getLegacyId());
    }

    @Override
    public PacketContainer createPacket(PacketType type, boolean forceDefaults) {
        return this.createPacket(type.getLegacyId(), forceDefaults);
    }

    @Override
    public Set<PacketType> getSendingFilterTypes() {
        return PacketRegistry.toPacketTypes(this.getSendingFilters(), PacketType.Sender.SERVER);
    }

    @Override
    public Set<PacketType> getReceivingFilterTypes() {
        return PacketRegistry.toPacketTypes(this.getReceivingFilters(), PacketType.Sender.CLIENT);
    }

    @Override
    public void updateEntity(Entity entity, List<Player> observers) throws FieldAccessException {
        if (this.delegate != null) {
            this.delegate.updateEntity(entity, observers);
        } else {
            EntityUtilities.updateEntity(entity, observers);
        }
    }

    @Override
    public Entity getEntityFromID(World container, int id) throws FieldAccessException {
        if (this.delegate != null) {
            return this.delegate.getEntityFromID(container, id);
        }
        return EntityUtilities.getEntityFromID(container, id);
    }

    @Override
    public List<Player> getEntityTrackers(Entity entity) throws FieldAccessException {
        if (this.delegate != null) {
            return this.delegate.getEntityTrackers(entity);
        }
        return EntityUtilities.getEntityTrackers(entity);
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.delegate != null && this.delegate.isClosed();
    }

    @Override
    public AsynchronousManager getAsynchronousManager() {
        if (this.delegate != null) {
            return this.delegate.getAsynchronousManager();
        }
        return this.asyncManager;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
        if (this.delegate != null) {
            this.delegate.setDebug(debug);
        }
    }

    public void setAsynchronousManager(AsynchronousManager asyncManager) {
        this.asyncManager = asyncManager;
    }

    @Override
    public void registerEvents(PluginManager manager, Plugin plugin) {
        if (this.delegate != null) {
            this.delegate.registerEvents(manager, plugin);
        } else {
            this.queuedManager = manager;
            this.queuedPlugin = plugin;
        }
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.closed = true;
    }
}

