/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.ObjectWriter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.cloning.AggregateCloner;
import com.comphenix.protocol.reflect.cloning.BukkitCloner;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.CollectionCloner;
import com.comphenix.protocol.reflect.cloning.FieldCloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.SerializableCloner;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import net.minecraft.util.io.netty.buffer.ByteBuf;
import net.minecraft.util.io.netty.buffer.UnpooledByteBufAllocator;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class PacketContainer
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected PacketType type;
    protected transient Object handle;
    protected transient StructureModifier<Object> structureModifier;
    private static ConcurrentMap<Class<?>, Method> writeMethods = Maps.newConcurrentMap();
    private static ConcurrentMap<Class<?>, Method> readMethods = Maps.newConcurrentMap();
    private static final AggregateCloner DEEP_CLONER = AggregateCloner.newBuilder().instanceProvider(DefaultInstances.DEFAULT).andThen(BukkitCloner.class).andThen(ImmutableDetector.class).andThen(CollectionCloner.class).andThen(PacketContainer.getSpecializedDeepClonerFactory()).build();
    private static final AggregateCloner SHALLOW_CLONER = AggregateCloner.newBuilder().instanceProvider(DefaultInstances.DEFAULT).andThen(new Function<AggregateCloner.BuilderParameters, Cloner>(){

        public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
            if (param == null) {
                throw new IllegalArgumentException("Cannot be NULL.");
            }
            return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                {
                    this.writer = new ObjectWriter();
                }
            };
        }
    }).build();
    private static final Set<PacketType> CLONING_UNSUPPORTED = Sets.newHashSet((Object[])new PacketType[]{PacketType.Play.Server.UPDATE_ATTRIBUTES, PacketType.Status.Server.OUT_SERVER_INFO});

    @Deprecated
    public PacketContainer(int id) {
        this(PacketType.findLegacy(id), StructureCache.newPacket(PacketType.findLegacy(id)));
    }

    @Deprecated
    public PacketContainer(int id, Object handle) {
        this(PacketType.findLegacy(id), handle);
    }

    @Deprecated
    public PacketContainer(int id, Object handle, StructureModifier<Object> structure) {
        this(PacketType.findLegacy(id), handle, structure);
    }

    public PacketContainer(PacketType type) {
        this(type, StructureCache.newPacket(type));
    }

    public PacketContainer(PacketType type, Object handle) {
        this(type, handle, StructureCache.getStructure(type).withTarget(handle));
    }

    public PacketContainer(PacketType type, Object handle, StructureModifier<Object> structure) {
        if (handle == null) {
            throw new IllegalArgumentException("handle cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = type;
        this.handle = handle;
        this.structureModifier = structure;
    }

    public static PacketContainer fromPacket(Object packet) {
        PacketType type = PacketType.fromClass(packet.getClass());
        return new PacketContainer(type, packet);
    }

    protected PacketContainer() {
    }

    public Object getHandle() {
        return this.handle;
    }

    public StructureModifier<Object> getModifier() {
        return this.structureModifier;
    }

    public <T> StructureModifier<T> getSpecificModifier(Class<T> primitiveType) {
        return this.structureModifier.withType(primitiveType);
    }

    public StructureModifier<Byte> getBytes() {
        return this.structureModifier.withType(Byte.TYPE);
    }

    public StructureModifier<Boolean> getBooleans() {
        return this.structureModifier.withType(Boolean.TYPE);
    }

    public StructureModifier<Short> getShorts() {
        return this.structureModifier.withType(Short.TYPE);
    }

    public StructureModifier<Integer> getIntegers() {
        return this.structureModifier.withType(Integer.TYPE);
    }

    public StructureModifier<Long> getLongs() {
        return this.structureModifier.withType(Long.TYPE);
    }

    public StructureModifier<Float> getFloat() {
        return this.structureModifier.withType(Float.TYPE);
    }

    public StructureModifier<Double> getDoubles() {
        return this.structureModifier.withType(Double.TYPE);
    }

    public StructureModifier<String> getStrings() {
        return this.structureModifier.withType(String.class);
    }

    public StructureModifier<String[]> getStringArrays() {
        return this.structureModifier.withType(String[].class);
    }

    public StructureModifier<byte[]> getByteArrays() {
        return this.structureModifier.withType(byte[].class);
    }

    public StreamSerializer getByteArraySerializer() {
        return new StreamSerializer();
    }

    public StructureModifier<int[]> getIntegerArrays() {
        return this.structureModifier.withType(int[].class);
    }

    public StructureModifier<ItemStack> getItemModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter());
    }

    public StructureModifier<ItemStack[]> getItemArrayModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackArrayClass(), BukkitConverters.getIgnoreNull(new ItemStackArrayConverter()));
    }

    public StructureModifier<Map<WrappedStatistic, Integer>> getStatisticMaps() {
        return this.structureModifier.withType(Map.class, BukkitConverters.getMapConverter(MinecraftReflection.getStatisticClass(), BukkitConverters.getWrappedStatisticConverter()));
    }

    public StructureModifier<WorldType> getWorldTypeModifier() {
        return this.structureModifier.withType(MinecraftReflection.getWorldTypeClass(), BukkitConverters.getWorldTypeConverter());
    }

    public StructureModifier<WrappedDataWatcher> getDataWatcherModifier() {
        return this.structureModifier.withType(MinecraftReflection.getDataWatcherClass(), BukkitConverters.getDataWatcherConverter());
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world cannot be NULL.");
        return this.structureModifier.withType(Integer.TYPE, BukkitConverters.getEntityConverter(world));
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull PacketEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be NULL.");
        return this.getEntityModifier(event.getPlayer().getWorld());
    }

    public StructureModifier<ChunkPosition> getPositionModifier() {
        return this.structureModifier.withType(MinecraftReflection.getChunkPositionClass(), ChunkPosition.getConverter());
    }

    public StructureModifier<ChunkCoordIntPair> getChunkCoordIntPairs() {
        return this.structureModifier.withType(MinecraftReflection.getChunkCoordIntPair(), ChunkCoordIntPair.getConverter());
    }

    public StructureModifier<NbtBase<?>> getNbtModifier() {
        return this.structureModifier.withType(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter());
    }

    public StructureModifier<List<WrappedAttribute>> getAttributeCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getAttributeSnapshotClass(), BukkitConverters.getWrappedAttributeConverter()));
    }

    public StructureModifier<List<ChunkPosition>> getPositionCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getChunkPositionClass(), ChunkPosition.getConverter()));
    }

    public StructureModifier<List<WrappedWatchableObject>> getWatchableCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getWatchableObjectClass(), BukkitConverters.getWatchableObjectConverter()));
    }

    public StructureModifier<Material> getBlocks() {
        return this.structureModifier.withType(MinecraftReflection.getBlockClass(), BukkitConverters.getBlockConverter());
    }

    public StructureModifier<WrappedGameProfile> getGameProfiles() {
        return this.structureModifier.withType(GameProfile.class, BukkitConverters.getWrappedGameProfileConverter());
    }

    public StructureModifier<WrappedChatComponent> getChatComponents() {
        return this.structureModifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
    }

    public StructureModifier<WrappedServerPing> getServerPings() {
        return this.structureModifier.withType(MinecraftReflection.getServerPingClass(), BukkitConverters.getWrappedServerPingConverter());
    }

    public StructureModifier<PacketType.Protocol> getProtocols() {
        return this.structureModifier.withType(EnumWrappers.getProtocolClass(), EnumWrappers.getProtocolConverter());
    }

    public StructureModifier<EnumWrappers.ClientCommand> getClientCommands() {
        return this.structureModifier.withType(EnumWrappers.getClientCommandClass(), EnumWrappers.getClientCommandConverter());
    }

    public StructureModifier<EnumWrappers.ChatVisibility> getChatVisibilities() {
        return this.structureModifier.withType(EnumWrappers.getChatVisibilityClass(), EnumWrappers.getChatVisibilityConverter());
    }

    public StructureModifier<EnumWrappers.Difficulty> getDifficulties() {
        return this.structureModifier.withType(EnumWrappers.getDifficultyClass(), EnumWrappers.getDifficultyConverter());
    }

    public StructureModifier<EnumWrappers.EntityUseAction> getEntityUseActions() {
        return this.structureModifier.withType(EnumWrappers.getEntityUseActionClass(), EnumWrappers.getEntityUseActionConverter());
    }

    public StructureModifier<EnumWrappers.NativeGameMode> getGameModes() {
        return this.structureModifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
    }

    @Deprecated
    public int getID() {
        return this.type.getLegacyId();
    }

    public PacketType getType() {
        return this.type;
    }

    public PacketContainer shallowClone() {
        Object clonedPacket = SHALLOW_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    public PacketContainer deepClone() {
        Object clonedPacket = null;
        clonedPacket = CLONING_UNSUPPORTED.contains(this.type) ? SerializableCloner.clone(this).getHandle() : DEEP_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    private static Function<AggregateCloner.BuilderParameters, Cloner> getSpecializedDeepClonerFactory() {
        return new Function<AggregateCloner.BuilderParameters, Cloner>(){

            public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
                return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                    {
                        this.writer = new ObjectWriter(){

                            @Override
                            protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
                                if (modifierSource.getField(fieldIndex).getName().startsWith("inflatedBuffer")) {
                                    modifierDest.write(fieldIndex, modifierSource.read(fieldIndex));
                                } else {
                                    this.defaultTransform(modifierSource, modifierDest, this.getDefaultCloner(), fieldIndex);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeBoolean(this.handle != null);
        try {
            if (MinecraftReflection.isUsingNetty()) {
                ByteBuf buffer = this.createPacketBuffer();
                MinecraftMethods.getPacketWriteByteBufMethod().invoke(this.handle, buffer);
                output.writeInt(buffer.readableBytes());
                buffer.readBytes((OutputStream)output, buffer.readableBytes());
            } else {
                output.writeInt(-1);
                this.getMethodLazily(writeMethods, this.handle.getClass(), "write", DataOutput.class).invoke(this.handle, new DataOutputStream(output));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Minecraft packet doesn't support DataOutputStream", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Insufficient security privileges.", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not serialize Minecraft packet.", e);
        }
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.structureModifier = StructureCache.getStructure(this.type);
        if (input.readBoolean()) {
            this.handle = StructureCache.newPacket(this.type);
            try {
                if (MinecraftReflection.isUsingNetty()) {
                    ByteBuf buffer = this.createPacketBuffer();
                    buffer.writeBytes((InputStream)input, input.readInt());
                    MinecraftMethods.getPacketReadByteBufMethod().invoke(this.handle, buffer);
                } else {
                    if (input.readInt() != -1) {
                        throw new IllegalArgumentException("Cannot load a packet from 1.7.2 in 1.6.4.");
                    }
                    this.getMethodLazily(readMethods, this.handle.getClass(), "read", DataInput.class).invoke(this.handle, new DataInputStream(input));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Minecraft packet doesn't support DataInputStream", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Insufficient security privileges.", e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Could not deserialize Minecraft packet.", e);
            }
            this.structureModifier = this.structureModifier.withTarget(this.handle);
        }
    }

    private ByteBuf createPacketBuffer() {
        return MinecraftReflection.getPacketDataSerializer(UnpooledByteBufAllocator.DEFAULT.buffer());
    }

    private Method getMethodLazily(ConcurrentMap<Class<?>, Method> lookup, Class<?> handleClass, String methodName, Class<?> parameterClass) {
        Method initialized;
        Method method = (Method)lookup.get(handleClass);
        if (method == null && (method = lookup.putIfAbsent(handleClass, initialized = FuzzyReflection.fromClass(handleClass).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(parameterClass).returnTypeVoid().build()))) == null) {
            method = initialized;
        }
        return method;
    }

    private static class ItemStackArrayConverter
    implements EquivalentConverter<ItemStack[]> {
        final EquivalentConverter<ItemStack> stackConverter = BukkitConverters.getItemStackConverter();

        private ItemStackArrayConverter() {
        }

        @Override
        public Object getGeneric(Class<?> genericType, ItemStack[] specific) {
            Class<?> nmsStack = MinecraftReflection.getItemStackClass();
            Object[] result = (Object[])Array.newInstance(nmsStack, specific.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getGeneric(nmsStack, specific[i]);
            }
            return result;
        }

        @Override
        public ItemStack[] getSpecific(Object generic) {
            Object[] input = (Object[])generic;
            ItemStack[] result = new ItemStack[input.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getSpecific(input[i]);
            }
            return result;
        }

        @Override
        public Class<ItemStack[]> getSpecificType() {
            return ItemStack[].class;
        }
    }
}

