/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.comphenix.protocol.utility.SafeCacheBuilder;
import com.comphenix.protocol.utility.Util;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.bukkit.entity.Player;

public class ConcurrentPlayerMap<TValue>
extends AbstractMap<Player, TValue>
implements ConcurrentMap<Player, TValue> {
    private ConcurrentMap<Object, TValue> valueLookup = this.createValueMap();
    private ConcurrentMap<Object, Player> keyLookup = this.createKeyCache();
    private final Function<Player, Object> keyMethod;

    public static <T> ConcurrentPlayerMap<T> usingAddress() {
        return new ConcurrentPlayerMap(PlayerKey.ADDRESS);
    }

    public static <T> ConcurrentPlayerMap<T> usingName() {
        return new ConcurrentPlayerMap(PlayerKey.NAME);
    }

    private ConcurrentPlayerMap(PlayerKey standardMethod) {
        this.keyMethod = standardMethod;
    }

    public ConcurrentPlayerMap(Function<Player, Object> method) {
        this.keyMethod = method;
    }

    private ConcurrentMap<Object, TValue> createValueMap() {
        return Maps.newConcurrentMap();
    }

    private ConcurrentMap<Object, Player> createKeyCache() {
        return SafeCacheBuilder.newBuilder().weakValues().removalListener(removed -> {
            if (removed.wasEvicted()) {
                this.onCacheEvicted(removed.getKey());
            }
        }).build(new CacheLoader<Object, Player>(){

            public Player load(Object key) {
                Player player = ConcurrentPlayerMap.this.findOnlinePlayer(key);
                if (player != null) {
                    return player;
                }
                throw new IllegalArgumentException("Unable to find a player associated with: " + key);
            }
        });
    }

    private void onCacheEvicted(Object key) {
        Player newPlayer = this.findOnlinePlayer(key);
        if (newPlayer != null) {
            this.keyLookup.put(key, newPlayer);
        } else {
            this.valueLookup.remove(key);
        }
    }

    private Player findOnlinePlayer(Object key) {
        for (Player player : Util.getOnlinePlayers()) {
            if (!key.equals(this.keyMethod.apply(player))) continue;
            return player;
        }
        return null;
    }

    private Player lookupPlayer(Object key) {
        try {
            return (Player)this.keyLookup.get(key);
        }
        catch (UncheckedExecutionException e) {
            return null;
        }
    }

    private Object cachePlayerKey(Player player) {
        Object key = this.keyMethod.apply(player);
        this.keyLookup.put(key, player);
        return key;
    }

    @Override
    public TValue put(Player key, TValue value) {
        return this.valueLookup.put(this.cachePlayerKey(key), value);
    }

    @Override
    public TValue putIfAbsent(Player key, TValue value) {
        return this.valueLookup.putIfAbsent(this.cachePlayerKey(key), value);
    }

    @Override
    public TValue replace(Player key, TValue value) {
        return this.valueLookup.replace(this.cachePlayerKey(key), value);
    }

    @Override
    public boolean replace(Player key, TValue oldValue, TValue newValue) {
        return this.valueLookup.replace(this.cachePlayerKey(key), oldValue, newValue);
    }

    @Override
    public TValue remove(Object key) {
        Object playerKey;
        if (key instanceof Player && (playerKey = this.keyMethod.apply((Player)key)) != null) {
            Object value = this.valueLookup.remove(playerKey);
            this.keyLookup.remove(playerKey);
            return (TValue)value;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object playerKey;
        if (key instanceof Player && (playerKey = this.keyMethod.apply((Player)key)) != null && this.valueLookup.remove(playerKey, value)) {
            this.keyLookup.remove(playerKey);
            return true;
        }
        return false;
    }

    @Override
    public TValue get(Object key) {
        if (key instanceof Player) {
            Object playerKey = this.keyMethod.apply((Player)key);
            return playerKey != null ? (TValue)this.valueLookup.get(playerKey) : null;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Player) {
            Object playerKey = this.keyMethod.apply((Player)key);
            return playerKey != null && this.valueLookup.containsKey(playerKey);
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Player, TValue>> entrySet() {
        return new AbstractSet<Map.Entry<Player, TValue>>(){

            @Override
            public Iterator<Map.Entry<Player, TValue>> iterator() {
                return ConcurrentPlayerMap.this.entryIterator();
            }

            @Override
            public int size() {
                return ConcurrentPlayerMap.this.valueLookup.size();
            }

            @Override
            public void clear() {
                ConcurrentPlayerMap.this.valueLookup.clear();
                ConcurrentPlayerMap.this.keyLookup.clear();
            }
        };
    }

    private Iterator<Map.Entry<Player, TValue>> entryIterator() {
        final Iterator source = this.valueLookup.entrySet().iterator();
        final AbstractIterator filtered = new AbstractIterator<Map.Entry<Player, TValue>>(){

            protected Map.Entry<Player, TValue> computeNext() {
                while (source.hasNext()) {
                    Map.Entry entry = (Map.Entry)source.next();
                    Player player = ConcurrentPlayerMap.this.lookupPlayer(entry.getKey());
                    if (player == null) {
                        source.remove();
                        ConcurrentPlayerMap.this.keyLookup.remove(entry.getKey());
                        continue;
                    }
                    return new AbstractMap.SimpleEntry(player, entry.getValue());
                }
                return (Map.Entry)this.endOfData();
            }
        };
        return new Iterator<Map.Entry<Player, TValue>>(){

            @Override
            public boolean hasNext() {
                return filtered.hasNext();
            }

            @Override
            public Map.Entry<Player, TValue> next() {
                return (Map.Entry)filtered.next();
            }

            @Override
            public void remove() {
                source.remove();
            }
        };
    }

    public static enum PlayerKey implements Function<Player, Object>
    {
        ADDRESS{

            @Override
            public Object apply(Player player) {
                return player == null ? null : player.getAddress();
            }
        }
        ,
        NAME{

            @Override
            public Object apply(Player player) {
                return player == null ? null : player.getName();
            }
        };

    }
}

