/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class ProtocolLogger {
    private static Plugin plugin;

    protected static void init(Plugin plugin) {
        ProtocolLogger.plugin = plugin;
    }

    public static boolean isDebugEnabled() {
        try {
            return plugin.getConfig().getBoolean("global.debug", false);
        }
        catch (Throwable ex) {
            return true;
        }
    }

    public static void log(Level level, String message, Object ... args) {
        plugin.getLogger().log(level, MessageFormat.format(message, args));
    }

    public static void log(String message, Object ... args) {
        ProtocolLogger.log(Level.INFO, message, args);
    }

    public static void log(Level level, String message, Throwable ex) {
        plugin.getLogger().log(level, message, ex);
    }

    public static void debug(String message, Object ... args) {
        if (ProtocolLogger.isDebugEnabled()) {
            ProtocolLogger.log("[Debug] " + message, args);
        }
    }

    public static void debug(String message, Throwable ex) {
        if (ProtocolLogger.isDebugEnabled()) {
            plugin.getLogger().log(Level.WARNING, "[Debug] " + message, ex);
        }
    }
}

