/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.compiler;

import com.comphenix.protocol.reflect.compiler.MethodDescriptor;
import net.sf.cglib.asm.;

class BoxingHelper {
    private static final .Type BYTE_$Type = .Type.getObjectType((String)"java/lang/Byte");
    private static final .Type BOOLEAN_$Type = .Type.getObjectType((String)"java/lang/Boolean");
    private static final .Type SHORT_$Type = .Type.getObjectType((String)"java/lang/Short");
    private static final .Type CHARACTER_$Type = .Type.getObjectType((String)"java/lang/Character");
    private static final .Type INTEGER_$Type = .Type.getObjectType((String)"java/lang/Integer");
    private static final .Type FLOAT_$Type = .Type.getObjectType((String)"java/lang/Float");
    private static final .Type LONG_$Type = .Type.getObjectType((String)"java/lang/Long");
    private static final .Type DOUBLE_$Type = .Type.getObjectType((String)"java/lang/Double");
    private static final .Type NUMBER_$Type = .Type.getObjectType((String)"java/lang/Number");
    private static final .Type OBJECT_$Type = .Type.getObjectType((String)"java/lang/Object");
    private static final MethodDescriptor BOOLEAN_VALUE = MethodDescriptor.getMethod("boolean booleanValue()");
    private static final MethodDescriptor CHAR_VALUE = MethodDescriptor.getMethod("char charValue()");
    private static final MethodDescriptor INT_VALUE = MethodDescriptor.getMethod("int intValue()");
    private static final MethodDescriptor FLOAT_VALUE = MethodDescriptor.getMethod("float floatValue()");
    private static final MethodDescriptor LONG_VALUE = MethodDescriptor.getMethod("long longValue()");
    private static final MethodDescriptor DOUBLE_VALUE = MethodDescriptor.getMethod("double doubleValue()");
    private .MethodVisitor mv;

    public BoxingHelper(.MethodVisitor mv) {
        this.mv = mv;
    }

    public void box(.Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == .Type.VOID_TYPE) {
            this.push(null);
        } else {
            .Type boxed = type;
            switch (type.getSort()) {
                case 3: {
                    boxed = BYTE_$Type;
                    break;
                }
                case 1: {
                    boxed = BOOLEAN_$Type;
                    break;
                }
                case 4: {
                    boxed = SHORT_$Type;
                    break;
                }
                case 2: {
                    boxed = CHARACTER_$Type;
                    break;
                }
                case 5: {
                    boxed = INTEGER_$Type;
                    break;
                }
                case 6: {
                    boxed = FLOAT_$Type;
                    break;
                }
                case 7: {
                    boxed = LONG_$Type;
                    break;
                }
                case 8: {
                    boxed = DOUBLE_$Type;
                }
            }
            this.newInstance(boxed);
            if (type.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxed, new MethodDescriptor("<init>", .Type.VOID_TYPE, new .Type[]{type}));
        }
    }

    public void invokeConstructor(.Type $Type, MethodDescriptor method) {
        this.invokeInsn(183, $Type, method);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void push(boolean value) {
        this.push(value ? 1 : 0);
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            this.mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value);
        } else {
            this.mv.visitLdcInsn((Object)new Integer(value));
        }
    }

    public void newInstance(.Type $Type) {
        this.$TypeInsn(187, $Type);
    }

    public void push(String value) {
        if (value == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn((Object)value);
        }
    }

    public void unbox(.Type type) {
        .Type t = NUMBER_$Type;
        MethodDescriptor sig = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                t = CHARACTER_$Type;
                sig = CHAR_VALUE;
                break;
            }
            case 1: {
                t = BOOLEAN_$Type;
                sig = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                sig = DOUBLE_VALUE;
                break;
            }
            case 6: {
                sig = FLOAT_VALUE;
                break;
            }
            case 7: {
                sig = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = INT_VALUE;
            }
        }
        if (sig == null) {
            this.checkCast(type);
        } else {
            this.checkCast(t);
            this.invokeVirtual(t, sig);
        }
    }

    public void checkCast(.Type $Type) {
        if (!$Type.equals((Object)OBJECT_$Type)) {
            this.$TypeInsn(192, $Type);
        }
    }

    public void invokeVirtual(.Type owner, MethodDescriptor method) {
        this.invokeInsn(182, owner, method);
    }

    private void invokeInsn(int opcode, .Type $Type, MethodDescriptor method) {
        String owner = $Type.getSort() == 9 ? $Type.getDescriptor() : $Type.getInternalName();
        this.mv.visitMethodInsn(opcode, owner, method.getName(), method.getDescriptor());
    }

    private void $TypeInsn(int opcode, .Type $Type) {
        String desc = $Type.getSort() == 9 ? $Type.getDescriptor() : $Type.getInternalName();
        this.mv.visitTypeInsn(opcode, desc);
    }
}

