/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;

public class WrappedIntHashMap
extends AbstractWrapper {
    private static Method PUT_METHOD;
    private static Method GET_METHOD;
    private static Method REMOVE_METHOD;

    private WrappedIntHashMap(Object handle) {
        super(MinecraftReflection.getIntHashMapClass());
        this.setHandle(handle);
    }

    public static WrappedIntHashMap newMap() {
        try {
            return new WrappedIntHashMap(MinecraftReflection.getIntHashMapClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to construct IntHashMap.", e);
        }
    }

    public static WrappedIntHashMap fromHandle(@Nonnull Object handle) {
        return new WrappedIntHashMap(handle);
    }

    public void put(int key, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be NULL.");
        this.initializePutMethod();
        this.putInternal(key, value);
    }

    private void putInternal(int key, Object value) {
        this.invokeMethod(PUT_METHOD, key, value);
    }

    public Object get(int key) {
        this.initializeGetMethod();
        return this.invokeMethod(GET_METHOD, key);
    }

    public Object remove(int key) {
        this.initializeGetMethod();
        if (REMOVE_METHOD == null) {
            return this.removeFallback(key);
        }
        return this.invokeMethod(REMOVE_METHOD, key);
    }

    private Object removeFallback(int key) {
        Object old = this.get(key);
        this.invokeMethod(PUT_METHOD, key, null);
        return old;
    }

    private Object invokeMethod(Method method, Object ... params) {
        try {
            return method.invoke(this.handle, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illegal argument.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access method.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke " + method + " on " + this.handle, e);
        }
    }

    private void initializePutMethod() {
        if (PUT_METHOD == null) {
            PUT_METHOD = FuzzyReflection.fromClass(MinecraftReflection.getIntHashMapClass()).getMethod(FuzzyMethodContract.newBuilder().banModifier(8).parameterCount(2).parameterExactType(Integer.TYPE).parameterExactType(Object.class).build());
        }
    }

    private void initializeGetMethod() {
        if (GET_METHOD == null) {
            WrappedIntHashMap temp = WrappedIntHashMap.newMap();
            String expected = "hello";
            for (Method method : FuzzyReflection.fromClass(MinecraftReflection.getIntHashMapClass()).getMethodListByParameters(Object.class, new Class[]{Integer.TYPE})) {
                temp.put(1, expected);
                if (Modifier.isStatic(method.getModifiers())) continue;
                try {
                    boolean first = expected.equals(method.invoke(temp.getHandle(), 1));
                    boolean second = expected.equals(method.invoke(temp.getHandle(), 1));
                    if (first && !second) {
                        REMOVE_METHOD = method;
                        continue;
                    }
                    if (!first || !second) continue;
                    GET_METHOD = method;
                }
                catch (Exception exception) {}
            }
            if (GET_METHOD == null) {
                throw new IllegalStateException("Unable to find appropriate GET_METHOD for IntHashMap.");
            }
        }
    }
}

