/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.Converters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BukkitConverters {
    private static boolean hasWorldType = false;
    private static boolean hasAttributeSnapshot = false;
    private static Map<Class<?>, EquivalentConverter<Object>> genericConverters;
    private static List<PacketConstructor.Unwrapper> unwrappers;
    private static Method worldTypeName;
    private static Method worldTypeGetType;
    private static volatile Constructor<?> mobEffectConstructor;
    private static volatile StructureModifier<Object> mobEffectModifier;
    private static FieldAccessor craftWorldField;
    private static MethodAccessor BLOCK_FROM_MATERIAL;
    private static MethodAccessor MATERIAL_FROM_BLOCK;
    private static Constructor<?> vec3dConstructor;
    private static StructureModifier<Object> vec3dModifier;
    private static MethodAccessor getSound;
    private static MethodAccessor getSoundEffect;
    private static FieldAccessor soundKey;
    private static Map<String, Sound> soundIndex;
    private static MethodAccessor getMobEffectId;
    private static MethodAccessor getMobEffect;
    private static MethodAccessor dimensionFromId;
    private static MethodAccessor idFromDimension;

    public static <K, V> EquivalentConverter<Map<K, V>> getMapConverter(final EquivalentConverter<K> keyConverter, final EquivalentConverter<V> valConverter) {
        return new EquivalentConverter<Map<K, V>>(){

            @Override
            public Map<K, V> getSpecific(Object generic) {
                HashMap newMap;
                Map genericMap = (Map)generic;
                try {
                    newMap = (HashMap)genericMap.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newMap = new HashMap();
                }
                for (Map.Entry entry : genericMap.entrySet()) {
                    newMap.put(keyConverter.getSpecific(entry.getKey()), valConverter.getSpecific(entry.getValue()));
                }
                return newMap;
            }

            @Override
            public Object getGeneric(Map<K, V> specific) {
                HashMap<Object, Object> newMap;
                try {
                    newMap = (HashMap<Object, Object>)specific.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newMap = new HashMap<Object, Object>();
                }
                for (Map.Entry entry : specific.entrySet()) {
                    newMap.put(keyConverter.getGeneric(entry.getKey()), valConverter.getGeneric(entry.getValue()));
                }
                return newMap;
            }

            @Override
            public Class<Map<K, V>> getSpecificType() {
                return null;
            }
        };
    }

    public static <T> EquivalentConverter<List<T>> getListConverter(final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<List<T>>(){

            @Override
            public List<T> getSpecific(Object generic) {
                if (generic instanceof Collection) {
                    ArrayList items = new ArrayList();
                    for (Object item : (Collection)generic) {
                        Object result = itemConverter.getSpecific(item);
                        if (item == null) continue;
                        items.add(result);
                    }
                    return items;
                }
                return null;
            }

            @Override
            public Object getGeneric(List<T> specific) {
                ArrayList<Object> newList;
                try {
                    newList = (ArrayList<Object>)specific.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newList = new ArrayList<Object>();
                }
                for (Object position : specific) {
                    if (position != null) {
                        Object converted = itemConverter.getGeneric(position);
                        if (converted == null) continue;
                        newList.add(converted);
                        continue;
                    }
                    newList.add(null);
                }
                return newList;
            }

            @Override
            public Class<List<T>> getSpecificType() {
                Class<List> dummy = List.class;
                return dummy;
            }
        });
    }

    @Deprecated
    public static <T> EquivalentConverter<Set<T>> getSetConverter(Class<?> genericType, EquivalentConverter<T> itemConverter) {
        if (itemConverter instanceof EnumWrappers.EnumConverter) {
            ((EnumWrappers.EnumConverter)itemConverter).setGenericType(genericType);
        }
        return BukkitConverters.getSetConverter(itemConverter);
    }

    public static <T> EquivalentConverter<Set<T>> getSetConverter(final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Set<T>>(){

            @Override
            public Set<T> getSpecific(Object generic) {
                if (generic instanceof Collection) {
                    HashSet items = new HashSet();
                    for (Object item : (Collection)generic) {
                        Object result = itemConverter.getSpecific(item);
                        if (item == null) continue;
                        items.add(result);
                    }
                    return items;
                }
                return null;
            }

            @Override
            public Object getGeneric(Set<T> specific) {
                HashSet<Object> newList;
                try {
                    newList = (HashSet<Object>)specific.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newList = new HashSet<Object>();
                }
                for (Object position : specific) {
                    if (position != null) {
                        Object converted = itemConverter.getGeneric(position);
                        if (converted == null) continue;
                        newList.add(converted);
                        continue;
                    }
                    newList.add(null);
                }
                return newList;
            }

            @Override
            public Class<Set<T>> getSpecificType() {
                Class<Set> dummy = Set.class;
                return dummy;
            }
        });
    }

    public static <T> EquivalentConverter<Iterable<? extends T>> getArrayConverter(final Class<?> genericItemType, final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Iterable<? extends T>>(){

            @Override
            public List<T> getSpecific(Object generic) {
                if (generic instanceof Object[]) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Object item : (Object[])generic) {
                        Object result = itemConverter.getSpecific(item);
                        builder.add(result);
                    }
                    return builder.build();
                }
                return null;
            }

            @Override
            public Object getGeneric(Iterable<? extends T> specific) {
                ArrayList list = Lists.newArrayList(specific);
                Object[] output = (Object[])Array.newInstance(genericItemType, list.size());
                for (int i = 0; i < output.length; ++i) {
                    Object converted;
                    output[i] = converted = itemConverter.getGeneric(list.get(i));
                }
                return output;
            }

            @Override
            public Class<Iterable<? extends T>> getSpecificType() {
                Class<Iterable> dummy = Iterable.class;
                return dummy;
            }
        });
    }

    public static EquivalentConverter<WrappedGameProfile> getWrappedGameProfileConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedGameProfile::fromHandle));
    }

    public static EquivalentConverter<WrappedChatComponent> getWrappedChatComponentConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedChatComponent::fromHandle));
    }

    public static EquivalentConverter<WrappedBlockData> getWrappedBlockDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedBlockData::fromHandle));
    }

    public static EquivalentConverter<WrappedAttribute> getWrappedAttributeConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedAttribute::fromHandle));
    }

    public static EquivalentConverter<WrappedWatchableObject> getWatchableObjectConverter() {
        return Converters.ignoreNull(new EquivalentConverter<WrappedWatchableObject>(){

            @Override
            public Object getGeneric(WrappedWatchableObject specific) {
                return specific.getHandle();
            }

            @Override
            public WrappedWatchableObject getSpecific(Object generic) {
                if (MinecraftReflection.isWatchableObject(generic)) {
                    return new WrappedWatchableObject(generic);
                }
                if (generic instanceof WrappedWatchableObject) {
                    return (WrappedWatchableObject)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + generic.getClass());
            }

            @Override
            public Class<WrappedWatchableObject> getSpecificType() {
                return WrappedWatchableObject.class;
            }
        });
    }

    public static EquivalentConverter<WrappedDataWatcher> getDataWatcherConverter() {
        return Converters.ignoreNull(new EquivalentConverter<WrappedDataWatcher>(){

            @Override
            public Object getGeneric(WrappedDataWatcher specific) {
                return specific.getHandle();
            }

            @Override
            public WrappedDataWatcher getSpecific(Object generic) {
                if (MinecraftReflection.isDataWatcher(generic)) {
                    return new WrappedDataWatcher(generic);
                }
                if (generic instanceof WrappedDataWatcher) {
                    return (WrappedDataWatcher)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + generic.getClass());
            }

            @Override
            public Class<WrappedDataWatcher> getSpecificType() {
                return WrappedDataWatcher.class;
            }
        });
    }

    public static EquivalentConverter<WorldType> getWorldTypeConverter() {
        if (!hasWorldType) {
            return null;
        }
        final Class<?> worldType = MinecraftReflection.getWorldTypeClass();
        return Converters.ignoreNull(new EquivalentConverter<WorldType>(){

            @Override
            public Object getGeneric(WorldType specific) {
                try {
                    if (worldTypeGetType == null) {
                        worldTypeGetType = FuzzyReflection.fromClass(worldType).getMethodByParameters("getType", (Class<?>)worldType, (Class<?>[])new Class[]{String.class});
                    }
                    return worldTypeGetType.invoke((Object)this, specific.getName());
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot find the WorldType.getType() method.", e);
                }
            }

            @Override
            public WorldType getSpecific(Object generic) {
                try {
                    if (worldTypeName == null) {
                        try {
                            worldTypeName = worldType.getMethod("name", new Class[0]);
                        }
                        catch (Exception e) {
                            worldTypeName = FuzzyReflection.fromClass(worldType).getMethodByParameters("name", (Class<?>)String.class, (Class<?>[])new Class[0]);
                        }
                    }
                    String name = (String)worldTypeName.invoke(generic, new Object[0]);
                    return WorldType.getByName((String)name);
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot call the name method in WorldType.", e);
                }
            }

            @Override
            public Class<WorldType> getSpecificType() {
                return WorldType.class;
            }
        });
    }

    public static EquivalentConverter<NbtBase<?>> getNbtConverter() {
        return Converters.ignoreNull(new EquivalentConverter<NbtBase<?>>(){

            @Override
            public Object getGeneric(NbtBase<?> specific) {
                return NbtFactory.fromBase(specific).getHandle();
            }

            @Override
            public NbtBase<?> getSpecific(Object generic) {
                return NbtFactory.fromNMS(generic, null);
            }

            @Override
            public Class<NbtBase<?>> getSpecificType() {
                Class<NbtBase> dummy = NbtBase.class;
                return dummy;
            }
        });
    }

    public static EquivalentConverter<Entity> getEntityConverter(World world) {
        final WeakReference<ProtocolManager> managerRef = new WeakReference<ProtocolManager>(ProtocolLibrary.getProtocolManager());
        return new WorldSpecificConverter<Entity>(world){

            @Override
            public Object getGeneric(Entity specific) {
                return specific.getEntityId();
            }

            @Override
            public Entity getSpecific(Object generic) {
                try {
                    Integer id = (Integer)generic;
                    ProtocolManager manager = (ProtocolManager)managerRef.get();
                    if (id != null && manager != null) {
                        return manager.getEntityFromID(this.world, id);
                    }
                    return null;
                }
                catch (FieldAccessException e) {
                    throw new RuntimeException("Cannot retrieve entity from ID.", e);
                }
            }

            @Override
            public Class<Entity> getSpecificType() {
                return Entity.class;
            }
        };
    }

    public static EquivalentConverter<ItemStack> getItemStackConverter() {
        return new EquivalentConverter<ItemStack>(){

            @Override
            public ItemStack getSpecific(Object generic) {
                return MinecraftReflection.getBukkitItemStack(generic);
            }

            @Override
            public Object getGeneric(ItemStack specific) {
                return MinecraftReflection.getMinecraftItemStack(specific);
            }

            @Override
            public Class<ItemStack> getSpecificType() {
                return ItemStack.class;
            }
        };
    }

    public static EquivalentConverter<WrappedServerPing> getWrappedServerPingConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedServerPing::fromHandle));
    }

    public static EquivalentConverter<WrappedStatistic> getWrappedStatisticConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedStatistic::fromHandle));
    }

    public static EquivalentConverter<Material> getBlockConverter() {
        if (BLOCK_FROM_MATERIAL == null || MATERIAL_FROM_BLOCK == null) {
            Class<?> magicNumbers = MinecraftReflection.getCraftBukkitClass("util.CraftMagicNumbers");
            Class<?> block = MinecraftReflection.getBlockClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(magicNumbers);
            FuzzyMethodContract.Builder builder = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Material.class).parameterExactArray(block);
            MATERIAL_FROM_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethod(builder.build()));
            builder = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(block).parameterExactArray(Material.class);
            BLOCK_FROM_MATERIAL = Accessors.getMethodAccessor(fuzzy.getMethod(builder.build()));
        }
        return Converters.ignoreNull(new EquivalentConverter<Material>(){

            @Override
            public Object getGeneric(Material specific) {
                return BLOCK_FROM_MATERIAL.invoke(null, specific);
            }

            @Override
            public Material getSpecific(Object generic) {
                return (Material)MATERIAL_FROM_BLOCK.invoke(null, generic);
            }

            @Override
            public Class<Material> getSpecificType() {
                return Material.class;
            }
        });
    }

    public static EquivalentConverter<World> getWorldConverter() {
        return Converters.ignoreNull(new EquivalentConverter<World>(){

            @Override
            public Object getGeneric(World specific) {
                return BukkitUnwrapper.getInstance().unwrapItem(specific);
            }

            @Override
            public World getSpecific(Object generic) {
                return (World)craftWorldField.get(generic);
            }

            @Override
            public Class<World> getSpecificType() {
                return World.class;
            }
        });
    }

    public static EquivalentConverter<PotionEffect> getPotionEffectConverter() {
        return Converters.ignoreNull(new EquivalentConverter<PotionEffect>(){

            @Override
            public Object getGeneric(PotionEffect specific) {
                if (mobEffectConstructor == null) {
                    try {
                        mobEffectConstructor = MinecraftReflection.getMobEffectClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find mob effect constructor (int, int, int, boolean).", e);
                    }
                }
                try {
                    return mobEffectConstructor.newInstance(specific.getType().getId(), specific.getDuration(), specific.getAmplifier(), specific.isAmbient());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot construct MobEffect.", e);
                }
            }

            @Override
            public PotionEffect getSpecific(Object generic) {
                if (mobEffectModifier == null) {
                    mobEffectModifier = new StructureModifier(MinecraftReflection.getMobEffectClass(), false);
                }
                StructureModifier ints = mobEffectModifier.withTarget(generic).withType(Integer.TYPE);
                StructureModifier bools = mobEffectModifier.withTarget(generic).withType(Boolean.TYPE);
                return new PotionEffect(PotionEffectType.getById((int)((Integer)ints.read(0))), ((Integer)ints.read(1)).intValue(), ((Integer)ints.read(2)).intValue(), ((Boolean)bools.read(1)).booleanValue());
            }

            @Override
            public Class<PotionEffect> getSpecificType() {
                return PotionEffect.class;
            }
        });
    }

    public static EquivalentConverter<Vector> getVectorConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Vector>(){

            @Override
            public Class<Vector> getSpecificType() {
                return Vector.class;
            }

            @Override
            public Object getGeneric(Vector specific) {
                if (vec3dConstructor == null) {
                    try {
                        vec3dConstructor = MinecraftReflection.getVec3DClass().getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Could not find Vec3d constructor (double, double, double)");
                    }
                }
                try {
                    return vec3dConstructor.newInstance(specific.getX(), specific.getY(), specific.getZ());
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not construct Vec3d.", ex);
                }
            }

            @Override
            public Vector getSpecific(Object generic) {
                if (vec3dModifier == null) {
                    vec3dModifier = new StructureModifier(MinecraftReflection.getVec3DClass(), false);
                }
                StructureModifier doubles = vec3dModifier.withTarget(generic).withType(Double.TYPE);
                return new Vector(((Double)doubles.read(0)).doubleValue(), ((Double)doubles.read(1)).doubleValue(), ((Double)doubles.read(2)).doubleValue());
            }
        });
    }

    public static EquivalentConverter<Sound> getSoundConverter() {
        if (getSound == null || getSoundEffect == null) {
            Class<?> craftSound = MinecraftReflection.getCraftSoundClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(craftSound, true);
            getSound = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getSound", (Class<?>)String.class, (Class<?>[])new Class[]{Sound.class}));
            getSoundEffect = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getSoundEffect", MinecraftReflection.getSoundEffectClass(), (Class<?>[])new Class[]{String.class}));
        }
        return Converters.ignoreNull(new EquivalentConverter<Sound>(){

            @Override
            public Class<Sound> getSpecificType() {
                return Sound.class;
            }

            @Override
            public Object getGeneric(Sound specific) {
                String key = (String)getSound.invoke(null, specific);
                return getSoundEffect.invoke(null, key);
            }

            @Override
            public Sound getSpecific(Object generic) {
                if (soundKey == null) {
                    Class<?> soundEffect = generic.getClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(soundEffect, true);
                    soundKey = Accessors.getFieldAccessor(fuzzy.getFieldByType("key", MinecraftReflection.getMinecraftKeyClass()));
                }
                MinecraftKey minecraftKey = MinecraftKey.fromHandle(soundKey.get(generic));
                String key = minecraftKey.getKey();
                if (soundIndex != null) {
                    return (Sound)soundIndex.get(key);
                }
                try {
                    return Sound.valueOf((String)minecraftKey.getEnumFormat());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    soundIndex = new ConcurrentHashMap();
                    for (Sound sound : Sound.values()) {
                        String index = (String)getSound.invoke(null, sound);
                        soundIndex.put(index, sound);
                    }
                    return (Sound)soundIndex.get(key);
                }
            }
        });
    }

    public static EquivalentConverter<WrappedParticle> getParticleConverter() {
        return Converters.ignoreNull(Converters.handle(WrappedParticle::getHandle, WrappedParticle::fromHandle));
    }

    public static EquivalentConverter<Advancement> getAdvancementConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Advancement>(){

            @Override
            public Advancement getSpecific(Object generic) {
                try {
                    return (Advancement)MinecraftReflection.getCraftBukkitClass("advancement.CraftAdvancement").getConstructor(MinecraftReflection.getMinecraftClass("Advancement")).newInstance(generic);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Object getGeneric(Advancement specific) {
                return BukkitUnwrapper.getInstance().unwrapItem(specific);
            }

            @Override
            public Class<Advancement> getSpecificType() {
                return Advancement.class;
            }
        });
    }

    public static PacketConstructor.Unwrapper asUnwrapper(Class<?> nativeType, EquivalentConverter<Object> converter) {
        return wrappedObject -> {
            Class<?> type = PacketConstructor.getClass(wrappedObject);
            if (converter.getSpecificType().isAssignableFrom(type)) {
                if (wrappedObject instanceof Class) {
                    return nativeType;
                }
                return converter.getGeneric(wrappedObject);
            }
            return null;
        };
    }

    public static Map<Class<?>, EquivalentConverter<Object>> getConvertersForGeneric() {
        if (genericConverters == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put(MinecraftReflection.getDataWatcherClass(), BukkitConverters.getDataWatcherConverter()).put(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter()).put(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter()).put(MinecraftReflection.getNBTCompoundClass(), BukkitConverters.getNbtConverter()).put(MinecraftReflection.getDataWatcherItemClass(), BukkitConverters.getWatchableObjectConverter()).put(MinecraftReflection.getMobEffectClass(), BukkitConverters.getPotionEffectConverter()).put(MinecraftReflection.getNmsWorldClass(), BukkitConverters.getWorldConverter());
            if (hasWorldType) {
                builder.put(MinecraftReflection.getWorldTypeClass(), BukkitConverters.getWorldTypeConverter());
            }
            if (hasAttributeSnapshot) {
                builder.put(MinecraftReflection.getAttributeSnapshotClass(), BukkitConverters.getWrappedAttributeConverter());
            }
            if (MinecraftReflection.isUsingNetty()) {
                builder.put(MinecraftReflection.getBlockClass(), BukkitConverters.getBlockConverter());
                builder.put(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                builder.put(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                builder.put(MinecraftReflection.getServerPingClass(), BukkitConverters.getWrappedServerPingConverter());
                builder.put(MinecraftReflection.getStatisticClass(), BukkitConverters.getWrappedStatisticConverter());
                for (Map.Entry<Class<?>, EquivalentConverter<?>> entry : EnumWrappers.getFromNativeMap().entrySet()) {
                    builder.put(entry.getKey(), entry.getValue());
                }
            }
            genericConverters = builder.build();
        }
        return genericConverters;
    }

    public static List<PacketConstructor.Unwrapper> getUnwrappers() {
        if (unwrappers == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry<Class<?>, EquivalentConverter<Object>> entry : BukkitConverters.getConvertersForGeneric().entrySet()) {
                builder.add((Object)BukkitConverters.asUnwrapper(entry.getKey(), entry.getValue()));
            }
            unwrappers = builder.build();
        }
        return unwrappers;
    }

    public static EquivalentConverter<PotionEffectType> getEffectTypeConverter() {
        return Converters.ignoreNull(new EquivalentConverter<PotionEffectType>(){

            @Override
            public Class<PotionEffectType> getSpecificType() {
                return PotionEffectType.class;
            }

            @Override
            public Object getGeneric(PotionEffectType specific) {
                Class<?> clazz = MinecraftReflection.getMobEffectListClass();
                if (getMobEffect == null) {
                    getMobEffect = Accessors.getMethodAccessor(clazz, "fromId", Integer.TYPE);
                }
                int id = specific.getId();
                return getMobEffect.invoke(null, id);
            }

            @Override
            public PotionEffectType getSpecific(Object generic) {
                Class<?> clazz = MinecraftReflection.getMobEffectListClass();
                if (getMobEffectId == null) {
                    getMobEffectId = Accessors.getMethodAccessor(clazz, "getId", clazz);
                }
                int id = (Integer)getMobEffectId.invoke(null, generic);
                return PotionEffectType.getById((int)id);
            }
        });
    }

    public static EquivalentConverter<Integer> getDimensionIDConverter() {
        return new EquivalentConverter<Integer>(){

            @Override
            public Object getGeneric(Integer specific) {
                if (dimensionFromId == null) {
                    Class<?> clazz = MinecraftReflection.getMinecraftClass("DimensionManager");
                    FuzzyReflection reflection = FuzzyReflection.fromClass(clazz, false);
                    FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().requireModifier(8).parameterExactType(Integer.TYPE).returnTypeExact(clazz).build();
                    dimensionFromId = Accessors.getMethodAccessor(reflection.getMethod(contract));
                }
                return dimensionFromId.invoke(null, (int)specific);
            }

            @Override
            public Integer getSpecific(Object generic) {
                if (idFromDimension == null) {
                    Class<?> clazz = MinecraftReflection.getMinecraftClass("DimensionManager");
                    FuzzyReflection reflection = FuzzyReflection.fromClass(clazz, false);
                    FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(Integer.TYPE).parameterCount(0).build();
                    idFromDimension = Accessors.getMethodAccessor(reflection.getMethod(contract));
                }
                return (Integer)idFromDimension.invoke(generic, new Object[0]);
            }

            @Override
            public Class<Integer> getSpecificType() {
                return Integer.class;
            }
        };
    }

    static {
        try {
            MinecraftReflection.getWorldTypeClass();
            hasWorldType = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MinecraftReflection.getAttributeSnapshotClass();
            hasAttributeSnapshot = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            craftWorldField = Accessors.getFieldAccessor(MinecraftReflection.getNmsWorldClass(), MinecraftReflection.getCraftWorldClass(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        getSound = null;
        getSoundEffect = null;
        soundKey = null;
        soundIndex = null;
        getMobEffectId = null;
        getMobEffect = null;
        dimensionFromId = null;
        idFromDimension = null;
    }

    private static abstract class WorldSpecificConverter<TType>
    implements EquivalentConverter<TType> {
        protected World world;

        WorldSpecificConverter(World world) {
            this.world = world;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WorldSpecificConverter && super.equals(obj)) {
                WorldSpecificConverter that = (WorldSpecificConverter)obj;
                return Objects.equal((Object)this.world, (Object)that.world);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType(), this.world});
        }
    }

    @Deprecated
    public static abstract class IgnoreNullConverter<TType>
    implements EquivalentConverter<TType> {
        @Override
        public final Object getGeneric(TType specific) {
            if (specific != null) {
                return this.getGenericValue(specific);
            }
            return null;
        }

        public abstract Object getGenericValue(TType var1);

        @Override
        public final TType getSpecific(Object generic) {
            if (generic != null) {
                return this.getSpecificValue(generic);
            }
            return null;
        }

        public abstract TType getSpecificValue(Object var1);

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentConverter) {
                EquivalentConverter that = (EquivalentConverter)obj;
                return Objects.equal(this.getSpecificType(), that.getSpecificType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType()});
        }
    }
}

