/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.utility.ClassSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;

class CachedPackage {
    private final Map<String, Optional<Class<?>>> cache;
    private final String packageName;
    private final ClassSource source;

    public CachedPackage(String packageName, ClassSource source) {
        this.packageName = packageName;
        this.cache = Maps.newConcurrentMap();
        this.source = source;
    }

    public void setPackageClass(String className, Class<?> clazz) {
        if (clazz != null) {
            this.cache.put(className, Optional.of(clazz));
        } else {
            this.cache.remove(className);
        }
    }

    public Optional<Class<?>> getPackageClass(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className cannot be null!");
        return this.cache.computeIfAbsent(className, x -> {
            try {
                return Optional.ofNullable(this.source.loadClass(CachedPackage.combine(this.packageName, className)));
            }
            catch (ClassNotFoundException ex) {
                return Optional.empty();
            }
        });
    }

    public static String combine(String packageName, String className) {
        if (Strings.isNullOrEmpty((String)packageName)) {
            return className;
        }
        if (Strings.isNullOrEmpty((String)className)) {
            return packageName;
        }
        return packageName + "." + className;
    }
}

