/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketTypeEnum;
import com.comphenix.protocol.PacketTypeLookup;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;

public class PacketType
implements Serializable,
Cloneable,
Comparable<PacketType> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PACKET = -1;
    private static PacketTypeLookup LOOKUP;
    private static final MinecraftVersion PROTOCOL_VERSION;
    private final Protocol protocol;
    private final Sender sender;
    private final int currentId;
    private final int legacyId;
    private final MinecraftVersion version;
    private final String[] classNames;
    private String name;
    private boolean deprecated;
    private boolean forceAsync;
    private boolean dynamic;

    private static PacketTypeLookup getLookup() {
        if (LOOKUP == null) {
            LOOKUP = new PacketTypeLookup().addPacketTypes(Handshake.Client.getInstance()).addPacketTypes(Handshake.Server.getInstance()).addPacketTypes(Play.Client.getInstance()).addPacketTypes(Play.Server.getInstance()).addPacketTypes(Status.Client.getInstance()).addPacketTypes(Status.Server.getInstance()).addPacketTypes(Login.Client.getInstance()).addPacketTypes(Login.Server.getInstance()).addPacketTypes(Legacy.Client.getInstance()).addPacketTypes(Legacy.Server.getInstance());
        }
        return LOOKUP;
    }

    public static Iterable<PacketType> values() {
        ArrayList sources = Lists.newArrayList();
        sources.add(Handshake.Client.getInstance());
        sources.add(Handshake.Server.getInstance());
        sources.add(Play.Client.getInstance());
        sources.add(Play.Server.getInstance());
        sources.add(Status.Client.getInstance());
        sources.add(Status.Server.getInstance());
        sources.add(Login.Client.getInstance());
        sources.add(Login.Server.getInstance());
        if (!MinecraftReflection.isUsingNetty()) {
            sources.add(Legacy.Client.getInstance());
            sources.add(Legacy.Server.getInstance());
        }
        return Iterables.concat((Iterable)sources);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId) {
        PacketType type = PacketType.getLookup().getFromLegacy(packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId, Sender preference) {
        if (preference == null) {
            return PacketType.findLegacy(packetId);
        }
        PacketType type = PacketType.getLookup().getFromLegacy(packetId, preference);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static boolean hasLegacy(int packetId) {
        return PacketType.getLookup().getFromLegacy(packetId) != null;
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, int packetId) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + packetId + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, String name) {
        name = PacketType.format(protocol, sender, name);
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + name + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    private static String format(Protocol protocol, Sender sender, String name) {
        if (name.contains("Packet")) {
            return name;
        }
        return String.format("Packet%s%s%s", protocol.getPacketName(), sender.getPacketName(), WordUtils.capitalize((String)name));
    }

    public static boolean hasCurrent(Protocol protocol, Sender sender, int packetId) {
        return PacketType.getLookup().getFromCurrent(protocol, sender, packetId) != null;
    }

    @Deprecated
    public static PacketType fromLegacy(int id, Sender sender) {
        PacketType type = PacketType.getLookup().getFromLegacy(id, sender);
        if (type == null) {
            if (sender == null) {
                throw new IllegalArgumentException("Cannot find legacy packet " + id);
            }
            type = PacketType.newLegacy(sender, id);
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromID(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, packetClass.getName());
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromCurrent(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        String clazz;
        PacketTypeLookup.ClassLookup lookup = PacketType.getLookup().getClassLookup();
        Map<String, PacketType> map = lookup.getMap(protocol, sender);
        PacketType type = PacketType.find(map, clazz = packetClass.getSimpleName());
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, clazz);
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    private static PacketType find(Map<String, PacketType> map, String clazz) {
        PacketType ret = map.get(clazz);
        if (ret != null) {
            return ret;
        }
        for (PacketType check : map.values()) {
            String[] aliases = check.getClassNames();
            if (aliases.length <= 1) continue;
            for (String alias : aliases) {
                if (!alias.equals(clazz)) continue;
                return check;
            }
        }
        return null;
    }

    public static PacketType fromClass(Class<?> packetClass) {
        PacketType type = PacketRegistry.getPacketType(packetClass);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Class " + packetClass + " is not a registered packet.");
    }

    public static Collection<PacketType> fromName(String name) {
        return PacketType.getLookup().getFromName(name);
    }

    public static boolean hasClass(Class<?> packetClass) {
        return PacketRegistry.getPacketType(packetClass) != null;
    }

    public static Future<Boolean> scheduleRegister(final PacketType type, final String name) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                PacketTypeEnum objEnum = PacketType.getObjectEnum(type);
                if (objEnum.registerMember(type, name)) {
                    PacketType.getLookup().addPacketTypes(Arrays.asList(type));
                    return true;
                }
                return false;
            }
        };
        if (Bukkit.getServer() == null || Bukkit.isPrimaryThread()) {
            try {
                return Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return ProtocolLibrary.getExecutorSync().submit((Callable)callable);
    }

    public static PacketTypeEnum getObjectEnum(PacketType type) {
        switch (type.getProtocol()) {
            case HANDSHAKING: {
                return type.isClient() ? Handshake.Client.getInstance() : Handshake.Server.getInstance();
            }
            case PLAY: {
                return type.isClient() ? Play.Client.getInstance() : Play.Server.getInstance();
            }
            case STATUS: {
                return type.isClient() ? Status.Client.getInstance() : Status.Server.getInstance();
            }
            case LOGIN: {
                return type.isClient() ? Login.Client.getInstance() : Login.Server.getInstance();
            }
            case LEGACY: {
                return type.isClient() ? Legacy.Client.getInstance() : Legacy.Server.getInstance();
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + (Object)((Object)type.getProtocol()));
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, String ... names) {
        this(protocol, sender, currentId, legacyId, PROTOCOL_VERSION, names);
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, MinecraftVersion version, String ... names) {
        this.protocol = (Protocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol cannot be NULL"));
        this.sender = (Sender)((Object)Preconditions.checkNotNull((Object)((Object)sender), (Object)"sender cannot be NULL"));
        this.currentId = currentId;
        this.legacyId = legacyId;
        this.version = version;
        this.classNames = new String[names.length];
        for (int i = 0; i < this.classNames.length; ++i) {
            this.classNames[i] = PacketType.format(protocol, sender, names[i]);
        }
    }

    public static PacketType newLegacy(Sender sender, int legacyId) {
        return new PacketType(Protocol.LEGACY, sender, -1, legacyId, MinecraftVersion.WORLD_UPDATE, new String[0]);
    }

    public boolean isSupported() {
        return PacketRegistry.isSupported(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isClient() {
        return this.sender == Sender.CLIENT;
    }

    public boolean isServer() {
        return this.sender == Sender.SERVER;
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public Class<?> getPacketClass() {
        try {
            return PacketRegistry.getPacketClassFromType(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    void setDeprecated() {
        this.deprecated = true;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    void forceAsync() {
        this.forceAsync = true;
    }

    public boolean isAsyncForced() {
        return this.forceAsync;
    }

    public MinecraftVersion getCurrentVersion() {
        return this.version;
    }

    @Deprecated
    public int getLegacyId() {
        return this.legacyId;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.protocol, this.sender, this.currentId});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PacketType) {
            PacketType other = (PacketType)obj;
            return this.protocol == other.protocol && this.sender == other.sender && this.currentId == other.currentId;
        }
        return false;
    }

    @Override
    public int compareTo(PacketType other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.protocol), (Comparable)((Object)other.getProtocol())).compare((Comparable)((Object)this.sender), (Comparable)((Object)other.getSender())).compare(this.currentId, other.getCurrentId()).result();
    }

    public String toString() {
        Class<?> clazz = this.getPacketClass();
        if (clazz == null) {
            return this.name() + "[" + (Object)((Object)this.protocol) + ", " + (Object)((Object)this.sender) + ", " + this.currentId + ", classNames: " + Arrays.toString(this.classNames) + " (unregistered)]";
        }
        return this.name() + "[class=" + clazz.getSimpleName() + ", id=" + this.currentId + "]";
    }

    public PacketType clone() {
        try {
            return (PacketType)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("This shouldn't happen", ex);
        }
    }

    static {
        PROTOCOL_VERSION = MinecraftVersion.EXPLORATION_UPDATE;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForceAsync {
    }

    public static enum Sender {
        CLIENT,
        SERVER;


        public ConnectionSide toSide() {
            return this == CLIENT ? ConnectionSide.CLIENT_SIDE : ConnectionSide.SERVER_SIDE;
        }

        public String getPacketName() {
            return this == CLIENT ? "In" : "Out";
        }
    }

    public static enum Protocol {
        HANDSHAKING,
        PLAY,
        STATUS,
        LOGIN,
        LEGACY;


        public static Protocol fromVanilla(Enum<?> vanilla) {
            String name = vanilla.name();
            if ("HANDSHAKING".equals(name)) {
                return HANDSHAKING;
            }
            if ("PLAY".equals(name)) {
                return PLAY;
            }
            if ("STATUS".equals(name)) {
                return STATUS;
            }
            if ("LOGIN".equals(name)) {
                return LOGIN;
            }
            throw new IllegalArgumentException("Unrecognized vanilla enum " + vanilla);
        }

        public String getPacketName() {
            return WordUtils.capitalize((String)this.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static class Legacy {
        private static final Protocol PROTOCOL = Protocol.LEGACY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType LOGIN = PacketType.newLegacy(SENDER, 1);
            public static final PacketType RESPAWN = PacketType.newLegacy(SENDER, 9);
            public static final PacketType DISCONNECT = PacketType.newLegacy(SENDER, 255);
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType PLAYER_FLYING = PacketType.newLegacy(SENDER, 10);
            public static final PacketType PLAYER_POSITION = PacketType.newLegacy(SENDER, 11);
            public static final PacketType PLAYER_POSITON_LOOK = PacketType.newLegacy(SENDER, 12);
            public static final PacketType PICKUP_SPAWN = PacketType.newLegacy(SENDER, 21);
            public static final PacketType SET_CREATIVE_SLOT = PacketType.newLegacy(SENDER, 107);
            public static final PacketType KEY_RESPONSE = PacketType.newLegacy(SENDER, 252);
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Login {
        private static final Protocol PROTOCOL = Protocol.LOGIN;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$300() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Login.access$300(), SENDER, 0, 0, "Start");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$300(), SENDER, 1, 1, "EncryptionBegin");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Login.access$300(), SENDER, 2, -1, "CustomPayload");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType DISCONNECT = new PacketType(Login.access$300(), SENDER, 0, 0, "Disconnect");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$300(), SENDER, 1, 1, "EncryptionBegin");
            public static final PacketType SUCCESS = new PacketType(Login.access$300(), SENDER, 2, 2, "Success");
            public static final PacketType SET_COMPRESSION = new PacketType(Login.access$300(), SENDER, 3, 3, "SetCompression");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Login.access$300(), SENDER, 4, -1, "CustomPayload");
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Status {
        private static final Protocol PROTOCOL = Protocol.STATUS;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$200() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Status.access$200(), SENDER, 0, 0, "Start");
            public static final PacketType PING = new PacketType(Status.access$200(), SENDER, 1, 1, "Ping");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            @ForceAsync
            public static final PacketType SERVER_INFO = new PacketType(Status.access$200(), SENDER, 0, 0, "ServerInfo");
            public static final PacketType PONG = new PacketType(Status.access$200(), SENDER, 1, 1, "Pong");
            @Deprecated
            @ForceAsync
            public static final PacketType OUT_SERVER_INFO = SERVER_INFO.clone();
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Play {
        private static final Protocol PROTOCOL = Protocol.PLAY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$100() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType TELEPORT_ACCEPT = new PacketType(Play.access$100(), SENDER, 0, 0, "TeleportAccept");
            public static final PacketType TILE_NBT_QUERY = new PacketType(Play.access$100(), SENDER, 1, -1, "TileNBTQuery");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 2, 2, "Chat");
            public static final PacketType CLIENT_COMMAND = new PacketType(Play.access$100(), SENDER, 3, 3, "ClientCommand");
            public static final PacketType SETTINGS = new PacketType(Play.access$100(), SENDER, 4, 4, "Settings");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 5, 1, "TabComplete");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 6, 5, "Transaction");
            public static final PacketType ENCHANT_ITEM = new PacketType(Play.access$100(), SENDER, 7, 6, "EnchantItem");
            public static final PacketType WINDOW_CLICK = new PacketType(Play.access$100(), SENDER, 8, 7, "WindowClick");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 9, 8, "CloseWindow");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 10, 9, "CustomPayload");
            public static final PacketType BOOK_EDIT = new PacketType(Play.access$100(), SENDER, 11, -1, "BEdit");
            public static final PacketType ENTITY_NBT_QUERY = new PacketType(Play.access$100(), SENDER, 12, -1, "EntityNBTQuery");
            public static final PacketType USE_ENTITY = new PacketType(Play.access$100(), SENDER, 13, 10, "UseEntity");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 14, 11, "KeepAlive");
            public static final PacketType FLYING = new PacketType(Play.access$100(), SENDER, 15, 12, "Flying");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 16, 13, "Position");
            public static final PacketType POSITION_LOOK = new PacketType(Play.access$100(), SENDER, 17, 14, "PositionLook");
            public static final PacketType LOOK = new PacketType(Play.access$100(), SENDER, 18, 15, "Look");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 19, 16, "VehicleMove");
            public static final PacketType BOAT_MOVE = new PacketType(Play.access$100(), SENDER, 20, 17, "BoatMove");
            public static final PacketType PICK_ITEM = new PacketType(Play.access$100(), SENDER, 21, -1, "PickItem");
            public static final PacketType AUTO_RECIPE = new PacketType(Play.access$100(), SENDER, 22, 18, "AutoRecipe");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 23, 19, "Abilities");
            public static final PacketType BLOCK_DIG = new PacketType(Play.access$100(), SENDER, 24, 20, "BlockDig");
            public static final PacketType ENTITY_ACTION = new PacketType(Play.access$100(), SENDER, 25, 21, "EntityAction");
            public static final PacketType STEER_VEHICLE = new PacketType(Play.access$100(), SENDER, 26, 22, "SteerVehicle");
            public static final PacketType RECIPE_DISPLAYED = new PacketType(Play.access$100(), SENDER, 27, 23, "RecipeDisplayed");
            public static final PacketType ITEM_NAME = new PacketType(Play.access$100(), SENDER, 28, -1, "ItemName");
            public static final PacketType RESOURCE_PACK_STATUS = new PacketType(Play.access$100(), SENDER, 29, 24, "ResourcePackStatus");
            public static final PacketType ADVANCEMENTS = new PacketType(Play.access$100(), SENDER, 30, 25, "Advancements");
            public static final PacketType TRADE_SELECT = new PacketType(Play.access$100(), SENDER, 31, -1, "TrSel");
            public static final PacketType BEACON = new PacketType(Play.access$100(), SENDER, 32, -1, "Beacon");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 33, 26, "HeldItemSlot");
            public static final PacketType SET_COMMAND_BLOCK = new PacketType(Play.access$100(), SENDER, 34, 34, "SetCommandBlock");
            public static final PacketType SET_COMMAND_MINECART = new PacketType(Play.access$100(), SENDER, 35, 35, "SetCommandMinecart");
            public static final PacketType SET_CREATIVE_SLOT = new PacketType(Play.access$100(), SENDER, 36, 27, "SetCreativeSlot");
            public static final PacketType STRUCTURE_BLOCK = new PacketType(Play.access$100(), SENDER, 37, 37, "Struct");
            public static final PacketType UPDATE_SIGN = new PacketType(Play.access$100(), SENDER, 38, 28, "UpdateSign");
            public static final PacketType ARM_ANIMATION = new PacketType(Play.access$100(), SENDER, 39, 29, "ArmAnimation");
            public static final PacketType SPECTATE = new PacketType(Play.access$100(), SENDER, 40, 30, "Spectate");
            public static final PacketType USE_ITEM = new PacketType(Play.access$100(), SENDER, 41, 31, "UseItem");
            public static final PacketType BLOCK_PLACE = new PacketType(Play.access$100(), SENDER, 42, 32, "BlockPlace");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType SPAWN_ENTITY = new PacketType(Play.access$100(), SENDER, 0, 0, "SpawnEntity");
            public static final PacketType SPAWN_ENTITY_EXPERIENCE_ORB = new PacketType(Play.access$100(), SENDER, 1, 1, "SpawnEntityExperienceOrb");
            public static final PacketType SPAWN_ENTITY_WEATHER = new PacketType(Play.access$100(), SENDER, 2, 2, "SpawnEntityWeather");
            public static final PacketType SPAWN_ENTITY_LIVING = new PacketType(Play.access$100(), SENDER, 3, 3, "SpawnEntityLiving");
            public static final PacketType SPAWN_ENTITY_PAINTING = new PacketType(Play.access$100(), SENDER, 4, 4, "SpawnEntityPainting");
            public static final PacketType NAMED_ENTITY_SPAWN = new PacketType(Play.access$100(), SENDER, 5, 5, "NamedEntitySpawn");
            public static final PacketType ANIMATION = new PacketType(Play.access$100(), SENDER, 6, 6, "Animation");
            public static final PacketType STATISTIC = new PacketType(Play.access$100(), SENDER, 7, 7, "Statistic");
            public static final PacketType BLOCK_BREAK_ANIMATION = new PacketType(Play.access$100(), SENDER, 8, 8, "BlockBreakAnimation");
            public static final PacketType TILE_ENTITY_DATA = new PacketType(Play.access$100(), SENDER, 9, 9, "TileEntityData");
            public static final PacketType BLOCK_ACTION = new PacketType(Play.access$100(), SENDER, 10, 10, "BlockAction");
            public static final PacketType BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 11, 11, "BlockChange");
            public static final PacketType BOSS = new PacketType(Play.access$100(), SENDER, 12, 12, "Boss");
            public static final PacketType SERVER_DIFFICULTY = new PacketType(Play.access$100(), SENDER, 13, 13, "ServerDifficulty");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 14, 15, "Chat");
            public static final PacketType MULTI_BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 15, 16, "MultiBlockChange");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 16, 14, "TabComplete");
            public static final PacketType COMMANDS = new PacketType(Play.access$100(), SENDER, 17, -1, "Commands");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 18, 17, "Transaction");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 19, 18, "CloseWindow");
            public static final PacketType OPEN_WINDOW = new PacketType(Play.access$100(), SENDER, 20, 19, "OpenWindow");
            public static final PacketType WINDOW_ITEMS = new PacketType(Play.access$100(), SENDER, 21, 20, "WindowItems");
            public static final PacketType WINDOW_DATA = new PacketType(Play.access$100(), SENDER, 22, 21, "WindowData");
            public static final PacketType SET_SLOT = new PacketType(Play.access$100(), SENDER, 23, 22, "SetSlot");
            public static final PacketType SET_COOLDOWN = new PacketType(Play.access$100(), SENDER, 24, 23, "SetCooldown");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 25, 24, "CustomPayload");
            public static final PacketType CUSTOM_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 26, 25, "CustomSoundEffect");
            public static final PacketType KICK_DISCONNECT = new PacketType(Play.access$100(), SENDER, 27, 26, "KickDisconnect");
            public static final PacketType ENTITY_STATUS = new PacketType(Play.access$100(), SENDER, 28, 27, "EntityStatus");
            public static final PacketType NBT_QUERY = new PacketType(Play.access$100(), SENDER, 29, -1, "NBTQuery");
            public static final PacketType EXPLOSION = new PacketType(Play.access$100(), SENDER, 30, 28, "Explosion");
            public static final PacketType UNLOAD_CHUNK = new PacketType(Play.access$100(), SENDER, 31, 29, "UnloadChunk");
            public static final PacketType GAME_STATE_CHANGE = new PacketType(Play.access$100(), SENDER, 32, 30, "GameStateChange");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 33, 31, "KeepAlive");
            public static final PacketType MAP_CHUNK = new PacketType(Play.access$100(), SENDER, 34, 32, "MapChunk");
            public static final PacketType WORLD_EVENT = new PacketType(Play.access$100(), SENDER, 35, 33, "WorldEvent");
            public static final PacketType WORLD_PARTICLES = new PacketType(Play.access$100(), SENDER, 36, 34, "WorldParticles");
            public static final PacketType LOGIN = new PacketType(Play.access$100(), SENDER, 37, 35, "Login");
            public static final PacketType MAP = new PacketType(Play.access$100(), SENDER, 38, 36, "Map");
            public static final PacketType ENTITY = new PacketType(Play.access$100(), SENDER, 39, 37, "Entity");
            public static final PacketType REL_ENTITY_MOVE = new PacketType(Play.access$100(), SENDER, 40, 38, "RelEntityMove");
            public static final PacketType REL_ENTITY_MOVE_LOOK = new PacketType(Play.access$100(), SENDER, 41, 39, "RelEntityMoveLook");
            public static final PacketType ENTITY_LOOK = new PacketType(Play.access$100(), SENDER, 42, 40, "EntityLook");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 43, 41, "VehicleMove");
            public static final PacketType OPEN_SIGN_EDITOR = new PacketType(Play.access$100(), SENDER, 44, 42, "OpenSignEditor");
            public static final PacketType AUTO_RECIPE = new PacketType(Play.access$100(), SENDER, 45, 43, "AutoRecipe");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 46, 44, "Abilities");
            public static final PacketType COMBAT_EVENT = new PacketType(Play.access$100(), SENDER, 47, 45, "CombatEvent");
            public static final PacketType PLAYER_INFO = new PacketType(Play.access$100(), SENDER, 48, 46, "PlayerInfo");
            public static final PacketType LOOK_AT = new PacketType(Play.access$100(), SENDER, 49, -1, "LookAt");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 50, 47, "Position");
            public static final PacketType BED = new PacketType(Play.access$100(), SENDER, 51, 48, "Bed");
            public static final PacketType RECIPES = new PacketType(Play.access$100(), SENDER, 52, 49, "Recipes");
            public static final PacketType ENTITY_DESTROY = new PacketType(Play.access$100(), SENDER, 53, 50, "EntityDestroy");
            public static final PacketType REMOVE_ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 54, 51, "RemoveEntityEffect");
            public static final PacketType RESOURCE_PACK_SEND = new PacketType(Play.access$100(), SENDER, 55, 52, "ResourcePackSend");
            public static final PacketType RESPAWN = new PacketType(Play.access$100(), SENDER, 56, 53, "Respawn");
            public static final PacketType ENTITY_HEAD_ROTATION = new PacketType(Play.access$100(), SENDER, 57, 54, "EntityHeadRotation");
            public static final PacketType SELECT_ADVANCEMENT_TAB = new PacketType(Play.access$100(), SENDER, 58, 55, "SelectAdvancementTab");
            public static final PacketType WORLD_BORDER = new PacketType(Play.access$100(), SENDER, 59, 56, "WorldBorder");
            public static final PacketType CAMERA = new PacketType(Play.access$100(), SENDER, 60, 57, "Camera");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 61, 58, "HeldItemSlot");
            public static final PacketType SCOREBOARD_DISPLAY_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 62, 59, "ScoreboardDisplayObjective");
            public static final PacketType ENTITY_METADATA = new PacketType(Play.access$100(), SENDER, 63, 60, "EntityMetadata");
            public static final PacketType ATTACH_ENTITY = new PacketType(Play.access$100(), SENDER, 64, 61, "AttachEntity");
            public static final PacketType ENTITY_VELOCITY = new PacketType(Play.access$100(), SENDER, 65, 62, "EntityVelocity");
            public static final PacketType ENTITY_EQUIPMENT = new PacketType(Play.access$100(), SENDER, 66, 63, "EntityEquipment");
            public static final PacketType EXPERIENCE = new PacketType(Play.access$100(), SENDER, 67, 64, "Experience");
            public static final PacketType UPDATE_HEALTH = new PacketType(Play.access$100(), SENDER, 68, 65, "UpdateHealth");
            public static final PacketType SCOREBOARD_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 69, 66, "ScoreboardObjective");
            public static final PacketType MOUNT = new PacketType(Play.access$100(), SENDER, 70, 67, "Mount");
            public static final PacketType SCOREBOARD_TEAM = new PacketType(Play.access$100(), SENDER, 71, 68, "ScoreboardTeam");
            public static final PacketType SCOREBOARD_SCORE = new PacketType(Play.access$100(), SENDER, 72, 69, "ScoreboardScore");
            public static final PacketType SPAWN_POSITION = new PacketType(Play.access$100(), SENDER, 73, 70, "SpawnPosition");
            public static final PacketType UPDATE_TIME = new PacketType(Play.access$100(), SENDER, 74, 71, "UpdateTime");
            public static final PacketType TITLE = new PacketType(Play.access$100(), SENDER, 75, 72, "Title");
            public static final PacketType STOP_SOUND = new PacketType(Play.access$100(), SENDER, 76, -1, "StopSound");
            public static final PacketType NAMED_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 77, 73, "NamedSoundEffect");
            public static final PacketType PLAYER_LIST_HEADER_FOOTER = new PacketType(Play.access$100(), SENDER, 78, 74, "PlayerListHeaderFooter");
            public static final PacketType COLLECT = new PacketType(Play.access$100(), SENDER, 79, 75, "Collect");
            public static final PacketType ENTITY_TELEPORT = new PacketType(Play.access$100(), SENDER, 80, 76, "EntityTeleport");
            public static final PacketType ADVANCEMENTS = new PacketType(Play.access$100(), SENDER, 81, 77, "Advancements");
            public static final PacketType UPDATE_ATTRIBUTES = new PacketType(Play.access$100(), SENDER, 82, 78, "UpdateAttributes");
            public static final PacketType ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 83, 79, "EntityEffect");
            public static final PacketType RECIPE_UPDATE = new PacketType(Play.access$100(), SENDER, 84, 84, "RecipeUpdate");
            public static final PacketType TAGS = new PacketType(Play.access$100(), SENDER, 85, 85, "Tags");
            @Deprecated
            public static final PacketType MAP_CHUNK_BULK = new PacketType(Play.access$100(), SENDER, 255, 255, "MapChunkBulk");
            @Deprecated
            public static final PacketType SET_COMPRESSION = new PacketType(Play.access$100(), SENDER, 254, 254, "SetCompression");
            @Deprecated
            public static final PacketType UPDATE_ENTITY_NBT = new PacketType(Play.access$100(), SENDER, 253, 253, "UpdateEntityNBT");
            @Deprecated
            public static final PacketType CRAFT_PROGRESS_BAR = WINDOW_DATA.clone();
            @Deprecated
            public static final PacketType ENTITY_MOVE_LOOK = REL_ENTITY_MOVE_LOOK.clone();
            @Deprecated
            public static final PacketType STATISTICS = STATISTIC.clone();
            @Deprecated
            public static final PacketType OPEN_SIGN_ENTITY = OPEN_SIGN_EDITOR.clone();
            @Deprecated
            public static final PacketType UPDATE_SIGN = MinecraftReflection.signUpdateExists() ? new PacketType(Play.access$100(), SENDER, 252, 252, "UpdateSign") : TILE_ENTITY_DATA.clone();
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Handshake {
        private static final Protocol PROTOCOL = Protocol.HANDSHAKING;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$000() {
            return PROTOCOL;
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Server getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType SET_PROTOCOL = new PacketType(Handshake.access$000(), SENDER, 0, 0, "SetProtocol");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Client getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }
    }
}

