/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.error;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReportType {
    private final String errorFormat;
    protected String reportName;

    public ReportType(String errorFormat) {
        this.errorFormat = errorFormat;
    }

    public String getMessage(Object[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return this.toString();
        }
        return String.format(this.errorFormat, parameters);
    }

    public String toString() {
        return this.errorFormat;
    }

    public static Class<?> getSenderClass(Object sender) {
        if (sender == null) {
            throw new IllegalArgumentException("sender cannot be NUll.");
        }
        if (sender instanceof Class) {
            return (Class)sender;
        }
        return sender.getClass();
    }

    public static String getReportName(Object sender, ReportType type) {
        if (sender == null) {
            throw new IllegalArgumentException("sender cannot be NUll.");
        }
        return ReportType.getReportName(ReportType.getSenderClass(sender), type);
    }

    private static String getReportName(Class<?> sender, ReportType type) {
        if (sender == null) {
            throw new IllegalArgumentException("sender cannot be NUll.");
        }
        if (type.reportName == null) {
            for (Field field : ReportType.getReportFields(sender)) {
                try {
                    field.setAccessible(true);
                    if (field.get(null) != type) continue;
                    type.reportName = field.getDeclaringClass().getCanonicalName() + "#" + field.getName();
                    return type.reportName;
                }
                catch (IllegalAccessException e) {
                    throw new FieldAccessException("Unable to read field " + field, e);
                }
            }
            throw new IllegalArgumentException("Cannot find report name for " + type);
        }
        return type.reportName;
    }

    public static ReportType[] getReports(Class<?> sender) {
        if (sender == null) {
            throw new IllegalArgumentException("sender cannot be NULL.");
        }
        ArrayList<ReportType> result = new ArrayList<ReportType>();
        for (Field field : ReportType.getReportFields(sender)) {
            try {
                field.setAccessible(true);
                result.add((ReportType)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException("Unable to read field " + field, e);
            }
        }
        return result.toArray(new ReportType[0]);
    }

    private static List<Field> getReportFields(Class<?> clazz) {
        return FuzzyReflection.fromClass(clazz).getFieldList(FuzzyFieldContract.newBuilder().requireModifier(8).typeDerivedOf(ReportType.class).build());
    }
}

