/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.utility.SnapshotVersion;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class MinecraftVersion
implements Comparable<MinecraftVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*\\(.*MC.\\s*([a-zA-z0-9\\-\\.]+)\\s*\\)");
    public static final MinecraftVersion AQUATIC_UPDATE = new MinecraftVersion("1.13");
    public static final MinecraftVersion COLOR_UPDATE = new MinecraftVersion("1.12");
    public static final MinecraftVersion EXPLORATION_UPDATE = new MinecraftVersion("1.11");
    public static final MinecraftVersion FROSTBURN_UPDATE = new MinecraftVersion("1.10");
    public static final MinecraftVersion COMBAT_UPDATE = new MinecraftVersion("1.9");
    public static final MinecraftVersion BOUNTIFUL_UPDATE = new MinecraftVersion("1.8");
    public static final MinecraftVersion SKIN_UPDATE = new MinecraftVersion("1.7.8");
    public static final MinecraftVersion WORLD_UPDATE = new MinecraftVersion("1.7.2");
    public static final MinecraftVersion HORSE_UPDATE = new MinecraftVersion("1.6.1");
    public static final MinecraftVersion REDSTONE_UPDATE = new MinecraftVersion("1.5.0");
    public static final MinecraftVersion SCARY_UPDATE = new MinecraftVersion("1.4.2");
    private final int major;
    private final int minor;
    private final int build;
    private final String development;
    private final SnapshotVersion snapshot;
    private static MinecraftVersion currentVersion;

    public MinecraftVersion(Server server) {
        this(MinecraftVersion.extractVersion(server.getVersion()));
    }

    public MinecraftVersion(String versionOnly) {
        this(versionOnly, true);
    }

    private MinecraftVersion(String versionOnly, boolean parseSnapshot) {
        String[] section = versionOnly.split("-");
        SnapshotVersion snapshot = null;
        int[] numbers = new int[3];
        try {
            numbers = this.parseVersion(section[0]);
        }
        catch (NumberFormatException cause) {
            if (!parseSnapshot) {
                throw cause;
            }
            try {
                snapshot = new SnapshotVersion(section[0]);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                MinecraftVersion latest = new MinecraftVersion("1.12.2", false);
                boolean newer = snapshot.getSnapshotDate().compareTo(format.parse("2017-09-18")) > 0;
                numbers[0] = latest.getMajor();
                numbers[1] = latest.getMinor() + (newer ? 1 : -1);
                numbers[2] = 0;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot parse " + section[0], e);
            }
        }
        this.major = numbers[0];
        this.minor = numbers[1];
        this.build = numbers[2];
        this.development = section.length > 1 ? section[1] : (snapshot != null ? "snapshot" : null);
        this.snapshot = snapshot;
    }

    public MinecraftVersion(int major, int minor, int build) {
        this(major, minor, build, null);
    }

    public MinecraftVersion(int major, int minor, int build, String development) {
        this.major = major;
        this.minor = minor;
        this.build = build;
        this.development = development;
        this.snapshot = null;
    }

    private int[] parseVersion(String version) {
        String[] elements = version.split("\\.");
        int[] numbers = new int[3];
        if (elements.length < 1) {
            throw new IllegalStateException("Corrupt MC version: " + version);
        }
        for (int i = 0; i < Math.min(numbers.length, elements.length); ++i) {
            numbers[i] = Integer.parseInt(elements[i].trim());
        }
        return numbers;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public String getDevelopmentStage() {
        return this.development;
    }

    public SnapshotVersion getSnapshot() {
        return this.snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public String getVersion() {
        if (this.getDevelopmentStage() == null) {
            return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getBuild());
        }
        return String.format("%s.%s.%s-%s%s", this.getMajor(), this.getMinor(), this.getBuild(), this.getDevelopmentStage(), this.isSnapshot() ? this.snapshot : "");
    }

    @Override
    public int compareTo(MinecraftVersion o) {
        if (o == null) {
            return 1;
        }
        return ComparisonChain.start().compare(this.getMajor(), o.getMajor()).compare(this.getMinor(), o.getMinor()).compare(this.getBuild(), o.getBuild()).compare((Object)this.getDevelopmentStage(), (Object)o.getDevelopmentStage(), (Comparator)Ordering.natural().nullsLast()).compare((Object)this.getSnapshot(), (Object)o.getSnapshot(), (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public boolean isAtLeast(MinecraftVersion other) {
        if (other == null) {
            return false;
        }
        return this.compareTo(other) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MinecraftVersion) {
            MinecraftVersion other = (MinecraftVersion)obj;
            return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor() && this.getBuild() == other.getBuild() && Objects.equal((Object)this.getDevelopmentStage(), (Object)other.getDevelopmentStage());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMajor(), this.getMinor(), this.getBuild()});
    }

    public String toString() {
        return String.format("(MC: %s)", this.getVersion());
    }

    public static String extractVersion(String text) {
        Matcher version = VERSION_PATTERN.matcher(text);
        if (version.matches() && version.group(1) != null) {
            return version.group(1);
        }
        throw new IllegalStateException("Cannot parse version String '" + text + "'");
    }

    public static MinecraftVersion fromServerVersion(String serverVersion) {
        return new MinecraftVersion(MinecraftVersion.extractVersion(serverVersion));
    }

    public static void setCurrentVersion(MinecraftVersion version) {
        currentVersion = version;
    }

    public static MinecraftVersion getCurrentVersion() {
        if (currentVersion == null) {
            currentVersion = MinecraftVersion.fromServerVersion(Bukkit.getVersion());
        }
        return currentVersion;
    }

    public static boolean atOrAbove(MinecraftVersion version) {
        return MinecraftVersion.getCurrentVersion().isAtLeast(version);
    }
}

