/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.WrappedAttributeModifier;
import com.comphenix.protocol.wrappers.collection.CachedSet;
import com.comphenix.protocol.wrappers.collection.ConvertedSet;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public class WrappedAttribute
extends AbstractWrapper {
    private static StructureModifier<Object> ATTRIBUTE_MODIFIER;
    private static Constructor<?> ATTRIBUTE_CONSTRUCTOR;
    protected Object handle;
    protected StructureModifier<Object> modifier;
    private double computedValue = Double.NaN;
    private Set<WrappedAttributeModifier> attributeModifiers;

    private WrappedAttribute(@Nonnull Object handle) {
        super(MinecraftReflection.getAttributeSnapshotClass());
        this.setHandle(handle);
        if (ATTRIBUTE_MODIFIER == null) {
            ATTRIBUTE_MODIFIER = new StructureModifier(MinecraftReflection.getAttributeSnapshotClass());
        }
        this.modifier = ATTRIBUTE_MODIFIER.withTarget(handle);
    }

    public static WrappedAttribute fromHandle(@Nonnull Object handle) {
        return new WrappedAttribute(handle);
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(@Nonnull WrappedAttribute template) {
        return new Builder((WrappedAttribute)Preconditions.checkNotNull((Object)template, (Object)"template cannot be NULL."));
    }

    public String getAttributeKey() {
        return (String)this.modifier.withType(String.class).read(0);
    }

    public double getBaseValue() {
        return (Double)this.modifier.withType(Double.TYPE).read(0);
    }

    public double getFinalValue() {
        if (Double.isNaN(this.computedValue)) {
            this.computedValue = this.computeValue();
        }
        return this.computedValue;
    }

    public PacketContainer getParentPacket() {
        return new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES, this.modifier.withType(MinecraftReflection.getPacketClass()).read(0));
    }

    public boolean hasModifier(UUID id) {
        return this.getModifiers().contains(WrappedAttributeModifier.newBuilder(id).build());
    }

    public WrappedAttributeModifier getModifierByUUID(UUID id) {
        if (this.hasModifier(id)) {
            for (WrappedAttributeModifier modifier : this.getModifiers()) {
                if (!Objects.equal((Object)modifier.getUUID(), (Object)id)) continue;
                return modifier;
            }
        }
        return null;
    }

    public Set<WrappedAttributeModifier> getModifiers() {
        if (this.attributeModifiers == null) {
            Collection collection = (Collection)this.modifier.withType(Collection.class).read(0);
            ConvertedSet<Object, WrappedAttributeModifier> converted = new ConvertedSet<Object, WrappedAttributeModifier>(WrappedAttribute.getSetSafely(collection)){

                @Override
                protected Object toInner(WrappedAttributeModifier outer) {
                    return outer.getHandle();
                }

                @Override
                protected WrappedAttributeModifier toOuter(Object inner) {
                    return WrappedAttributeModifier.fromHandle(inner);
                }
            };
            this.attributeModifiers = new CachedSet<WrappedAttributeModifier>(converted);
        }
        return Collections.unmodifiableSet(this.attributeModifiers);
    }

    public WrappedAttribute withModifiers(Collection<WrappedAttributeModifier> modifiers) {
        return WrappedAttribute.newBuilder(this).modifiers(modifiers).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WrappedAttribute) {
            WrappedAttribute other = (WrappedAttribute)obj;
            if (this.getBaseValue() == other.getBaseValue() && Objects.equal((Object)this.getAttributeKey(), (Object)other.getAttributeKey())) {
                return this.getModifiers().stream().filter(elem -> !other.getModifiers().contains(elem)).count() == 0L;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.attributeModifiers == null) {
            this.getModifiers();
        }
        return Objects.hashCode((Object[])new Object[]{this.getAttributeKey(), this.getBaseValue(), this.attributeModifiers});
    }

    private double computeValue() {
        Set<WrappedAttributeModifier> modifiers = this.getModifiers();
        double x = this.getBaseValue();
        double y = 0.0;
        for (int phase = 0; phase < 3; ++phase) {
            block6: for (WrappedAttributeModifier modifier : modifiers) {
                if (modifier.getOperation().getId() != phase) continue;
                switch (phase) {
                    case 0: {
                        x += modifier.getAmount();
                        continue block6;
                    }
                    case 1: {
                        y += x * modifier.getAmount();
                        continue block6;
                    }
                    case 2: {
                        y *= 1.0 + modifier.getAmount();
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unknown phase: " + phase);
            }
            if (phase != 0) continue;
            y = x;
        }
        return y;
    }

    @Override
    public String toString() {
        return "WrappedAttribute[key=" + this.getAttributeKey() + ", base=" + this.getBaseValue() + ", final=" + this.getFinalValue() + ", modifiers=" + this.getModifiers() + "]";
    }

    private static <U> Set<U> getSetSafely(Collection<U> collection) {
        return collection instanceof Set ? (Set)collection : Sets.newHashSet(collection);
    }

    static double checkDouble(double value) {
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("value cannot be infinite.");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value cannot be NaN.");
        }
        return value;
    }

    public static class Builder {
        private double baseValue = Double.NaN;
        private String attributeKey;
        private PacketContainer packet;
        private Collection<WrappedAttributeModifier> modifiers = Collections.emptyList();

        private Builder(WrappedAttribute template) {
            if (template != null) {
                this.baseValue = template.getBaseValue();
                this.attributeKey = template.getAttributeKey();
                this.packet = template.getParentPacket();
                this.modifiers = template.getModifiers();
            }
        }

        public Builder baseValue(double baseValue) {
            this.baseValue = WrappedAttribute.checkDouble(baseValue);
            return this;
        }

        public Builder attributeKey(String attributeKey) {
            this.attributeKey = (String)Preconditions.checkNotNull((Object)attributeKey, (Object)"attributeKey cannot be NULL.");
            return this;
        }

        public Builder modifiers(Collection<WrappedAttributeModifier> modifiers) {
            this.modifiers = (Collection)Preconditions.checkNotNull(modifiers, (Object)"modifiers cannot be NULL - use an empty list instead.");
            return this;
        }

        public Builder packet(PacketContainer packet) {
            if (((PacketContainer)Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be NULL")).getType() != PacketType.Play.Server.UPDATE_ATTRIBUTES) {
                throw new IllegalArgumentException("Packet must be UPDATE_ATTRIBUTES (44)");
            }
            this.packet = packet;
            return this;
        }

        private Set<Object> getUnwrappedModifiers() {
            HashSet output = Sets.newHashSet();
            for (WrappedAttributeModifier modifier : this.modifiers) {
                output.add(modifier.getHandle());
            }
            return output;
        }

        public WrappedAttribute build() {
            Preconditions.checkNotNull((Object)this.packet, (Object)"packet cannot be NULL.");
            Preconditions.checkNotNull((Object)this.attributeKey, (Object)"attributeKey cannot be NULL.");
            if (Double.isNaN(this.baseValue)) {
                throw new IllegalStateException("Base value has not been set.");
            }
            if (ATTRIBUTE_CONSTRUCTOR == null) {
                ATTRIBUTE_CONSTRUCTOR = FuzzyReflection.fromClass(MinecraftReflection.getAttributeSnapshotClass(), true).getConstructor(FuzzyMethodContract.newBuilder().parameterCount(4).parameterDerivedOf(MinecraftReflection.getPacketClass(), 0).parameterExactType(String.class, 1).parameterExactType(Double.TYPE, 2).parameterDerivedOf(Collection.class, 3).build());
                ATTRIBUTE_CONSTRUCTOR.setAccessible(true);
            }
            try {
                Object handle = ATTRIBUTE_CONSTRUCTOR.newInstance(this.packet.getHandle(), this.attributeKey, this.baseValue, this.getUnwrappedModifiers());
                return new WrappedAttribute(handle);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct AttributeSnapshot.", e);
            }
        }
    }
}

