/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.timing.StatisticsStream;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class TimedTracker {
    private Map<PacketType, StatisticsStream> packets = Maps.newHashMap();
    private int observations;

    public long beginTracking() {
        return System.nanoTime();
    }

    public synchronized void endTracking(long trackingToken, PacketType type) {
        StatisticsStream stream = this.packets.get(type);
        if (stream == null) {
            stream = new StatisticsStream();
            this.packets.put(type, stream);
        }
        stream.observe(System.nanoTime() - trackingToken);
        ++this.observations;
    }

    public int getObservations() {
        return this.observations;
    }

    public synchronized Map<PacketType, StatisticsStream> getStatistics() {
        HashMap clone = Maps.newHashMap();
        for (Map.Entry<PacketType, StatisticsStream> entry : this.packets.entrySet()) {
            clone.put(entry.getKey(), new StatisticsStream(entry.getValue()));
        }
        return clone;
    }
}

