/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassExactMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.lang.reflect.Member;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public abstract class AbstractFuzzyMember<T extends Member>
extends AbstractFuzzyMatcher<T> {
    protected int modifiersRequired;
    protected int modifiersBanned;
    protected Pattern nameRegex;
    protected AbstractFuzzyMatcher<Class<?>> declaringMatcher = ClassExactMatcher.MATCH_ALL;
    protected transient boolean sealed;

    protected AbstractFuzzyMember() {
    }

    protected void prepareBuild() {
    }

    protected AbstractFuzzyMember(AbstractFuzzyMember<T> other) {
        this.modifiersRequired = other.modifiersRequired;
        this.modifiersBanned = other.modifiersBanned;
        this.nameRegex = other.nameRegex;
        this.declaringMatcher = other.declaringMatcher;
        this.sealed = true;
    }

    public int getModifiersRequired() {
        return this.modifiersRequired;
    }

    public int getModifiersBanned() {
        return this.modifiersBanned;
    }

    public Pattern getNameRegex() {
        return this.nameRegex;
    }

    public AbstractFuzzyMatcher<Class<?>> getDeclaringMatcher() {
        return this.declaringMatcher;
    }

    @Override
    public boolean isMatch(T value, Object parent) {
        int mods = value.getModifiers();
        return (mods & this.modifiersRequired) == this.modifiersRequired && (mods & this.modifiersBanned) == 0 && this.declaringMatcher.isMatch(value.getDeclaringClass(), value) && this.isNameMatch(value.getName());
    }

    private boolean isNameMatch(String name) {
        if (this.nameRegex == null) {
            return true;
        }
        return this.nameRegex.matcher(name).matches();
    }

    @Override
    protected int calculateRoundNumber() {
        if (!this.sealed) {
            throw new IllegalStateException("Cannot calculate round number during construction.");
        }
        return this.declaringMatcher.getRoundNumber();
    }

    public String toString() {
        return this.getKeyValueView().toString();
    }

    protected Map<String, Object> getKeyValueView() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (this.modifiersRequired != Integer.MAX_VALUE || this.modifiersBanned != 0) {
            map.put("modifiers", String.format("[required: %s, banned: %s]", AbstractFuzzyMember.getBitView(this.modifiersRequired, 16), AbstractFuzzyMember.getBitView(this.modifiersBanned, 16)));
        }
        if (this.nameRegex != null) {
            map.put("name", this.nameRegex.pattern());
        }
        if (this.declaringMatcher != ClassExactMatcher.MATCH_ALL) {
            map.put("declaring", this.declaringMatcher);
        }
        return map;
    }

    private static String getBitView(int value, int bits) {
        if (bits < 0 || bits > 31) {
            throw new IllegalArgumentException("Bits must be a value between 0 and 32");
        }
        int snipped = value & (1 << bits) - 1;
        return Integer.toBinaryString(snipped);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractFuzzyMember) {
            AbstractFuzzyMember other = (AbstractFuzzyMember)obj;
            return this.modifiersBanned == other.modifiersBanned && this.modifiersRequired == other.modifiersRequired && FuzzyMatchers.checkPattern(this.nameRegex, other.nameRegex) && Objects.equal(this.declaringMatcher, other.declaringMatcher);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modifiersBanned, this.modifiersRequired, this.nameRegex != null ? this.nameRegex.pattern() : null, this.declaringMatcher});
    }

    public static abstract class Builder<T extends AbstractFuzzyMember<?>> {
        protected T member = this.initialMember();

        public Builder<T> requireModifier(int modifier) {
            ((AbstractFuzzyMember)this.member).modifiersRequired |= modifier;
            return this;
        }

        public Builder<T> requirePublic() {
            return this.requireModifier(1);
        }

        public Builder<T> banModifier(int modifier) {
            ((AbstractFuzzyMember)this.member).modifiersBanned |= modifier;
            return this;
        }

        public Builder<T> nameRegex(String regex) {
            ((AbstractFuzzyMember)this.member).nameRegex = Pattern.compile(regex);
            return this;
        }

        public Builder<T> nameRegex(Pattern pattern) {
            ((AbstractFuzzyMember)this.member).nameRegex = pattern;
            return this;
        }

        public Builder<T> nameExact(String name) {
            return this.nameRegex(Pattern.quote(name));
        }

        public Builder<T> declaringClassExactType(Class<?> declaringClass) {
            ((AbstractFuzzyMember)this.member).declaringMatcher = FuzzyMatchers.matchExact(declaringClass);
            return this;
        }

        public Builder<T> declaringClassSuperOf(Class<?> declaringClass) {
            ((AbstractFuzzyMember)this.member).declaringMatcher = FuzzyMatchers.matchSuper(declaringClass);
            return this;
        }

        public Builder<T> declaringClassDerivedOf(Class<?> declaringClass) {
            ((AbstractFuzzyMember)this.member).declaringMatcher = FuzzyMatchers.matchDerived(declaringClass);
            return this;
        }

        public Builder<T> declaringClassMatching(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            ((AbstractFuzzyMember)this.member).declaringMatcher = classMatcher;
            return this;
        }

        @Nonnull
        protected abstract T initialMember();

        public abstract T build();
    }
}

