/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class DefaultMethodAccessor
implements MethodAccessor {
    private final Method method;

    public DefaultMethodAccessor(Method method) {
        this.method = method;
    }

    @Override
    public Object invoke(Object target, Object ... args) {
        try {
            return this.method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An internal error occured.", e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMethodAccessor) {
            DefaultMethodAccessor other = (DefaultMethodAccessor)obj;
            return other.method == this.method;
        }
        return true;
    }

    public String toString() {
        return "DefaultMethodAccessor [method=" + this.method + "]";
    }
}

