/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class FuzzyReflection {
    private Class<?> source;
    private boolean forceAccess;

    public FuzzyReflection(Class<?> source, boolean forceAccess) {
        this.source = source;
        this.forceAccess = forceAccess;
    }

    public static FuzzyReflection fromClass(Class<?> source) {
        return FuzzyReflection.fromClass(source, false);
    }

    public static FuzzyReflection fromClass(Class<?> source, boolean forceAccess) {
        return new FuzzyReflection(source, forceAccess);
    }

    public static FuzzyReflection fromObject(Object reference) {
        return new FuzzyReflection(reference.getClass(), false);
    }

    public static FuzzyReflection fromObject(Object reference, boolean forceAccess) {
        return new FuzzyReflection(reference.getClass(), forceAccess);
    }

    public static <T> T getFieldValue(Object instance, Class<T> fieldClass, boolean forceAccess) {
        Object result = Accessors.getFieldAccessor(instance.getClass(), fieldClass, forceAccess).get(instance);
        return (T)result;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public Object getSingleton() {
        Method method = null;
        Field field = null;
        try {
            method = this.getMethod(FuzzyMethodContract.newBuilder().parameterCount(0).returnDerivedOf(this.source).requireModifier(8).build());
        }
        catch (IllegalArgumentException e) {
            field = this.getFieldByType("instance", this.source);
        }
        if (method != null) {
            try {
                method.setAccessible(true);
                return method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke singleton method " + method, e);
            }
        }
        if (field != null) {
            try {
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot get content of singleton field " + field, e);
            }
        }
        throw new IllegalStateException("Impossible.");
    }

    public Method getMethod(AbstractFuzzyMatcher<MethodInfo> matcher) {
        List<Method> result = this.getMethodList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public Method getMethod(AbstractFuzzyMatcher<MethodInfo> matcher, String preferred) {
        List<Method> result = this.getMethodList(matcher);
        if (result.size() > 1) {
            for (Method method : result) {
                if (!method.getName().equals(preferred)) continue;
                return method;
            }
        }
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public List<Method> getMethodList(AbstractFuzzyMatcher<MethodInfo> matcher) {
        ArrayList methods = Lists.newArrayList();
        for (Method method : this.getMethods()) {
            if (!matcher.isMatch(MethodInfo.fromMethod(method), this.source)) continue;
            methods.add(method);
        }
        return methods;
    }

    public Method getMethodByName(String nameRegex) {
        Pattern match = Pattern.compile(nameRegex);
        for (Method method : this.getMethods()) {
            if (!match.matcher(method.getName()).matches()) continue;
            return method;
        }
        throw new IllegalArgumentException("Unable to find a method with the pattern " + nameRegex + " in " + this.source.getName());
    }

    public Method getMethodByParameters(String name, Class<?> ... args) {
        for (Method method : this.getMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), args)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unable to find " + name + " in " + this.source.getName());
    }

    public Method getMethodByParameters(String name, Class<?> returnType, Class<?>[] args) {
        List<Method> methods = this.getMethodListByParameters(returnType, args);
        if (methods.size() > 0) {
            return methods.get(0);
        }
        throw new IllegalArgumentException("Unable to find " + name + " in " + this.source.getName());
    }

    public Method getMethodByParameters(String name, String returnTypeRegex, String[] argsRegex) {
        Pattern match = Pattern.compile(returnTypeRegex);
        Pattern[] argMatch = new Pattern[argsRegex.length];
        for (int i = 0; i < argsRegex.length; ++i) {
            argMatch[i] = Pattern.compile(argsRegex[i]);
        }
        for (Method method : this.getMethods()) {
            if (!match.matcher(method.getReturnType().getName()).matches() || !this.matchParameters(argMatch, method.getParameterTypes())) continue;
            return method;
        }
        throw new IllegalArgumentException("Unable to find " + name + " in " + this.source.getName());
    }

    public Object invokeMethod(Object target, String name, Class<?> returnType, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        return Accessors.getMethodAccessor(this.getMethodByParameters(name, returnType, (Class<?>[])types)).invoke(target, parameters);
    }

    private boolean matchParameters(Pattern[] parameterMatchers, Class<?>[] argTypes) {
        if (parameterMatchers.length != argTypes.length) {
            throw new IllegalArgumentException("Arrays must have the same cardinality.");
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (parameterMatchers[i].matcher(argTypes[i].getName()).matches()) continue;
            return false;
        }
        return true;
    }

    public List<Method> getMethodListByParameters(Class<?> returnType, Class<?>[] args) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.getMethods()) {
            if (!method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), args)) continue;
            methods.add(method);
        }
        return methods;
    }

    public Field getFieldByName(String nameRegex) {
        Pattern match = Pattern.compile(nameRegex);
        for (Field field : this.getFields()) {
            if (!match.matcher(field.getName()).matches()) continue;
            return field;
        }
        throw new IllegalArgumentException("Unable to find a field with the pattern " + nameRegex + " in " + this.source.getName());
    }

    public Field getFieldByType(String name, Class<?> type) {
        List<Field> fields = this.getFieldListByType(type);
        if (fields.size() > 0) {
            return fields.get(0);
        }
        throw new IllegalArgumentException(String.format("Unable to find a field %s with the type %s in %s", name, type.getName(), this.source.getName()));
    }

    public List<Field> getFieldListByType(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    public Field getParameterizedField(Class<?> fieldType, Class<?> ... params) {
        for (Field field : this.getFields()) {
            Type type;
            if (!field.getType().equals(fieldType) || !((type = field.getGenericType()) instanceof ParameterizedType) || !Arrays.equals(((ParameterizedType)type).getActualTypeArguments(), params)) continue;
            return field;
        }
        throw new IllegalArgumentException("Unable to find a field with type " + fieldType + " and params " + Arrays.toString(params));
    }

    public Field getField(AbstractFuzzyMatcher<Field> matcher) {
        List<Field> result = this.getFieldList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a field that matches " + matcher);
    }

    public List<Field> getFieldList(AbstractFuzzyMatcher<Field> matcher) {
        ArrayList fields = Lists.newArrayList();
        for (Field field : this.getFields()) {
            if (!matcher.isMatch(field, this.source)) continue;
            fields.add(field);
        }
        return fields;
    }

    public Field getFieldByType(String typeRegex) {
        Pattern match = Pattern.compile(typeRegex);
        for (Field field : this.getFields()) {
            String name = field.getType().getName();
            if (!match.matcher(name).matches()) continue;
            return field;
        }
        throw new IllegalArgumentException("Unable to find a field with the type " + typeRegex + " in " + this.source.getName());
    }

    public Field getFieldByType(String typeRegex, Set<Class> ignored) {
        Pattern match = Pattern.compile(typeRegex);
        for (Field field : this.getFields()) {
            Class<?> type = field.getType();
            if (ignored.contains(type) || !match.matcher(type.getName()).matches()) continue;
            return field;
        }
        throw new IllegalArgumentException("Unable to find a field with the type " + typeRegex + " in " + this.source.getName());
    }

    public Constructor<?> getConstructor(AbstractFuzzyMatcher<MethodInfo> matcher) {
        List<Constructor<?>> result = this.getConstructorList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public Map<String, Method> getMappedMethods(List<Method> methods) {
        HashMap map = Maps.newHashMap();
        for (Method method : methods) {
            map.put(method.getName(), method);
        }
        return map;
    }

    public List<Constructor<?>> getConstructorList(AbstractFuzzyMatcher<MethodInfo> matcher) {
        ArrayList constructors = Lists.newArrayList();
        for (Constructor<?> constructor : this.getConstructors()) {
            if (!matcher.isMatch(MethodInfo.fromConstructor(constructor), this.source)) continue;
            constructors.add(constructor);
        }
        return constructors;
    }

    public Set<Field> getFields() {
        Validate.notNull(this.source, (String)"source cannot be null!");
        if (this.forceAccess) {
            return FuzzyReflection.setUnion(this.source.getDeclaredFields(), this.source.getFields());
        }
        return FuzzyReflection.setUnion(new Field[][]{this.source.getFields()});
    }

    public Set<Field> getDeclaredFields(Class<?> excludeClass) {
        if (this.forceAccess) {
            LinkedHashSet fields = Sets.newLinkedHashSet();
            for (Class<?> current = this.source; current != null && current != excludeClass; current = current.getSuperclass()) {
                fields.addAll(Arrays.asList(current.getDeclaredFields()));
            }
            return fields;
        }
        return this.getFields();
    }

    public Set<Method> getMethods() {
        if (this.forceAccess) {
            return FuzzyReflection.setUnion(this.source.getDeclaredMethods(), this.source.getMethods());
        }
        return FuzzyReflection.setUnion(new Method[][]{this.source.getMethods()});
    }

    public Set<Constructor<?>> getConstructors() {
        if (this.forceAccess) {
            return FuzzyReflection.setUnion(new Constructor[][]{this.source.getDeclaredConstructors()});
        }
        return FuzzyReflection.setUnion(new Constructor[][]{this.source.getConstructors()});
    }

    @SafeVarargs
    private static <T> Set<T> setUnion(T[] ... array) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        T[][] TArray = array;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] elements;
            for (T element : elements = TArray[i]) {
                result.add(element);
            }
        }
        return result;
    }

    public boolean isForceAccess() {
        return this.forceAccess;
    }

    public void setForceAccess(boolean forceAccess) {
        this.forceAccess = forceAccess;
    }
}

