/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BukkitUnwrapper
implements PacketConstructor.Unwrapper {
    private static BukkitUnwrapper DEFAULT;
    public static final ReportType REPORT_ILLEGAL_ARGUMENT;
    public static final ReportType REPORT_SECURITY_LIMITATION;
    public static final ReportType REPORT_CANNOT_FIND_UNWRAP_METHOD;
    public static final ReportType REPORT_CANNOT_READ_FIELD_HANDLE;
    private static Map<Class<?>, PacketConstructor.Unwrapper> unwrapperCache;
    private final ErrorReporter reporter;

    public static BukkitUnwrapper getInstance() {
        ErrorReporter currentReporter = ProtocolLibrary.getErrorReporter();
        if (DEFAULT == null || BukkitUnwrapper.DEFAULT.reporter != currentReporter) {
            DEFAULT = new BukkitUnwrapper(currentReporter);
        }
        return DEFAULT;
    }

    public BukkitUnwrapper() {
        this(ProtocolLibrary.getErrorReporter());
    }

    public BukkitUnwrapper(ErrorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public Object unwrapItem(Object wrappedObject) {
        if (wrappedObject == null) {
            return null;
        }
        Class<?> currentClass = PacketConstructor.getClass(wrappedObject);
        if (currentClass.isPrimitive() || currentClass.equals(String.class)) {
            return null;
        }
        if (wrappedObject instanceof Collection) {
            return this.handleCollection((Collection)wrappedObject);
        }
        if (Primitives.isWrapperType(currentClass) || wrappedObject instanceof String) {
            return null;
        }
        PacketConstructor.Unwrapper specificUnwrapper = this.getSpecificUnwrapper(currentClass);
        if (specificUnwrapper != null) {
            return specificUnwrapper.unwrapItem(wrappedObject);
        }
        return null;
    }

    private Object handleCollection(Collection<Object> wrappedObject) {
        Collection copy = (Collection)DefaultInstances.DEFAULT.getDefault(wrappedObject.getClass());
        if (copy != null) {
            for (Object element : wrappedObject) {
                copy.add(this.unwrapItem(element));
            }
            return copy;
        }
        return null;
    }

    private PacketConstructor.Unwrapper getSpecificUnwrapper(final Class<?> type) {
        if (unwrapperCache.containsKey(type)) {
            return unwrapperCache.get(type);
        }
        try {
            final Method find = type.getMethod("getHandle", new Class[0]);
            PacketConstructor.Unwrapper methodUnwrapper = new PacketConstructor.Unwrapper(){

                @Override
                public Object unwrapItem(Object wrappedObject) {
                    try {
                        if (wrappedObject instanceof Class) {
                            return BukkitUnwrapper.checkClass((Class)wrappedObject, type, find.getReturnType());
                        }
                        return find.invoke(wrappedObject, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        BukkitUnwrapper.this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_ILLEGAL_ARGUMENT).error(e).callerParam(wrappedObject, find));
                    }
                    catch (IllegalAccessException e) {
                        return null;
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Minecraft error.", e);
                    }
                    return null;
                }
            };
            unwrapperCache.put(type, methodUnwrapper);
            return methodUnwrapper;
        }
        catch (SecurityException e) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_SECURITY_LIMITATION).error(e).callerParam(type));
        }
        catch (NoSuchMethodException e) {
            PacketConstructor.Unwrapper proxyUnwrapper = this.getProxyUnwrapper(type);
            if (proxyUnwrapper != null) {
                return proxyUnwrapper;
            }
            PacketConstructor.Unwrapper fieldUnwrapper = this.getFieldUnwrapper(type);
            if (fieldUnwrapper != null) {
                return fieldUnwrapper;
            }
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_FIND_UNWRAP_METHOD).error(e).callerParam(type));
        }
        return null;
    }

    private PacketConstructor.Unwrapper getProxyUnwrapper(Class<?> type) {
        try {
            if (Player.class.isAssignableFrom(type)) {
                final Method getHandle = MinecraftReflection.getCraftPlayerClass().getMethod("getHandle", new Class[0]);
                PacketConstructor.Unwrapper unwrapper = new PacketConstructor.Unwrapper(){

                    @Override
                    public Object unwrapItem(Object wrapped) {
                        try {
                            return getHandle.invoke((Object)((Player)wrapped).getPlayer(), new Object[0]);
                        }
                        catch (Throwable ex) {
                            try {
                                return getHandle.invoke((Object)Bukkit.getPlayer((UUID)((Player)wrapped).getUniqueId()), new Object[0]);
                            }
                            catch (ReflectiveOperationException ex1) {
                                throw new RuntimeException("Failed to unwrap proxy " + wrapped, ex);
                            }
                        }
                    }
                };
                unwrapperCache.put(type, unwrapper);
                return unwrapper;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private PacketConstructor.Unwrapper getFieldUnwrapper(final Class<?> type) {
        final Field find = FieldUtils.getField(type, "handle", true);
        if (find != null) {
            PacketConstructor.Unwrapper fieldUnwrapper = new PacketConstructor.Unwrapper(){

                @Override
                public Object unwrapItem(Object wrappedObject) {
                    try {
                        if (wrappedObject instanceof Class) {
                            return BukkitUnwrapper.checkClass((Class)wrappedObject, type, find.getType());
                        }
                        return FieldUtils.readField(find, wrappedObject, true);
                    }
                    catch (IllegalAccessException e) {
                        BukkitUnwrapper.this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_READ_FIELD_HANDLE).error(e).callerParam(wrappedObject, find));
                        return null;
                    }
                }
            };
            unwrapperCache.put(type, fieldUnwrapper);
            return fieldUnwrapper;
        }
        this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_READ_FIELD_HANDLE).callerParam(find));
        return null;
    }

    private static Class<?> checkClass(Class<?> input, Class<?> expected, Class<?> result) {
        if (expected.isAssignableFrom(input)) {
            return result;
        }
        return null;
    }

    static {
        REPORT_ILLEGAL_ARGUMENT = new ReportType("Illegal argument.");
        REPORT_SECURITY_LIMITATION = new ReportType("Security limitation.");
        REPORT_CANNOT_FIND_UNWRAP_METHOD = new ReportType("Cannot find method.");
        REPORT_CANNOT_READ_FIELD_HANDLE = new ReportType("Cannot read field 'handle'.");
        unwrapperCache = new ConcurrentHashMap();
    }
}

