/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.collections.IntegerMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PacketTypeLookup {
    private final IntegerMap<PacketType> legacyLookup = new IntegerMap();
    private final IntegerMap<PacketType> serverLookup = new IntegerMap();
    private final IntegerMap<PacketType> clientLookup = new IntegerMap();
    private final ProtocolSenderLookup idLookup = new ProtocolSenderLookup();
    private final ClassLookup classLookup = new ClassLookup();
    private final Multimap<String, PacketType> nameLookup = HashMultimap.create();

    PacketTypeLookup() {
    }

    public PacketTypeLookup addPacketTypes(Iterable<? extends PacketType> types) {
        Preconditions.checkNotNull(types, (Object)"types cannot be NULL");
        for (PacketType packetType : types) {
            int legacy = packetType.getLegacyId();
            if (legacy != -1) {
                if (packetType.isServer()) {
                    this.serverLookup.put(packetType.getLegacyId(), packetType);
                }
                if (packetType.isClient()) {
                    this.clientLookup.put(packetType.getLegacyId(), packetType);
                }
                this.legacyLookup.put(packetType.getLegacyId(), packetType);
            }
            if (packetType.getCurrentId() != -1) {
                this.idLookup.getMap(packetType.getProtocol(), packetType.getSender()).put(packetType.getCurrentId(), packetType);
                this.classLookup.getMap(packetType.getProtocol(), packetType.getSender()).put(packetType.getClassNames()[0], packetType);
            }
            this.nameLookup.put((Object)packetType.name(), (Object)packetType);
        }
        return this;
    }

    public PacketType getFromLegacy(int packetId) {
        return this.legacyLookup.get(packetId);
    }

    public Collection<PacketType> getFromName(String name) {
        return Collections.unmodifiableCollection(this.nameLookup.get((Object)name));
    }

    public PacketType getFromLegacy(int packetId, PacketType.Sender preference) {
        if (preference == PacketType.Sender.CLIENT) {
            return this.getFirst(packetId, this.clientLookup, this.serverLookup);
        }
        return this.getFirst(packetId, this.serverLookup, this.clientLookup);
    }

    private <T> T getFirst(int packetId, IntegerMap<T> first, IntegerMap<T> second) {
        if (first.containsKey(packetId)) {
            return first.get(packetId);
        }
        return second.get(packetId);
    }

    @Deprecated
    public PacketType getFromCurrent(PacketType.Protocol protocol, PacketType.Sender sender, int packetId) {
        return this.idLookup.getMap(protocol, sender).get(packetId);
    }

    public PacketType getFromCurrent(PacketType.Protocol protocol, PacketType.Sender sender, String name) {
        return this.classLookup.getMap(protocol, sender).get(name);
    }

    public ClassLookup getClassLookup() {
        return this.classLookup;
    }

    public static class ClassLookup {
        public final Map<String, PacketType> HANDSHAKE_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> HANDSHAKE_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> GAME_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> GAME_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> STATUS_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> STATUS_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> LOGIN_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> LOGIN_SERVER = new ConcurrentHashMap<String, PacketType>();

        public Map<String, PacketType> getMap(PacketType.Protocol protocol, PacketType.Sender sender) {
            switch (protocol) {
                case HANDSHAKING: {
                    return sender == PacketType.Sender.CLIENT ? this.HANDSHAKE_CLIENT : this.HANDSHAKE_SERVER;
                }
                case PLAY: {
                    return sender == PacketType.Sender.CLIENT ? this.GAME_CLIENT : this.GAME_SERVER;
                }
                case STATUS: {
                    return sender == PacketType.Sender.CLIENT ? this.STATUS_CLIENT : this.STATUS_SERVER;
                }
                case LOGIN: {
                    return sender == PacketType.Sender.CLIENT ? this.LOGIN_CLIENT : this.LOGIN_SERVER;
                }
            }
            throw new IllegalArgumentException("Unable to find protocol " + (Object)((Object)protocol));
        }
    }

    public static class ProtocolSenderLookup {
        public final IntegerMap<PacketType> HANDSHAKE_CLIENT = IntegerMap.newMap();
        public final IntegerMap<PacketType> HANDSHAKE_SERVER = IntegerMap.newMap();
        public final IntegerMap<PacketType> GAME_CLIENT = IntegerMap.newMap();
        public final IntegerMap<PacketType> GAME_SERVER = IntegerMap.newMap();
        public final IntegerMap<PacketType> STATUS_CLIENT = IntegerMap.newMap();
        public final IntegerMap<PacketType> STATUS_SERVER = IntegerMap.newMap();
        public final IntegerMap<PacketType> LOGIN_CLIENT = IntegerMap.newMap();
        public final IntegerMap<PacketType> LOGIN_SERVER = IntegerMap.newMap();

        public IntegerMap<PacketType> getMap(PacketType.Protocol protocol, PacketType.Sender sender) {
            switch (protocol) {
                case HANDSHAKING: {
                    return sender == PacketType.Sender.CLIENT ? this.HANDSHAKE_CLIENT : this.HANDSHAKE_SERVER;
                }
                case PLAY: {
                    return sender == PacketType.Sender.CLIENT ? this.GAME_CLIENT : this.GAME_SERVER;
                }
                case STATUS: {
                    return sender == PacketType.Sender.CLIENT ? this.STATUS_CLIENT : this.STATUS_SERVER;
                }
                case LOGIN: {
                    return sender == PacketType.Sender.CLIENT ? this.LOGIN_CLIENT : this.LOGIN_SERVER;
                }
            }
            throw new IllegalArgumentException("Unable to find protocol " + (Object)((Object)protocol));
        }
    }
}

