/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.ReadOnlyFieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.comphenix.protocol.utility.ClassSource;
import com.google.common.base.Function;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class TroveWrapper {
    private static final String[] TROVE_LOCATIONS = new String[]{"net.minecraft.util.gnu.trove", "gnu.trove"};
    private static final ClassSource[] TROVE_SOURCES = new ClassSource[]{ClassSource.fromPackage(TROVE_LOCATIONS[0]), ClassSource.fromPackage(TROVE_LOCATIONS[1])};

    public static ReadOnlyFieldAccessor wrapMapField(FieldAccessor accessor) {
        return TroveWrapper.wrapMapField(accessor, null);
    }

    public static ReadOnlyFieldAccessor wrapMapField(final FieldAccessor accessor, final Function<Integer, Integer> noEntryTransform) {
        return new ReadOnlyFieldAccessor(){

            @Override
            public Object get(Object instance) {
                Object troveMap = accessor.get(instance);
                if (noEntryTransform != null) {
                    TroveWrapper.transformNoEntryValue(troveMap, (Function<Integer, Integer>)noEntryTransform);
                }
                return TroveWrapper.getDecoratedMap(troveMap);
            }

            @Override
            public Field getField() {
                return accessor.getField();
            }
        };
    }

    public static ReadOnlyFieldAccessor wrapSetField(final FieldAccessor accessor) {
        return new ReadOnlyFieldAccessor(){

            @Override
            public Object get(Object instance) {
                return TroveWrapper.getDecoratedSet(accessor.get(instance));
            }

            @Override
            public Field getField() {
                return accessor.getField();
            }
        };
    }

    public static ReadOnlyFieldAccessor wrapListField(final FieldAccessor accessor) {
        return new ReadOnlyFieldAccessor(){

            @Override
            public Object get(Object instance) {
                return TroveWrapper.getDecoratedList(accessor.get(instance));
            }

            @Override
            public Field getField() {
                return accessor.getField();
            }
        };
    }

    public static <TKey, TValue> Map<TKey, TValue> getDecoratedMap(@Nonnull Object troveMap) {
        Map result = (Map)TroveWrapper.getDecorated(troveMap);
        return result;
    }

    public static <TValue> Set<TValue> getDecoratedSet(@Nonnull Object troveSet) {
        Set result = (Set)TroveWrapper.getDecorated(troveSet);
        return result;
    }

    public static <TValue> List<TValue> getDecoratedList(@Nonnull Object troveList) {
        List result = (List)TroveWrapper.getDecorated(troveList);
        return result;
    }

    public static boolean isTroveClass(Class<?> clazz) {
        return TroveWrapper.getClassSource(clazz) != null;
    }

    public static void transformNoEntryValue(Object troveMap, Function<Integer, Integer> transform) {
        try {
            Field field = FieldUtils.getField(troveMap.getClass(), "no_entry_value", true);
            int current = (Integer)FieldUtils.readField(field, troveMap, true);
            int transformed = (Integer)transform.apply((Object)current);
            if (current != transformed) {
                FieldUtils.writeField(field, troveMap, (Object)transformed);
            }
        }
        catch (IllegalArgumentException e) {
            throw new CannotFindTroveNoEntryValue(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access reflection.", e);
        }
    }

    private static ClassSource getClassSource(Class<?> clazz) {
        for (int i = 0; i < TROVE_LOCATIONS.length; ++i) {
            if (!clazz.getCanonicalName().startsWith(TROVE_LOCATIONS[i])) continue;
            return TROVE_SOURCES[i];
        }
        return null;
    }

    private static Object getDecorated(@Nonnull Object trove) {
        if (trove == null) {
            throw new IllegalArgumentException("trove instance cannot be non-null.");
        }
        AbstractFuzzyMatcher<Class<?>> match = FuzzyMatchers.matchSuper(trove.getClass());
        Class<?> decorators = null;
        try {
            decorators = TroveWrapper.getClassSource(trove.getClass()).loadClass("TDecorators");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        for (Method method : decorators.getMethods()) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1 || !match.isMatch(types[0], null)) continue;
            try {
                Object result = method.invoke(null, trove);
                if (result == null) {
                    throw new FieldAccessException("Wrapper returned NULL.");
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                throw new FieldAccessException("Cannot invoke wrapper method.", e);
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException("Illegal access.", e);
            }
            catch (InvocationTargetException e) {
                throw new FieldAccessException("Error in invocation.", e);
            }
        }
        throw new IllegalArgumentException("Cannot find decorator for " + trove + " (" + trove.getClass() + ")");
    }

    public static class CannotFindTroveNoEntryValue
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CannotFindTroveNoEntryValue(Throwable inner) {
            super("Cannot correct trove map.", inner);
        }
    }
}

