/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.injector.PlayerInjectHooks;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ProtocolConfig {
    private static final String LAST_UPDATE_FILE = "lastupdate";
    private static final String SECTION_GLOBAL = "global";
    private static final String SECTION_AUTOUPDATER = "auto updater";
    private static final String METRICS_ENABLED = "metrics";
    private static final String IGNORE_VERSION_CHECK = "ignore version check";
    private static final String BACKGROUND_COMPILER_ENABLED = "background compiler";
    private static final String DEBUG_MODE_ENABLED = "debug";
    private static final String DETAILED_ERROR = "detailed error";
    private static final String INJECTION_METHOD = "injection method";
    private static final String SCRIPT_ENGINE_NAME = "script engine";
    private static final String SUPPRESSED_REPORTS = "suppressed reports";
    private static final String UPDATER_NOTIFY = "notify";
    private static final String UPDATER_DOWNLAD = "download";
    private static final String UPDATER_DELAY = "delay";
    private static final long DEFAULT_UPDATER_DELAY = 43200L;
    private Plugin plugin;
    private Configuration config;
    private boolean loadingSections;
    private ConfigurationSection global;
    private ConfigurationSection updater;
    private long lastUpdateTime;
    private boolean configChanged;
    private boolean valuesChanged;
    private int modCount;

    public ProtocolConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.configChanged = false;
        this.valuesChanged = false;
        ++this.modCount;
        this.config = this.plugin.getConfig();
        this.lastUpdateTime = this.loadLastUpdate();
        this.loadSections(!this.loadingSections);
    }

    private long loadLastUpdate() {
        File dataFile = this.getLastUpdateFile();
        if (dataFile.exists()) {
            try {
                return Long.parseLong(Files.toString((File)dataFile, (Charset)Charsets.UTF_8));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Cannot parse " + dataFile + " as a number.");
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Cannot read " + dataFile);
            }
        }
        return 0L;
    }

    private void saveLastUpdate(long value) {
        File dataFile = this.getLastUpdateFile();
        dataFile.getParentFile().mkdirs();
        if (dataFile.exists()) {
            dataFile.delete();
        }
        try {
            Files.write((CharSequence)Long.toString(value), (File)dataFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write " + dataFile, e);
        }
    }

    private File getLastUpdateFile() {
        return new File(this.plugin.getDataFolder(), LAST_UPDATE_FILE);
    }

    private void loadSections(boolean copyDefaults) {
        if (this.config != null) {
            this.global = this.config.getConfigurationSection(SECTION_GLOBAL);
        }
        if (this.global != null) {
            this.updater = this.global.getConfigurationSection(SECTION_AUTOUPDATER);
            if (this.updater.getValues(true).isEmpty()) {
                this.plugin.getLogger().warning("Updater section is missing, regenerate your config!");
            }
        }
        if (copyDefaults && (!this.getFile().exists() || this.global == null || this.updater == null)) {
            this.loadingSections = true;
            if (this.config != null) {
                this.config.options().copyDefaults(true);
            }
            this.plugin.saveDefaultConfig();
            this.plugin.reloadConfig();
            this.loadingSections = false;
            this.plugin.getLogger().info("Created default configuration.");
        }
    }

    private void setConfig(ConfigurationSection section, String path, Object value) {
        this.configChanged = true;
        section.set(path, value);
    }

    private <T> T getGlobalValue(String path, T def) {
        try {
            return (T)this.global.get(path, def);
        }
        catch (Throwable ex) {
            return def;
        }
    }

    private <T> T getUpdaterValue(String path, T def) {
        try {
            return (T)this.updater.get(path, def);
        }
        catch (Throwable ex) {
            return def;
        }
    }

    public File getFile() {
        return new File(this.plugin.getDataFolder(), "config.yml");
    }

    public boolean isDetailedErrorReporting() {
        return this.getGlobalValue(DETAILED_ERROR, false);
    }

    public void setDetailedErrorReporting(boolean value) {
        this.global.set(DETAILED_ERROR, (Object)value);
    }

    public boolean isAutoNotify() {
        return this.getUpdaterValue(UPDATER_NOTIFY, true);
    }

    public void setAutoNotify(boolean value) {
        this.setConfig(this.updater, UPDATER_NOTIFY, value);
        ++this.modCount;
    }

    public boolean isAutoDownload() {
        return this.updater != null && this.getUpdaterValue(UPDATER_DOWNLAD, false) != false;
    }

    public void setAutoDownload(boolean value) {
        this.setConfig(this.updater, UPDATER_DOWNLAD, value);
        ++this.modCount;
    }

    public boolean isDebug() {
        return this.getGlobalValue(DEBUG_MODE_ENABLED, false);
    }

    public void setDebug(boolean value) {
        this.setConfig(this.global, DEBUG_MODE_ENABLED, value);
        ++this.modCount;
    }

    public ImmutableList<String> getSuppressedReports() {
        return ImmutableList.copyOf((Collection)this.getGlobalValue(SUPPRESSED_REPORTS, new ArrayList()));
    }

    public void setSuppressedReports(List<String> reports) {
        this.global.set(SUPPRESSED_REPORTS, (Object)Lists.newArrayList(reports));
        ++this.modCount;
    }

    public long getAutoDelay() {
        return Math.max((long)this.getUpdaterValue(UPDATER_DELAY, 0).intValue(), 43200L);
    }

    public void setAutoDelay(long delaySeconds) {
        if (delaySeconds < 43200L) {
            delaySeconds = 43200L;
        }
        this.setConfig(this.updater, UPDATER_DELAY, delaySeconds);
        ++this.modCount;
    }

    public String getIgnoreVersionCheck() {
        return this.getGlobalValue(IGNORE_VERSION_CHECK, "");
    }

    public void setIgnoreVersionCheck(String ignoreVersion) {
        this.setConfig(this.global, IGNORE_VERSION_CHECK, ignoreVersion);
        ++this.modCount;
    }

    public boolean isMetricsEnabled() {
        return this.getGlobalValue(METRICS_ENABLED, true);
    }

    public void setMetricsEnabled(boolean enabled) {
        this.setConfig(this.global, METRICS_ENABLED, enabled);
        ++this.modCount;
    }

    public boolean isBackgroundCompilerEnabled() {
        return this.getGlobalValue(BACKGROUND_COMPILER_ENABLED, true);
    }

    public void setBackgroundCompilerEnabled(boolean enabled) {
        this.setConfig(this.global, BACKGROUND_COMPILER_ENABLED, enabled);
        ++this.modCount;
    }

    public long getAutoLastTime() {
        return this.lastUpdateTime;
    }

    public void setAutoLastTime(long lastTimeSeconds) {
        this.valuesChanged = true;
        this.lastUpdateTime = lastTimeSeconds;
    }

    public String getScriptEngineName() {
        return this.getGlobalValue(SCRIPT_ENGINE_NAME, "JavaScript");
    }

    public void setScriptEngineName(String name) {
        this.setConfig(this.global, SCRIPT_ENGINE_NAME, name);
        ++this.modCount;
    }

    public PlayerInjectHooks getDefaultMethod() {
        return PlayerInjectHooks.NETWORK_SERVER_OBJECT;
    }

    public PlayerInjectHooks getInjectionMethod() throws IllegalArgumentException {
        String text = this.global.getString(INJECTION_METHOD);
        PlayerInjectHooks hook = this.getDefaultMethod();
        if (text != null) {
            hook = PlayerInjectHooks.valueOf(text.toUpperCase(Locale.ENGLISH).replace(" ", "_"));
        }
        return hook;
    }

    public void setInjectionMethod(PlayerInjectHooks hook) {
        this.setConfig(this.global, INJECTION_METHOD, hook.name());
        ++this.modCount;
    }

    public int getModificationCount() {
        return this.modCount;
    }

    public void saveAll() {
        if (this.valuesChanged) {
            this.saveLastUpdate(this.lastUpdateTime);
        }
        if (this.configChanged) {
            this.plugin.saveConfig();
        }
        this.valuesChanged = false;
        this.configChanged = false;
    }
}

