/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.ComponentParser;
import com.google.common.base.Preconditions;
import java.io.StringReader;

public class WrappedChatComponent
extends AbstractWrapper {
    private static final Class<?> SERIALIZER = MinecraftReflection.getChatSerializerClass();
    private static final Class<?> COMPONENT = MinecraftReflection.getIChatBaseComponentClass();
    private static final Class<?> GSON_CLASS = MinecraftReflection.getMinecraftGsonClass();
    private static Object GSON = null;
    private static MethodAccessor DESERIALIZE = null;
    private static MethodAccessor SERIALIZE_COMPONENT = null;
    private static MethodAccessor CONSTRUCT_COMPONENT = null;
    private static ConstructorAccessor CONSTRUCT_TEXT_COMPONENT = null;
    private transient String cache;

    private static Object deserialize(String json) {
        if (DESERIALIZE != null) {
            return DESERIALIZE.invoke(null, GSON, json, COMPONENT, true);
        }
        StringReader str = new StringReader(json);
        return ComponentParser.deserialize(GSON, COMPONENT, str);
    }

    private WrappedChatComponent(Object handle, String cache) {
        super(MinecraftReflection.getIChatBaseComponentClass());
        this.setHandle(handle);
        this.cache = cache;
    }

    public static WrappedChatComponent fromHandle(Object handle) {
        return new WrappedChatComponent(handle, null);
    }

    public static WrappedChatComponent fromJson(String json) {
        return new WrappedChatComponent(WrappedChatComponent.deserialize(json), json);
    }

    public static WrappedChatComponent fromText(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"text cannot be NULL.");
        return WrappedChatComponent.fromHandle(CONSTRUCT_TEXT_COMPONENT.invoke(text));
    }

    public static WrappedChatComponent[] fromChatMessage(String message) {
        Object[] components = (Object[])CONSTRUCT_COMPONENT.invoke(null, message);
        WrappedChatComponent[] result = new WrappedChatComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            result[i] = WrappedChatComponent.fromHandle(components[i]);
        }
        return result;
    }

    public String getJson() {
        if (this.cache == null) {
            this.cache = (String)SERIALIZE_COMPONENT.invoke(null, this.handle);
        }
        return this.cache;
    }

    public void setJson(String obj) {
        this.handle = WrappedChatComponent.deserialize(obj);
        this.cache = obj;
    }

    public WrappedChatComponent deepClone() {
        return WrappedChatComponent.fromJson(this.getJson());
    }

    @Override
    public String toString() {
        return "WrappedChatComponent[json=" + this.getJson() + "]";
    }

    static {
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(SERIALIZER, true);
        SERIALIZE_COMPONENT = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("serialize", (Class<?>)String.class, (Class<?>[])new Class[]{COMPONENT}));
        try {
            GSON = FieldUtils.readStaticField(fuzzy.getFieldByType("gson", GSON_CLASS), true);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Failed to obtain GSON field", ex);
        }
        try {
            DESERIALIZE = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getMinecraftClass("ChatDeserializer"), true).getMethodByParameters("deserialize", (Class<?>)Object.class, (Class<?>[])new Class[]{GSON_CLASS, String.class, Class.class, Boolean.TYPE}));
        }
        catch (IllegalArgumentException ex) {
            DESERIALIZE = null;
        }
        CONSTRUCT_COMPONENT = Accessors.getMethodAccessor(MinecraftReflection.getCraftChatMessage(), "fromString", String.class);
        CONSTRUCT_TEXT_COMPONENT = Accessors.getConstructorAccessor(MinecraftReflection.getChatComponentTextClass(), String.class);
    }
}

