/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMember;
import com.comphenix.protocol.reflect.fuzzy.ClassExactMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FuzzyFieldContract
extends AbstractFuzzyMember<Field> {
    private AbstractFuzzyMatcher<Class<?>> typeMatcher = ClassExactMatcher.MATCH_ALL;

    public static FuzzyFieldContract matchType(AbstractFuzzyMatcher<Class<?>> matcher) {
        return FuzzyFieldContract.newBuilder().typeMatches(matcher).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private FuzzyFieldContract() {
    }

    public AbstractFuzzyMatcher<Class<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    private FuzzyFieldContract(FuzzyFieldContract other) {
        super(other);
        this.typeMatcher = other.typeMatcher;
    }

    @Override
    public boolean isMatch(Field value, Object parent) {
        if (super.isMatch(value, parent)) {
            return this.typeMatcher.isMatch(value.getType(), value);
        }
        return false;
    }

    @Override
    protected int calculateRoundNumber() {
        return this.combineRounds(super.calculateRoundNumber(), this.typeMatcher.calculateRoundNumber());
    }

    @Override
    protected Map<String, Object> getKeyValueView() {
        Map<String, Object> member = super.getKeyValueView();
        if (this.typeMatcher != ClassExactMatcher.MATCH_ALL) {
            member.put("type", this.typeMatcher);
        }
        return member;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeMatcher, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FuzzyFieldContract && super.equals(obj)) {
            return Objects.equal(this.typeMatcher, ((FuzzyFieldContract)obj).typeMatcher);
        }
        return true;
    }

    public static class Builder
    extends AbstractFuzzyMember.Builder<FuzzyFieldContract> {
        public Builder requireModifier(int modifier) {
            super.requireModifier(modifier);
            return this;
        }

        public Builder banModifier(int modifier) {
            super.banModifier(modifier);
            return this;
        }

        public Builder requirePublic() {
            super.requirePublic();
            return this;
        }

        public Builder nameRegex(String regex) {
            super.nameRegex(regex);
            return this;
        }

        public Builder nameRegex(Pattern pattern) {
            super.nameRegex(pattern);
            return this;
        }

        public Builder nameExact(String name) {
            super.nameExact(name);
            return this;
        }

        public Builder declaringClassExactType(Class<?> declaringClass) {
            super.declaringClassExactType(declaringClass);
            return this;
        }

        public Builder declaringClassSuperOf(Class<?> declaringClass) {
            super.declaringClassSuperOf(declaringClass);
            return this;
        }

        public Builder declaringClassDerivedOf(Class<?> declaringClass) {
            super.declaringClassDerivedOf(declaringClass);
            return this;
        }

        public Builder declaringClassMatching(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            super.declaringClassMatching(classMatcher);
            return this;
        }

        @Override
        @Nonnull
        protected FuzzyFieldContract initialMember() {
            return new FuzzyFieldContract();
        }

        public Builder typeExact(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchExact(type);
            return this;
        }

        public Builder typeSuperOf(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchSuper(type);
            return this;
        }

        public Builder typeDerivedOf(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchDerived(type);
            return this;
        }

        public Builder typeMatches(AbstractFuzzyMatcher<Class<?>> matcher) {
            ((FuzzyFieldContract)this.member).typeMatcher = matcher;
            return this;
        }

        @Override
        public FuzzyFieldContract build() {
            ((FuzzyFieldContract)this.member).prepareBuild();
            return new FuzzyFieldContract((FuzzyFieldContract)this.member);
        }
    }
}

