/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.ObjectWriter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.cloning.AggregateCloner;
import com.comphenix.protocol.reflect.cloning.BukkitCloner;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.CollectionCloner;
import com.comphenix.protocol.reflect.cloning.FieldCloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.OptionalCloner;
import com.comphenix.protocol.reflect.cloning.SerializableCloner;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MultiBlockChangeInfo;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PacketContainer
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected PacketType type;
    protected transient Object handle;
    protected transient StructureModifier<Object> structureModifier;
    private static ConcurrentMap<Class<?>, Method> writeMethods = Maps.newConcurrentMap();
    private static ConcurrentMap<Class<?>, Method> readMethods = Maps.newConcurrentMap();
    private static final AggregateCloner DEEP_CLONER = AggregateCloner.newBuilder().instanceProvider(DefaultInstances.DEFAULT).andThen(BukkitCloner.class).andThen(ImmutableDetector.class).andThen(OptionalCloner.class).andThen(CollectionCloner.class).andThen(PacketContainer.getSpecializedDeepClonerFactory()).build();
    private static final AggregateCloner SHALLOW_CLONER = AggregateCloner.newBuilder().instanceProvider(DefaultInstances.DEFAULT).andThen(new Function<AggregateCloner.BuilderParameters, Cloner>(){

        public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
            if (param == null) {
                throw new IllegalArgumentException("Cannot be NULL.");
            }
            return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                {
                    super(defaultCloner, instanceProvider);
                    this.writer = new ObjectWriter();
                }
            };
        }
    }).build();
    private static final Set<PacketType> CLONING_UNSUPPORTED = Sets.newHashSet((Object[])new PacketType[]{PacketType.Play.Server.UPDATE_ATTRIBUTES, PacketType.Status.Server.SERVER_INFO});
    private Map<String, Object> metadata;

    @Deprecated
    public PacketContainer(int id) {
        this(PacketType.findLegacy(id), StructureCache.newPacket(PacketType.findLegacy(id)));
    }

    @Deprecated
    public PacketContainer(int id, Object handle) {
        this(PacketType.findLegacy(id), handle);
    }

    @Deprecated
    public PacketContainer(int id, Object handle, StructureModifier<Object> structure) {
        this(PacketType.findLegacy(id), handle, structure);
    }

    public PacketContainer(PacketType type) {
        this(type, StructureCache.newPacket(type));
    }

    public PacketContainer(PacketType type, Object handle) {
        this(type, handle, StructureCache.getStructure(type).withTarget(handle));
    }

    public PacketContainer(PacketType type, Object handle, StructureModifier<Object> structure) {
        if (handle == null) {
            throw new IllegalArgumentException("handle cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = type;
        this.handle = handle;
        this.structureModifier = structure;
    }

    public static PacketContainer fromPacket(Object packet) {
        PacketType type = PacketType.fromClass(packet.getClass());
        return new PacketContainer(type, packet);
    }

    protected PacketContainer() {
    }

    public Object getHandle() {
        return this.handle;
    }

    public StructureModifier<Object> getModifier() {
        return this.structureModifier;
    }

    public <T> StructureModifier<T> getSpecificModifier(Class<T> primitiveType) {
        return this.structureModifier.withType(primitiveType);
    }

    public StructureModifier<Byte> getBytes() {
        return this.structureModifier.withType(Byte.TYPE);
    }

    public StructureModifier<Boolean> getBooleans() {
        return this.structureModifier.withType(Boolean.TYPE);
    }

    public StructureModifier<Short> getShorts() {
        return this.structureModifier.withType(Short.TYPE);
    }

    public StructureModifier<Integer> getIntegers() {
        return this.structureModifier.withType(Integer.TYPE);
    }

    public StructureModifier<Long> getLongs() {
        return this.structureModifier.withType(Long.TYPE);
    }

    public StructureModifier<Float> getFloat() {
        return this.structureModifier.withType(Float.TYPE);
    }

    public StructureModifier<Double> getDoubles() {
        return this.structureModifier.withType(Double.TYPE);
    }

    public StructureModifier<String> getStrings() {
        return this.structureModifier.withType(String.class);
    }

    public StructureModifier<UUID> getUUIDs() {
        return this.structureModifier.withType(UUID.class);
    }

    public StructureModifier<String[]> getStringArrays() {
        return this.structureModifier.withType(String[].class);
    }

    public StructureModifier<byte[]> getByteArrays() {
        return this.structureModifier.withType(byte[].class);
    }

    public StreamSerializer getByteArraySerializer() {
        return new StreamSerializer();
    }

    public StructureModifier<int[]> getIntegerArrays() {
        return this.structureModifier.withType(int[].class);
    }

    public StructureModifier<ItemStack> getItemModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter());
    }

    public StructureModifier<ItemStack[]> getItemArrayModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackArrayClass(), BukkitConverters.getIgnoreNull(new ItemStackArrayConverter()));
    }

    public StructureModifier<List<ItemStack>> getItemListModifier() {
        return this.structureModifier.withType(List.class, BukkitConverters.getListConverter(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter()));
    }

    public StructureModifier<Map<WrappedStatistic, Integer>> getStatisticMaps() {
        return this.structureModifier.withType(Map.class, BukkitConverters.getMapConverter(MinecraftReflection.getStatisticClass(), BukkitConverters.getWrappedStatisticConverter()));
    }

    public StructureModifier<WorldType> getWorldTypeModifier() {
        return this.structureModifier.withType(MinecraftReflection.getWorldTypeClass(), BukkitConverters.getWorldTypeConverter());
    }

    public StructureModifier<WrappedDataWatcher> getDataWatcherModifier() {
        return this.structureModifier.withType(MinecraftReflection.getDataWatcherClass(), BukkitConverters.getDataWatcherConverter());
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world cannot be NULL.");
        return this.structureModifier.withType(Integer.TYPE, BukkitConverters.getEntityConverter(world));
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull PacketEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be NULL.");
        return this.getEntityModifier(event.getPlayer().getWorld());
    }

    public StructureModifier<ChunkPosition> getPositionModifier() {
        return this.structureModifier.withType(MinecraftReflection.getChunkPositionClass(), ChunkPosition.getConverter());
    }

    public StructureModifier<BlockPosition> getBlockPositionModifier() {
        return this.structureModifier.withType(MinecraftReflection.getBlockPositionClass(), BlockPosition.getConverter());
    }

    public StructureModifier<ChunkCoordIntPair> getChunkCoordIntPairs() {
        return this.structureModifier.withType(MinecraftReflection.getChunkCoordIntPair(), ChunkCoordIntPair.getConverter());
    }

    public StructureModifier<NbtBase<?>> getNbtModifier() {
        return this.structureModifier.withType(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter());
    }

    public StructureModifier<List<NbtBase<?>>> getListNbtModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter()));
    }

    public StructureModifier<Vector> getVectors() {
        return this.structureModifier.withType(MinecraftReflection.getVec3DClass(), BukkitConverters.getVectorConverter());
    }

    public StructureModifier<List<WrappedAttribute>> getAttributeCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getAttributeSnapshotClass(), BukkitConverters.getWrappedAttributeConverter()));
    }

    public StructureModifier<List<ChunkPosition>> getPositionCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getChunkPositionClass(), ChunkPosition.getConverter()));
    }

    public StructureModifier<List<BlockPosition>> getBlockPositionCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getBlockPositionClass(), BlockPosition.getConverter()));
    }

    public StructureModifier<List<WrappedWatchableObject>> getWatchableCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getDataWatcherItemClass(), BukkitConverters.getWatchableObjectConverter()));
    }

    public StructureModifier<Material> getBlocks() {
        return this.structureModifier.withType(MinecraftReflection.getBlockClass(), BukkitConverters.getBlockConverter());
    }

    public StructureModifier<WrappedGameProfile> getGameProfiles() {
        return this.structureModifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
    }

    public StructureModifier<WrappedBlockData> getBlockData() {
        return this.structureModifier.withType(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter());
    }

    public StructureModifier<MultiBlockChangeInfo[]> getMultiBlockChangeInfoArrays() {
        ChunkCoordIntPair chunk = this.getChunkCoordIntPairs().read(0);
        return this.structureModifier.withType(MinecraftReflection.getMultiBlockChangeInfoArrayClass(), MultiBlockChangeInfo.getArrayConverter(chunk));
    }

    public StructureModifier<WrappedChatComponent> getChatComponents() {
        return this.structureModifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
    }

    public StructureModifier<WrappedChatComponent[]> getChatComponentArrays() {
        return this.structureModifier.withType(ComponentArrayConverter.getGenericType(), BukkitConverters.getIgnoreNull(new ComponentArrayConverter()));
    }

    public StructureModifier<WrappedServerPing> getServerPings() {
        return this.structureModifier.withType(MinecraftReflection.getServerPingClass(), BukkitConverters.getWrappedServerPingConverter());
    }

    public StructureModifier<List<PlayerInfoData>> getPlayerInfoDataLists() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(MinecraftReflection.getPlayerInfoDataClass(), PlayerInfoData.getConverter()));
    }

    public StructureModifier<PacketType.Protocol> getProtocols() {
        return this.structureModifier.withType(EnumWrappers.getProtocolClass(), EnumWrappers.getProtocolConverter());
    }

    public StructureModifier<EnumWrappers.ClientCommand> getClientCommands() {
        return this.structureModifier.withType(EnumWrappers.getClientCommandClass(), EnumWrappers.getClientCommandConverter());
    }

    public StructureModifier<EnumWrappers.ChatVisibility> getChatVisibilities() {
        return this.structureModifier.withType(EnumWrappers.getChatVisibilityClass(), EnumWrappers.getChatVisibilityConverter());
    }

    public StructureModifier<EnumWrappers.Difficulty> getDifficulties() {
        return this.structureModifier.withType(EnumWrappers.getDifficultyClass(), EnumWrappers.getDifficultyConverter());
    }

    public StructureModifier<EnumWrappers.EntityUseAction> getEntityUseActions() {
        return this.structureModifier.withType(EnumWrappers.getEntityUseActionClass(), EnumWrappers.getEntityUseActionConverter());
    }

    public StructureModifier<EnumWrappers.NativeGameMode> getGameModes() {
        return this.structureModifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
    }

    public StructureModifier<EnumWrappers.ResourcePackStatus> getResourcePackStatus() {
        return this.structureModifier.withType(EnumWrappers.getResourcePackStatusClass(), EnumWrappers.getResourcePackStatusConverter());
    }

    public StructureModifier<EnumWrappers.PlayerInfoAction> getPlayerInfoAction() {
        return this.structureModifier.withType(EnumWrappers.getPlayerInfoActionClass(), EnumWrappers.getPlayerInfoActionConverter());
    }

    public StructureModifier<EnumWrappers.TitleAction> getTitleActions() {
        return this.structureModifier.withType(EnumWrappers.getTitleActionClass(), EnumWrappers.getTitleActionConverter());
    }

    public StructureModifier<EnumWrappers.WorldBorderAction> getWorldBorderActions() {
        return this.structureModifier.withType(EnumWrappers.getWorldBorderActionClass(), EnumWrappers.getWorldBorderActionConverter());
    }

    public StructureModifier<EnumWrappers.CombatEventType> getCombatEvents() {
        return this.structureModifier.withType(EnumWrappers.getCombatEventTypeClass(), EnumWrappers.getCombatEventTypeConverter());
    }

    public StructureModifier<EnumWrappers.PlayerDigType> getPlayerDigTypes() {
        return this.structureModifier.withType(EnumWrappers.getPlayerDigTypeClass(), EnumWrappers.getPlayerDiggingActionConverter());
    }

    public StructureModifier<EnumWrappers.PlayerAction> getPlayerActions() {
        return this.structureModifier.withType(EnumWrappers.getPlayerActionClass(), EnumWrappers.getEntityActionConverter());
    }

    public StructureModifier<EnumWrappers.ScoreboardAction> getScoreboardActions() {
        return this.structureModifier.withType(EnumWrappers.getScoreboardActionClass(), EnumWrappers.getUpdateScoreActionConverter());
    }

    public StructureModifier<EnumWrappers.Particle> getParticles() {
        return this.structureModifier.withType(EnumWrappers.getParticleClass(), EnumWrappers.getParticleConverter());
    }

    public StructureModifier<PotionEffectType> getEffectTypes() {
        return this.structureModifier.withType(MinecraftReflection.getMobEffectListClass(), BukkitConverters.getEffectTypeConverter());
    }

    public StructureModifier<EnumWrappers.SoundCategory> getSoundCategories() {
        return this.structureModifier.withType(EnumWrappers.getSoundCategoryClass(), EnumWrappers.getSoundCategoryConverter());
    }

    public StructureModifier<Sound> getSoundEffects() {
        return this.structureModifier.withType(MinecraftReflection.getSoundEffectClass(), BukkitConverters.getSoundConverter());
    }

    public StructureModifier<EnumWrappers.ItemSlot> getItemSlots() {
        return this.structureModifier.withType(EnumWrappers.getItemSlotClass(), EnumWrappers.getItemSlotConverter());
    }

    public StructureModifier<EnumWrappers.Hand> getHands() {
        return this.structureModifier.withType(EnumWrappers.getHandClass(), EnumWrappers.getHandConverter());
    }

    public StructureModifier<EnumWrappers.Direction> getDirections() {
        return this.structureModifier.withType(EnumWrappers.getDirectionClass(), EnumWrappers.getDirectionConverter());
    }

    public StructureModifier<EnumWrappers.ChatType> getChatTypes() {
        return this.structureModifier.withType(EnumWrappers.getChatTypeClass(), EnumWrappers.getChatTypeConverter());
    }

    public <T extends Enum<T>> StructureModifier<T> getEnumModifier(Class<T> enumClass, Class<?> nmsClass) {
        return this.structureModifier.withType(nmsClass, new EnumWrappers.EnumConverter<T>(enumClass));
    }

    public <T extends Enum<T>> StructureModifier<T> getEnumModifier(Class<T> enumClass, int index) {
        return this.getEnumModifier(enumClass, this.structureModifier.getField(index).getType());
    }

    @Deprecated
    public int getID() {
        return this.type.getLegacyId();
    }

    public PacketType getType() {
        return this.type;
    }

    public PacketContainer shallowClone() {
        Object clonedPacket = SHALLOW_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    public PacketContainer deepClone() {
        Object clonedPacket = null;
        clonedPacket = CLONING_UNSUPPORTED.contains(this.type) ? SerializableCloner.clone(this).getHandle() : DEEP_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    private static Function<AggregateCloner.BuilderParameters, Cloner> getSpecializedDeepClonerFactory() {
        return new Function<AggregateCloner.BuilderParameters, Cloner>(){

            public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
                return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                    {
                        super(defaultCloner, instanceProvider);
                        this.writer = new ObjectWriter(){

                            @Override
                            protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
                                if (modifierSource.getField(fieldIndex).getName().startsWith("inflatedBuffer")) {
                                    modifierDest.write(fieldIndex, modifierSource.read(fieldIndex));
                                } else {
                                    this.defaultTransform(modifierSource, modifierDest, this.getDefaultCloner(), fieldIndex);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeBoolean(this.handle != null);
        try {
            if (MinecraftReflection.isUsingNetty()) {
                ByteBuf buffer = PacketContainer.createPacketBuffer();
                MinecraftMethods.getPacketWriteByteBufMethod().invoke(this.handle, buffer);
                output.writeInt(buffer.readableBytes());
                buffer.readBytes((OutputStream)output, buffer.readableBytes());
            } else {
                output.writeInt(-1);
                this.getMethodLazily(writeMethods, this.handle.getClass(), "write", DataOutput.class).invoke(this.handle, new DataOutputStream(output));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Minecraft packet doesn't support DataOutputStream", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Insufficient security privileges.", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not serialize Minecraft packet.", e);
        }
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.structureModifier = StructureCache.getStructure(this.type);
        if (input.readBoolean()) {
            this.handle = StructureCache.newPacket(this.type);
            try {
                if (MinecraftReflection.isUsingNetty()) {
                    ByteBuf buffer = PacketContainer.createPacketBuffer();
                    buffer.writeBytes((InputStream)input, input.readInt());
                    MinecraftMethods.getPacketReadByteBufMethod().invoke(this.handle, buffer);
                } else {
                    if (input.readInt() != -1) {
                        throw new IllegalArgumentException("Cannot load a packet from 1.7.2 in 1.6.4.");
                    }
                    this.getMethodLazily(readMethods, this.handle.getClass(), "read", DataInput.class).invoke(this.handle, new DataInputStream(input));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Minecraft packet doesn't support DataInputStream", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Insufficient security privileges.", e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Could not deserialize Minecraft packet.", e);
            }
            this.structureModifier = this.structureModifier.withTarget(this.handle);
        }
    }

    public static ByteBuf createPacketBuffer() {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
        try {
            return (ByteBuf)packetSerializer.getConstructor(ByteBuf.class).newInstance(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    public Object getMetadata(String key) {
        if (this.metadata != null) {
            return this.metadata.get(key);
        }
        return null;
    }

    public void addMetadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
    }

    public Object removeMetadata(String key) {
        if (this.metadata != null) {
            Object value = this.metadata.remove(key);
            if (this.metadata.isEmpty()) {
                this.metadata = null;
            }
            return value;
        }
        return null;
    }

    public boolean hasMetadata(String key) {
        return this.metadata != null && this.metadata.containsKey(key);
    }

    private Method getMethodLazily(ConcurrentMap<Class<?>, Method> lookup, Class<?> handleClass, String methodName, Class<?> parameterClass) {
        Method initialized;
        Method method = (Method)lookup.get(handleClass);
        if (method == null && (method = lookup.putIfAbsent(handleClass, initialized = FuzzyReflection.fromClass(handleClass).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(parameterClass).returnTypeVoid().build()))) == null) {
            method = initialized;
        }
        return method;
    }

    public String toString() {
        return "PacketContainer[type=" + this.type + ", structureModifier=" + this.structureModifier + "]";
    }

    private static class ComponentArrayConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        private static final EquivalentConverter<WrappedChatComponent[]> DELEGATE = MinecraftReflection.signUpdateExists() ? new LegacyComponentConverter() : new NBTComponentConverter();

        private ComponentArrayConverter() {
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            return DELEGATE.getSpecific(generic);
        }

        @Override
        public Object getGeneric(Class<?> genericType, WrappedChatComponent[] specific) {
            return DELEGATE.getGeneric(genericType, specific);
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return DELEGATE.getSpecificType();
        }

        public static Class<?> getGenericType() {
            if (DELEGATE instanceof NBTComponentConverter) {
                return MinecraftReflection.getNBTCompoundClass();
            }
            return MinecraftReflection.getIChatBaseComponentArrayClass();
        }
    }

    private static class NBTComponentConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        private EquivalentConverter<NbtBase<?>> nbtConverter = BukkitConverters.getNbtConverter();
        private final int lines = 4;

        private NBTComponentConverter() {
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            NbtBase<?> nbtBase = this.nbtConverter.getSpecific(generic);
            NbtCompound compound = (NbtCompound)nbtBase;
            WrappedChatComponent[] components = new WrappedChatComponent[4];
            for (int i = 0; i < 4; ++i) {
                components[i] = compound.containsKey("Text" + (i + 1)) ? WrappedChatComponent.fromJson(compound.getString("Text" + (i + 1))) : WrappedChatComponent.fromText("");
            }
            return components;
        }

        @Override
        public Object getGeneric(Class<?> genericType, WrappedChatComponent[] specific) {
            NbtCompound compound = NbtFactory.ofCompound("");
            for (int i = 0; i < 4; ++i) {
                WrappedChatComponent component = i < specific.length && specific[i] != null ? specific[i] : WrappedChatComponent.fromText("");
                compound.put("Text" + (i + 1), component.getJson());
            }
            return this.nbtConverter.getGeneric(genericType, compound);
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return WrappedChatComponent[].class;
        }
    }

    private static class LegacyComponentConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        final EquivalentConverter<WrappedChatComponent> componentConverter = BukkitConverters.getWrappedChatComponentConverter();

        private LegacyComponentConverter() {
        }

        @Override
        public Object getGeneric(Class<?> genericType, WrappedChatComponent[] specific) {
            Class<?> nmsComponent = MinecraftReflection.getIChatBaseComponentClass();
            Object[] result = (Object[])Array.newInstance(nmsComponent, specific.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.componentConverter.getGeneric(nmsComponent, specific[i]);
            }
            return result;
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            Object[] input = (Object[])generic;
            WrappedChatComponent[] result = new WrappedChatComponent[input.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.componentConverter.getSpecific(input[i]);
            }
            return result;
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return WrappedChatComponent[].class;
        }
    }

    private static class ItemStackArrayConverter
    implements EquivalentConverter<ItemStack[]> {
        final EquivalentConverter<ItemStack> stackConverter = BukkitConverters.getItemStackConverter();

        private ItemStackArrayConverter() {
        }

        @Override
        public Object getGeneric(Class<?> genericType, ItemStack[] specific) {
            Class<?> nmsStack = MinecraftReflection.getItemStackClass();
            Object[] result = (Object[])Array.newInstance(nmsStack, specific.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getGeneric(nmsStack, specific[i]);
            }
            return result;
        }

        @Override
        public ItemStack[] getSpecific(Object generic) {
            Object[] input = (Object[])generic;
            ItemStack[] result = new ItemStack[input.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getSpecific(input[i]);
            }
            return result;
        }

        @Override
        public Class<ItemStack[]> getSpecificType() {
            return ItemStack[].class;
        }
    }
}

