/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.reflect.compiler.EmptyClassVisitor;
import com.comphenix.protocol.reflect.compiler.EmptyMethodVisitor;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.MethodVisitor;
import net.sf.cglib.asm.Type;

public class ClassAnalyser {
    private static final ClassAnalyser DEFAULT = new ClassAnalyser();

    public static ClassAnalyser getDefault() {
        return DEFAULT;
    }

    public List<AsmMethod> getMethodCalls(Method method) throws IOException {
        return this.getMethodCalls(method.getDeclaringClass(), method);
    }

    public List<AsmMethod> getMethodCalls(Class<?> clazz, Method method) throws IOException {
        ClassReader reader = new ClassReader(clazz.getCanonicalName());
        final ArrayList output = Lists.newArrayList();
        final String methodName = method.getName();
        final String methodDescription = Type.getMethodDescriptor((Method)method);
        reader.accept((ClassVisitor)new EmptyClassVisitor(){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (methodName.equals(name) && methodDescription.equals(desc)) {
                    return new EmptyMethodVisitor(){

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            output.add(new AsmMethod(AsmMethod.AsmOpcodes.fromIntOpcode(opcode), owner, methodName, desc));
                        }
                    };
                }
                return null;
            }
        }, 8);
        return output;
    }

    public static class AsmMethod {
        private final AsmOpcodes opcode;
        private final String ownerClass;
        private final String methodName;
        private final String signature;

        public AsmMethod(AsmOpcodes opcode, String ownerClass, String methodName, String signature) {
            this.opcode = opcode;
            this.ownerClass = ownerClass;
            this.methodName = methodName;
            this.signature = signature;
        }

        public String getOwnerName() {
            return this.ownerClass;
        }

        public AsmOpcodes getOpcode() {
            return this.opcode;
        }

        public Class<?> getOwnerClass() throws ClassNotFoundException {
            return AsmMethod.class.getClassLoader().loadClass(this.getOwnerName().replace('/', '.'));
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getSignature() {
            return this.signature;
        }

        public static enum AsmOpcodes {
            INVOKE_VIRTUAL,
            INVOKE_SPECIAL,
            INVOKE_STATIC,
            INVOKE_INTERFACE,
            INVOKE_DYNAMIC;


            public static AsmOpcodes fromIntOpcode(int opcode) {
                switch (opcode) {
                    case 182: {
                        return INVOKE_VIRTUAL;
                    }
                    case 183: {
                        return INVOKE_SPECIAL;
                    }
                    case 184: {
                        return INVOKE_STATIC;
                    }
                    case 185: {
                        return INVOKE_INTERFACE;
                    }
                    case 186: {
                        return INVOKE_DYNAMIC;
                    }
                }
                throw new IllegalArgumentException("Unknown opcode: " + opcode);
            }
        }
    }
}

