/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.netty.NettyProtocolRegistry;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PacketRegistry {
    public static final ReportType REPORT_CANNOT_CORRECT_TROVE_MAP = new ReportType("Unable to correct no entry value.");
    public static final ReportType REPORT_INSUFFICIENT_SERVER_PACKETS = new ReportType("Too few server packets detected: %s");
    public static final ReportType REPORT_INSUFFICIENT_CLIENT_PACKETS = new ReportType("Too few client packets detected: %s");
    private static volatile ProtocolRegistry NETTY;
    private static volatile Set<Integer> LEGACY_SERVER_PACKETS;
    private static volatile Set<Integer> LEGACY_CLIENT_PACKETS;
    private static volatile Map<Integer, Class> LEGACY_PREVIOUS_PACKETS;
    private static volatile boolean INITIALIZED;

    private static void initialize() {
        if (INITIALIZED) {
            if (NETTY == null) {
                throw new IllegalStateException("Failed to initialize packet registry.");
            }
            return;
        }
        NETTY = new NettyProtocolRegistry();
        INITIALIZED = true;
    }

    public static boolean isSupported(PacketType type) {
        PacketRegistry.initialize();
        return NETTY.getPacketTypeLookup().containsKey(type);
    }

    @Deprecated
    public static Map<Class, Integer> getPacketToID() {
        PacketRegistry.initialize();
        Map result = Maps.transformValues(NETTY.getPacketClassLookup(), (Function)new Function<PacketType, Integer>(){

            public Integer apply(PacketType type) {
                return type.getLegacyId();
            }
        });
        return result;
    }

    public static Map<Class, PacketType> getPacketToType() {
        PacketRegistry.initialize();
        Map<Class, PacketType> result = NETTY.getPacketClassLookup();
        return result;
    }

    @Deprecated
    public static Map<Integer, Class> getOverwrittenPackets() {
        PacketRegistry.initialize();
        throw new IllegalStateException("Not supported on Netty.");
    }

    @Deprecated
    public static Map<Integer, Class> getPreviousPackets() {
        PacketRegistry.initialize();
        if (LEGACY_PREVIOUS_PACKETS == null) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<PacketType, Class<?>> entry : NETTY.getPacketTypeLookup().entrySet()) {
                map.put(entry.getKey().getLegacyId(), entry.getValue());
            }
            LEGACY_PREVIOUS_PACKETS = Collections.unmodifiableMap(map);
        }
        return LEGACY_PREVIOUS_PACKETS;
    }

    @Deprecated
    public static Set<Integer> getServerPackets() throws FieldAccessException {
        if (LEGACY_SERVER_PACKETS == null) {
            LEGACY_SERVER_PACKETS = PacketRegistry.toLegacy(PacketRegistry.getServerPacketTypes());
        }
        return LEGACY_SERVER_PACKETS;
    }

    public static Set<PacketType> getServerPacketTypes() {
        PacketRegistry.initialize();
        NETTY.synchronize();
        HashSet<PacketType> types = new HashSet<PacketType>();
        for (PacketType type : NETTY.getServerPackets()) {
            if (type.isDeprecated()) continue;
            types.add(type);
        }
        return types;
    }

    @Deprecated
    public static Set<Integer> getClientPackets() throws FieldAccessException {
        if (LEGACY_CLIENT_PACKETS == null) {
            LEGACY_CLIENT_PACKETS = PacketRegistry.toLegacy(PacketRegistry.getClientPacketTypes());
        }
        return LEGACY_CLIENT_PACKETS;
    }

    public static Set<PacketType> getClientPacketTypes() {
        PacketRegistry.initialize();
        NETTY.synchronize();
        HashSet<PacketType> types = new HashSet<PacketType>();
        for (PacketType type : NETTY.getClientPackets()) {
            if (type.isDeprecated()) continue;
            types.add(type);
        }
        return types;
    }

    public static Set<Integer> toLegacy(Set<PacketType> types) {
        HashSet result = Sets.newHashSet();
        for (PacketType type : types) {
            result.add(type.getLegacyId());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<PacketType> toPacketTypes(Set<Integer> ids) {
        return PacketRegistry.toPacketTypes(ids, null);
    }

    public static Set<PacketType> toPacketTypes(Set<Integer> ids, PacketType.Sender preference) {
        HashSet result = Sets.newHashSet();
        for (int id : ids) {
            result.add(PacketType.fromLegacy(id, preference));
        }
        return Collections.unmodifiableSet(result);
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID) {
        PacketRegistry.initialize();
        return NETTY.getPacketTypeLookup().get(PacketType.findLegacy(packetID));
    }

    public static Class getPacketClassFromType(PacketType type) {
        return PacketRegistry.getPacketClassFromType(type, false);
    }

    public static Class getPacketClassFromType(PacketType type, boolean forceVanilla) {
        PacketRegistry.initialize();
        Class<?> clazz = NETTY.getPacketTypeLookup().get(type);
        if (clazz != null) {
            return clazz;
        }
        for (String name : type.getClassNames()) {
            try {
                clazz = MinecraftReflection.getMinecraftClass(name);
                break;
            }
            catch (Exception exception) {
            }
        }
        return clazz;
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID, boolean forceVanilla) {
        PacketRegistry.initialize();
        return PacketRegistry.getPacketClassFromID(packetID);
    }

    @Deprecated
    public static int getPacketID(Class<?> packet) {
        PacketRegistry.initialize();
        return NETTY.getPacketClassLookup().get(packet).getLegacyId();
    }

    public static PacketType getPacketType(Class<?> packet) {
        return PacketRegistry.getPacketType(packet, null);
    }

    public static PacketType getPacketType(Class<?> packet, PacketType.Sender sender) {
        PacketRegistry.initialize();
        return NETTY.getPacketClassLookup().get(packet);
    }

    static {
        INITIALIZED = false;
    }
}

