/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketTypeLookup;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.ObjectEnum;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;

public class PacketType
implements Serializable,
Cloneable,
Comparable<PacketType> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PACKET = -1;
    private static PacketTypeLookup LOOKUP;
    private static final MinecraftVersion PROTOCOL_VERSION;
    private final Protocol protocol;
    private final Sender sender;
    private final int currentId;
    private final int legacyId;
    private final MinecraftVersion version;
    private final String[] classNames;
    private boolean forceAsync;
    private boolean dynamic;
    private boolean deprecated;

    private static PacketTypeLookup getLookup() {
        if (LOOKUP == null) {
            LOOKUP = new PacketTypeLookup().addPacketTypes(Handshake.Client.getInstance()).addPacketTypes(Handshake.Server.getInstance()).addPacketTypes(Play.Client.getInstance()).addPacketTypes(Play.Server.getInstance()).addPacketTypes(Status.Client.getInstance()).addPacketTypes(Status.Server.getInstance()).addPacketTypes(Login.Client.getInstance()).addPacketTypes(Login.Server.getInstance()).addPacketTypes(Legacy.Client.getInstance()).addPacketTypes(Legacy.Server.getInstance());
        }
        return LOOKUP;
    }

    public static Iterable<PacketType> values() {
        ArrayList sources = Lists.newArrayList();
        sources.add(Handshake.Client.getInstance());
        sources.add(Handshake.Server.getInstance());
        sources.add(Play.Client.getInstance());
        sources.add(Play.Server.getInstance());
        sources.add(Status.Client.getInstance());
        sources.add(Status.Server.getInstance());
        sources.add(Login.Client.getInstance());
        sources.add(Login.Server.getInstance());
        if (!MinecraftReflection.isUsingNetty()) {
            sources.add(Legacy.Client.getInstance());
            sources.add(Legacy.Server.getInstance());
        }
        return Iterables.concat((Iterable)sources);
    }

    public static PacketType findLegacy(int packetId) {
        PacketType type = PacketType.getLookup().getFromLegacy(packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    public static PacketType findLegacy(int packetId, Sender preference) {
        if (preference == null) {
            return PacketType.findLegacy(packetId);
        }
        PacketType type = PacketType.getLookup().getFromLegacy(packetId, preference);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    public static boolean hasLegacy(int packetId) {
        return PacketType.getLookup().getFromLegacy(packetId) != null;
    }

    @Deprecated
    public static PacketType findCurrent(Protocol protocol, Sender sender, int packetId) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + packetId + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, String name) {
        name = PacketType.format(protocol, sender, name);
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + name + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static String format(Protocol protocol, Sender sender, String name) {
        if (name.contains("Packet")) {
            return name;
        }
        return String.format("Packet%s%s%s", protocol.getPacketName(), sender.getPacketName(), WordUtils.capitalize((String)name));
    }

    @Deprecated
    public static boolean hasCurrent(Protocol protocol, Sender sender, int packetId) {
        return PacketType.getLookup().getFromCurrent(protocol, sender, packetId) != null;
    }

    public static PacketType fromLegacy(int id, Sender sender) {
        PacketType type = PacketType.getLookup().getFromLegacy(id, sender);
        if (type == null) {
            if (sender == null) {
                throw new IllegalArgumentException("Cannot find legacy packet " + id);
            }
            type = PacketType.newLegacy(sender, id);
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromID(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, packetClass.getName());
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromCurrent(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        String clazz;
        PacketTypeLookup.ClassLookup lookup = PacketType.getLookup().getClassLookup();
        Map<String, PacketType> map = lookup.getMap(protocol, sender);
        PacketType type = PacketType.find(map, clazz = packetClass.getSimpleName());
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, clazz);
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    private static PacketType find(Map<String, PacketType> map, String clazz) {
        PacketType ret = map.get(clazz);
        if (ret != null) {
            return ret;
        }
        for (PacketType check : map.values()) {
            String[] aliases = check.getClassNames();
            if (aliases.length <= 1) continue;
            for (String alias : aliases) {
                if (!alias.equals(clazz)) continue;
                return check;
            }
        }
        return null;
    }

    public static PacketType fromClass(Class<?> packetClass) {
        PacketType type = PacketRegistry.getPacketType(packetClass);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Class " + packetClass + " is not a registered packet.");
    }

    public static Collection<PacketType> fromName(String name) {
        return PacketType.getLookup().getFromName(name);
    }

    public static boolean hasClass(Class<?> packetClass) {
        return PacketRegistry.getPacketType(packetClass) != null;
    }

    public static Future<Boolean> scheduleRegister(final PacketType type, final String name) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ObjectEnum<PacketType> objEnum = PacketType.getObjectEnum(type);
                if (objEnum.registerMember(type, name)) {
                    PacketType.getLookup().addPacketTypes(Arrays.asList(type));
                    return true;
                }
                return false;
            }
        };
        if (Bukkit.getServer() == null || Bukkit.isPrimaryThread()) {
            try {
                return Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return ProtocolLibrary.getExecutorSync().submit((Callable)callable);
    }

    public static ObjectEnum<PacketType> getObjectEnum(PacketType type) {
        switch (type.getProtocol()) {
            case HANDSHAKING: {
                return type.isClient() ? Handshake.Client.getInstance() : Handshake.Server.getInstance();
            }
            case PLAY: {
                return type.isClient() ? Play.Client.getInstance() : Play.Server.getInstance();
            }
            case STATUS: {
                return type.isClient() ? Status.Client.getInstance() : Status.Server.getInstance();
            }
            case LOGIN: {
                return type.isClient() ? Login.Client.getInstance() : Login.Server.getInstance();
            }
            case LEGACY: {
                return type.isClient() ? Legacy.Client.getInstance() : Legacy.Server.getInstance();
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + (Object)((Object)type.getProtocol()));
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, String ... names) {
        this(protocol, sender, currentId, legacyId, PROTOCOL_VERSION, names);
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, MinecraftVersion version, String ... names) {
        this.protocol = (Protocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol cannot be NULL"));
        this.sender = (Sender)((Object)Preconditions.checkNotNull((Object)((Object)sender), (Object)"sender cannot be NULL"));
        this.currentId = currentId;
        this.legacyId = legacyId;
        this.version = version;
        this.classNames = new String[names.length];
        for (int i = 0; i < this.classNames.length; ++i) {
            this.classNames[i] = PacketType.format(protocol, sender, names[i]);
        }
    }

    public static PacketType newLegacy(Sender sender, int legacyId) {
        return new PacketType(Protocol.LEGACY, sender, -1, legacyId, MinecraftVersion.WORLD_UPDATE, new String[0]);
    }

    public boolean isSupported() {
        return PacketRegistry.isSupported(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isClient() {
        return this.sender == Sender.CLIENT;
    }

    public boolean isServer() {
        return this.sender == Sender.SERVER;
    }

    @Deprecated
    public int getCurrentId() {
        return this.currentId;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public Class<?> getPacketClass() {
        try {
            return PacketRegistry.getPacketClassFromType(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String name() {
        return PacketType.getObjectEnum(this).getDeclaredName(this);
    }

    public MinecraftVersion getCurrentVersion() {
        return this.version;
    }

    public int getLegacyId() {
        return this.legacyId;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    private PacketType forceAsync(boolean forceAsync) {
        this.forceAsync = forceAsync;
        return this;
    }

    public boolean forceAsync() {
        return this.forceAsync;
    }

    private PacketType deprecatedIn(MinecraftVersion version) {
        try {
            return MinecraftVersion.getCurrentVersion().isAtLeast(version) ? this.deprecated() : this;
        }
        catch (Throwable ex) {
            return this.deprecated();
        }
    }

    private PacketType deprecated() {
        PacketType ret = this.clone();
        ret.deprecated = true;
        return ret;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.protocol, this.sender, this.currentId, this.legacyId});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PacketType) {
            PacketType other = (PacketType)obj;
            return this.protocol == other.protocol && this.sender == other.sender && this.currentId == other.currentId && this.legacyId == other.legacyId;
        }
        return false;
    }

    @Override
    public int compareTo(PacketType other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.protocol), (Comparable)((Object)other.getProtocol())).compare((Comparable)((Object)this.sender), (Comparable)((Object)other.getSender())).compare(this.currentId, other.getCurrentId()).compare(this.legacyId, other.getLegacyId()).result();
    }

    public String toString() {
        Class<?> clazz = this.getPacketClass();
        if (clazz == null) {
            return this.name() + "[" + (Object)((Object)this.protocol) + ", " + (Object)((Object)this.sender) + ", " + this.currentId + ", legacy: " + this.legacyId + ", classNames: " + Arrays.toString(this.classNames) + " (unregistered)]";
        }
        return clazz.getSimpleName() + "[" + this.currentId + ", legacy: " + this.legacyId + "]";
    }

    public PacketType clone() {
        try {
            return (PacketType)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("This shouldn't happen", ex);
        }
    }

    static /* synthetic */ PacketType access$200(PacketType x0, MinecraftVersion x1) {
        return x0.deprecatedIn(x1);
    }

    static /* synthetic */ PacketType access$300(PacketType x0) {
        return x0.deprecated();
    }

    static /* synthetic */ PacketType access$500(PacketType x0, boolean x1) {
        return x0.forceAsync(x1);
    }

    static {
        PROTOCOL_VERSION = MinecraftVersion.EXPLORATION_UPDATE;
    }

    public static enum Sender {
        CLIENT,
        SERVER;


        public ConnectionSide toSide() {
            return this == CLIENT ? ConnectionSide.CLIENT_SIDE : ConnectionSide.SERVER_SIDE;
        }

        public String getPacketName() {
            return this == CLIENT ? "In" : "Out";
        }
    }

    public static enum Protocol {
        HANDSHAKING,
        PLAY,
        STATUS,
        LOGIN,
        LEGACY;


        public static Protocol fromVanilla(Enum<?> vanilla) {
            String name = vanilla.name();
            if ("HANDSHAKING".equals(name)) {
                return HANDSHAKING;
            }
            if ("PLAY".equals(name)) {
                return PLAY;
            }
            if ("STATUS".equals(name)) {
                return STATUS;
            }
            if ("LOGIN".equals(name)) {
                return LOGIN;
            }
            throw new IllegalArgumentException("Unrecognized vanilla enum " + vanilla);
        }

        public String getPacketName() {
            return WordUtils.capitalize((String)this.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static class Legacy {
        private static final Protocol PROTOCOL = Protocol.LEGACY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType LOGIN = PacketType.newLegacy(SENDER, 1);
            public static final PacketType RESPAWN = PacketType.newLegacy(SENDER, 9);
            public static final PacketType DISCONNECT = PacketType.newLegacy(SENDER, 255);
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType PLAYER_FLYING = PacketType.newLegacy(SENDER, 10);
            public static final PacketType PLAYER_POSITION = PacketType.newLegacy(SENDER, 11);
            public static final PacketType PLAYER_POSITON_LOOK = PacketType.newLegacy(SENDER, 12);
            public static final PacketType PICKUP_SPAWN = PacketType.newLegacy(SENDER, 21);
            public static final PacketType SET_CREATIVE_SLOT = PacketType.newLegacy(SENDER, 107);
            public static final PacketType KEY_RESPONSE = PacketType.newLegacy(SENDER, 252);
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Login {
        private static final Protocol PROTOCOL = Protocol.LOGIN;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$600() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Login.access$600(), SENDER, 0, 0, "Start");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$600(), SENDER, 1, 1, "EncryptionBegin");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType DISCONNECT = new PacketType(Login.access$600(), SENDER, 0, 0, "Disconnect");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$600(), SENDER, 1, 1, "EncryptionBegin");
            public static final PacketType SUCCESS = new PacketType(Login.access$600(), SENDER, 2, 2, "Success");
            public static final PacketType SET_COMPRESSION = new PacketType(Login.access$600(), SENDER, 3, 3, "SetCompression");
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Status {
        private static final Protocol PROTOCOL = Protocol.STATUS;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$400() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Status.access$400(), SENDER, 0, 0, "Start");
            public static final PacketType PING = new PacketType(Status.access$400(), SENDER, 1, 1, "Ping");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType SERVER_INFO = PacketType.access$500(new PacketType(Status.access$400(), SENDER, 0, 0, "ServerInfo"), true);
            public static final PacketType PONG = new PacketType(Status.access$400(), SENDER, 1, 1, "Pong");
            @Deprecated
            public static final PacketType OUT_SERVER_INFO = PacketType.access$300(SERVER_INFO);
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Play {
        private static final Protocol PROTOCOL = Protocol.PLAY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$100() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType TELEPORT_ACCEPT = new PacketType(Play.access$100(), SENDER, 0, 249, "TeleportAccept");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 1, 20, "TabComplete");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 2, 1, "Chat");
            public static final PacketType CLIENT_COMMAND = new PacketType(Play.access$100(), SENDER, 3, 22, "ClientCommand");
            public static final PacketType SETTINGS = new PacketType(Play.access$100(), SENDER, 4, 21, "Settings");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 5, 15, "Transaction");
            public static final PacketType ENCHANT_ITEM = new PacketType(Play.access$100(), SENDER, 6, 17, "EnchantItem");
            public static final PacketType WINDOW_CLICK = new PacketType(Play.access$100(), SENDER, 7, 14, "WindowClick");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 8, 13, "CloseWindow");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 9, 23, "CustomPayload");
            public static final PacketType USE_ENTITY = new PacketType(Play.access$100(), SENDER, 10, 2, "UseEntity");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 11, 0, "KeepAlive");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 12, 4, "Position");
            public static final PacketType POSITION_LOOK = new PacketType(Play.access$100(), SENDER, 13, 6, "PositionLook");
            public static final PacketType LOOK = new PacketType(Play.access$100(), SENDER, 14, 5, "Look");
            public static final PacketType FLYING = new PacketType(Play.access$100(), SENDER, 15, 3, "Flying");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 16, 248, "VehicleMove");
            public static final PacketType BOAT_MOVE = new PacketType(Play.access$100(), SENDER, 17, 247, "BoatMove");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 18, 19, "Abilities");
            public static final PacketType BLOCK_DIG = new PacketType(Play.access$100(), SENDER, 19, 7, "BlockDig");
            public static final PacketType ENTITY_ACTION = new PacketType(Play.access$100(), SENDER, 20, 11, "EntityAction");
            public static final PacketType STEER_VEHICLE = new PacketType(Play.access$100(), SENDER, 21, 12, "SteerVehicle");
            public static final PacketType RESOURCE_PACK_STATUS = new PacketType(Play.access$100(), SENDER, 22, 25, "ResourcePackStatus");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 23, 9, "HeldItemSlot");
            public static final PacketType SET_CREATIVE_SLOT = new PacketType(Play.access$100(), SENDER, 24, 16, "SetCreativeSlot");
            public static final PacketType UPDATE_SIGN = new PacketType(Play.access$100(), SENDER, 25, 18, "UpdateSign");
            public static final PacketType ARM_ANIMATION = new PacketType(Play.access$100(), SENDER, 26, 10, "ArmAnimation");
            public static final PacketType SPECTATE = new PacketType(Play.access$100(), SENDER, 27, 24, "Spectate");
            public static final PacketType USE_ITEM = new PacketType(Play.access$100(), SENDER, 28, 246, "UseItem");
            public static final PacketType BLOCK_PLACE = new PacketType(Play.access$100(), SENDER, 29, 8, "BlockPlace");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType SPAWN_ENTITY = new PacketType(Play.access$100(), SENDER, 0, 14, "SpawnEntity");
            public static final PacketType SPAWN_ENTITY_EXPERIENCE_ORB = new PacketType(Play.access$100(), SENDER, 1, 17, "SpawnEntityExperienceOrb");
            public static final PacketType SPAWN_ENTITY_WEATHER = new PacketType(Play.access$100(), SENDER, 2, 44, "SpawnEntityWeather");
            public static final PacketType SPAWN_ENTITY_LIVING = new PacketType(Play.access$100(), SENDER, 3, 15, "SpawnEntityLiving");
            public static final PacketType SPAWN_ENTITY_PAINTING = new PacketType(Play.access$100(), SENDER, 4, 16, "SpawnEntityPainting");
            public static final PacketType NAMED_ENTITY_SPAWN = new PacketType(Play.access$100(), SENDER, 5, 12, "NamedEntitySpawn");
            public static final PacketType ANIMATION = new PacketType(Play.access$100(), SENDER, 6, 11, "Animation");
            public static final PacketType STATISTIC = new PacketType(Play.access$100(), SENDER, 7, 55, "Statistic");
            public static final PacketType BLOCK_BREAK_ANIMATION = new PacketType(Play.access$100(), SENDER, 8, 37, "BlockBreakAnimation");
            public static final PacketType TILE_ENTITY_DATA = new PacketType(Play.access$100(), SENDER, 9, 53, "TileEntityData");
            public static final PacketType BLOCK_ACTION = new PacketType(Play.access$100(), SENDER, 10, 36, "BlockAction");
            public static final PacketType BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 11, 35, "BlockChange");
            public static final PacketType BOSS = new PacketType(Play.access$100(), SENDER, 12, 255, "Boss");
            public static final PacketType SERVER_DIFFICULTY = new PacketType(Play.access$100(), SENDER, 13, 65, "ServerDifficulty");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 14, 58, "TabComplete");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 15, 2, "Chat");
            public static final PacketType MULTI_BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 16, 34, "MultiBlockChange");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 17, 50, "Transaction");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 18, 46, "CloseWindow");
            public static final PacketType OPEN_WINDOW = new PacketType(Play.access$100(), SENDER, 19, 45, "OpenWindow");
            public static final PacketType WINDOW_ITEMS = new PacketType(Play.access$100(), SENDER, 20, 48, "WindowItems");
            public static final PacketType WINDOW_DATA = new PacketType(Play.access$100(), SENDER, 21, 49, "WindowData");
            public static final PacketType SET_SLOT = new PacketType(Play.access$100(), SENDER, 22, 47, "SetSlot");
            public static final PacketType SET_COOLDOWN = new PacketType(Play.access$100(), SENDER, 23, 252, "SetCooldown");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 24, 63, "CustomPayload");
            public static final PacketType CUSTOM_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 25, 253, "CustomSoundEffect");
            public static final PacketType KICK_DISCONNECT = new PacketType(Play.access$100(), SENDER, 26, 64, "KickDisconnect");
            public static final PacketType ENTITY_STATUS = new PacketType(Play.access$100(), SENDER, 27, 26, "EntityStatus");
            public static final PacketType EXPLOSION = new PacketType(Play.access$100(), SENDER, 28, 39, "Explosion");
            public static final PacketType UNLOAD_CHUNK = new PacketType(Play.access$100(), SENDER, 29, 250, "UnloadChunk");
            public static final PacketType GAME_STATE_CHANGE = new PacketType(Play.access$100(), SENDER, 30, 43, "GameStateChange");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 31, 0, "KeepAlive");
            public static final PacketType MAP_CHUNK = new PacketType(Play.access$100(), SENDER, 32, 33, "MapChunk");
            public static final PacketType WORLD_EVENT = new PacketType(Play.access$100(), SENDER, 33, 40, "WorldEvent");
            public static final PacketType WORLD_PARTICLES = new PacketType(Play.access$100(), SENDER, 34, 42, "WorldParticles");
            public static final PacketType LOGIN = new PacketType(Play.access$100(), SENDER, 35, 1, "Login");
            public static final PacketType MAP = new PacketType(Play.access$100(), SENDER, 36, 52, "Map");
            public static final PacketType REL_ENTITY_MOVE = new PacketType(Play.access$100(), SENDER, 37, 21, "RelEntityMove");
            public static final PacketType REL_ENTITY_MOVE_LOOK = new PacketType(Play.access$100(), SENDER, 38, 23, "RelEntityMoveLook");
            public static final PacketType ENTITY_LOOK = new PacketType(Play.access$100(), SENDER, 39, 22, "EntityLook");
            public static final PacketType ENTITY = new PacketType(Play.access$100(), SENDER, 40, 20, "Entity");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 41, 254, "VehicleMove");
            public static final PacketType OPEN_SIGN_EDITOR = new PacketType(Play.access$100(), SENDER, 42, 54, "OpenSignEditor");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 43, 57, "Abilities");
            public static final PacketType COMBAT_EVENT = new PacketType(Play.access$100(), SENDER, 44, 66, "CombatEvent");
            public static final PacketType PLAYER_INFO = new PacketType(Play.access$100(), SENDER, 45, 56, "PlayerInfo");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 46, 8, "Position");
            public static final PacketType BED = new PacketType(Play.access$100(), SENDER, 47, 10, "Bed");
            public static final PacketType ENTITY_DESTROY = new PacketType(Play.access$100(), SENDER, 48, 19, "EntityDestroy");
            public static final PacketType REMOVE_ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 49, 30, "RemoveEntityEffect");
            public static final PacketType RESOURCE_PACK_SEND = new PacketType(Play.access$100(), SENDER, 50, 72, "ResourcePackSend");
            public static final PacketType RESPAWN = new PacketType(Play.access$100(), SENDER, 51, 7, "Respawn");
            public static final PacketType ENTITY_HEAD_ROTATION = new PacketType(Play.access$100(), SENDER, 52, 25, "EntityHeadRotation");
            public static final PacketType WORLD_BORDER = new PacketType(Play.access$100(), SENDER, 53, 68, "WorldBorder");
            public static final PacketType CAMERA = new PacketType(Play.access$100(), SENDER, 54, 67, "Camera");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 55, 9, "HeldItemSlot");
            public static final PacketType SCOREBOARD_DISPLAY_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 56, 61, "ScoreboardDisplayObjective");
            public static final PacketType ENTITY_METADATA = new PacketType(Play.access$100(), SENDER, 57, 28, "EntityMetadata");
            public static final PacketType ATTACH_ENTITY = new PacketType(Play.access$100(), SENDER, 58, 27, "AttachEntity");
            public static final PacketType ENTITY_VELOCITY = new PacketType(Play.access$100(), SENDER, 59, 18, "EntityVelocity");
            public static final PacketType ENTITY_EQUIPMENT = new PacketType(Play.access$100(), SENDER, 60, 4, "EntityEquipment");
            public static final PacketType EXPERIENCE = new PacketType(Play.access$100(), SENDER, 61, 31, "Experience");
            public static final PacketType UPDATE_HEALTH = new PacketType(Play.access$100(), SENDER, 62, 6, "UpdateHealth");
            public static final PacketType SCOREBOARD_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 63, 59, "ScoreboardObjective");
            public static final PacketType MOUNT = new PacketType(Play.access$100(), SENDER, 64, 251, "Mount");
            public static final PacketType SCOREBOARD_TEAM = new PacketType(Play.access$100(), SENDER, 65, 62, "ScoreboardTeam");
            public static final PacketType SCOREBOARD_SCORE = new PacketType(Play.access$100(), SENDER, 66, 60, "ScoreboardScore");
            public static final PacketType SPAWN_POSITION = new PacketType(Play.access$100(), SENDER, 67, 5, "SpawnPosition");
            public static final PacketType UPDATE_TIME = new PacketType(Play.access$100(), SENDER, 68, 3, "UpdateTime");
            public static final PacketType TITLE = new PacketType(Play.access$100(), SENDER, 69, 69, "Title");
            public static final PacketType NAMED_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 70, 71, "NamedSoundEffect");
            public static final PacketType PLAYER_LIST_HEADER_FOOTER = new PacketType(Play.access$100(), SENDER, 71, 72, "PlayerListHeaderFooter");
            public static final PacketType COLLECT = new PacketType(Play.access$100(), SENDER, 72, 73, "Collect");
            public static final PacketType ENTITY_TELEPORT = new PacketType(Play.access$100(), SENDER, 73, 74, "EntityTeleport");
            public static final PacketType UPDATE_ATTRIBUTES = new PacketType(Play.access$100(), SENDER, 74, 75, "UpdateAttributes");
            public static final PacketType ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 75, 76, "EntityEffect");
            @Deprecated
            public static final PacketType MAP_CHUNK_BULK = PacketType.access$200(new PacketType(Play.access$100(), SENDER, 255, 255, "MapChunkBulk"), MinecraftVersion.COMBAT_UPDATE);
            @Deprecated
            public static final PacketType SET_COMPRESSION = PacketType.access$200(new PacketType(Play.access$100(), SENDER, 254, 254, "SetCompression"), MinecraftVersion.COMBAT_UPDATE);
            @Deprecated
            public static final PacketType UPDATE_ENTITY_NBT = PacketType.access$200(new PacketType(Play.access$100(), SENDER, 253, 253, "UpdateEntityNBT"), MinecraftVersion.COMBAT_UPDATE);
            @Deprecated
            public static final PacketType CRAFT_PROGRESS_BAR = PacketType.access$300(WINDOW_DATA);
            @Deprecated
            public static final PacketType ENTITY_MOVE_LOOK = PacketType.access$300(REL_ENTITY_MOVE_LOOK);
            @Deprecated
            public static final PacketType STATISTICS = PacketType.access$300(STATISTIC);
            @Deprecated
            public static final PacketType OPEN_SIGN_ENTITY = PacketType.access$300(OPEN_SIGN_EDITOR);
            @Deprecated
            public static final PacketType UPDATE_SIGN = MinecraftReflection.signUpdateExists() ? new PacketType(Play.access$100(), SENDER, 252, 252, "UpdateSign") : PacketType.access$300(TILE_ENTITY_DATA);
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Handshake {
        private static final Protocol PROTOCOL = Protocol.HANDSHAKING;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$000() {
            return PROTOCOL;
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Server getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType SET_PROTOCOL = new PacketType(Handshake.access$000(), SENDER, 0, 0, "SetProtocol");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Client getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }
    }
}

