/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.diff.provider;

import com.cloudbees.diff.Diff;
import com.cloudbees.diff.Difference;
import com.cloudbees.diff.provider.DiffProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdlineDiffProvider
extends DiffProvider
implements Serializable {
    public static final String DIFF_REGEXP = "(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)";
    private static final int BUFF_LENGTH = 1024;
    private String diffCmd;
    private static final Pattern pattern = Pattern.compile("(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)");
    static final long serialVersionUID = 4101521743158176210L;
    private static final Logger LOGGER = Logger.getLogger(CmdlineDiffProvider.class.getName());

    public CmdlineDiffProvider(String diffCmd) {
        this.diffCmd = diffCmd;
    }

    public static CmdlineDiffProvider createDefault() {
        return new CmdlineDiffProvider("diff {0} {1}");
    }

    public void setDiffCommand(String diffCmd) {
        this.diffCmd = diffCmd;
    }

    public String getDiffCommand() {
        return this.diffCmd;
    }

    private static boolean checkEmpty(String str, String element) {
        return str == null || str.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Diff computeDiff(Reader r1, Reader r2) throws IOException {
        File f1 = null;
        File f2 = null;
        try {
            int length;
            f1 = File.createTempFile("TempDiff".intern(), null);
            f2 = File.createTempFile("TempDiff".intern(), null);
            FileWriter fw1 = new FileWriter(f1);
            FileWriter fw2 = new FileWriter(f2);
            char[] buffer = new char[1024];
            while ((length = r1.read(buffer)) > 0) {
                fw1.write(buffer, 0, length);
            }
            while ((length = r2.read(buffer)) > 0) {
                fw2.write(buffer, 0, length);
            }
            r1.close();
            r2.close();
            fw1.close();
            fw2.close();
            Diff diff = this.createDiff(f1, f2);
            return diff;
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Diff createDiff(File f1, File f2) throws IOException {
        String secondPath;
        String firstPath;
        final StringBuffer firstText = new StringBuffer();
        final StringBuffer secondText = new StringBuffer();
        this.diffCmd = this.diffCmd.replace("\"{0}\"", "{0}").replace("\"{1}\"", "{1}");
        if (this.isWindows()) {
            firstPath = "\"" + f1.getAbsolutePath() + "\"";
            secondPath = "\"" + f2.getAbsolutePath() + "\"";
        } else {
            firstPath = f1.getAbsolutePath();
            secondPath = f2.getAbsolutePath();
        }
        final String cmd = MessageFormat.format(this.diffCmd, firstPath, secondPath);
        final Process[] p = new Process[1];
        final Object[] ret = new Object[1];
        Runnable cancellableProcessWrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LOGGER.fine("#69616 CDP: executing: " + cmd);
                    Process[] processArray = p;
                    synchronized (p) {
                        int length;
                        p[0] = Runtime.getRuntime().exec(cmd);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        InputStreamReader stdout = new InputStreamReader(p[0].getInputStream());
                        char[] buffer = new char[1024];
                        StringBuilder outBuffer = new StringBuilder();
                        Diff differences = new Diff();
                        while ((length = stdout.read(buffer)) > 0) {
                            for (int i = 0; i < length; ++i) {
                                if (buffer[i] == '\n') {
                                    CmdlineDiffProvider.outputLine(outBuffer.toString(), pattern, differences, firstText, secondText);
                                    outBuffer.delete(0, outBuffer.length());
                                    continue;
                                }
                                if (buffer[i] == '\r') continue;
                                outBuffer.append(buffer[i]);
                            }
                        }
                        if (outBuffer.length() > 0) {
                            CmdlineDiffProvider.outputLine(outBuffer.toString(), pattern, differences, firstText, secondText);
                        }
                        CmdlineDiffProvider.setTextOnLastDifference(differences, firstText, secondText);
                        ret[0] = differences;
                    }
                }
                catch (IOException ioex) {
                    ret[0] = new IOException("Failed to execute: " + cmd).initCause(ioex);
                }
            }
        };
        Thread t = new Thread(cancellableProcessWrapper, "Diff.exec()");
        t.start();
        try {
            t.join();
            Object[] objectArray = ret;
            synchronized (ret) {
                if (ret[0] instanceof IOException) {
                    throw (IOException)ret[0];
                }
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return (Diff)ret[0];
            }
        }
        catch (InterruptedException e) {
            Process process = p[0];
            synchronized (process) {
                p[0].destroy();
            }
            throw new InterruptedIOException();
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    public static void setTextOnLastDifference(List<Difference> differences, StringBuffer firstText, StringBuffer secondText) {
        if (differences.size() > 0) {
            String t2;
            String t1 = firstText.toString();
            if (t1.length() == 0) {
                t1 = null;
            }
            if ((t2 = secondText.toString()).length() == 0) {
                t2 = null;
            }
            Difference d = differences.remove(differences.size() - 1);
            differences.add(new Difference(d.getType(), d.getFirstStart(), d.getFirstEnd(), d.getSecondStart(), d.getSecondEnd(), t1, t2));
            firstText.delete(0, firstText.length());
            secondText.delete(0, secondText.length());
        }
    }

    public static void outputLine(String elements, Pattern pattern, List<Difference> differences, StringBuffer firstText, StringBuffer secondText) {
        if (!pattern.matcher(elements).matches()) {
            if (elements.startsWith("< ")) {
                firstText.append(elements.substring(2) + "\n");
            }
            if (elements.startsWith("> ")) {
                secondText.append(elements.substring(2) + "\n");
            }
            return;
        }
        CmdlineDiffProvider.setTextOnLastDifference(differences, firstText, secondText);
        int index = elements.indexOf(97);
        if (index >= 0) {
            int n4;
            int n3;
            int n1;
            try {
                n1 = Integer.parseInt(elements.substring(0, index));
                int commaIndex = elements.indexOf(44, ++index);
                if (commaIndex < 0) {
                    String nStr = elements.substring(index, elements.length());
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n4 = n3 = Integer.parseInt(nStr);
                } else {
                    String nStr = elements.substring(index, commaIndex);
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                    nStr = elements.substring(commaIndex + 1, elements.length());
                    n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            differences.add(new Difference(1, n1, 0, n3, n4));
        } else {
            index = elements.indexOf(100);
            if (index >= 0) {
                int n3;
                int n2;
                int n1;
                int commaIndex = elements.lastIndexOf(44, index);
                try {
                    String nStr;
                    if (commaIndex < 0) {
                        n2 = n1 = Integer.parseInt(elements.substring(0, index));
                    } else {
                        nStr = elements.substring(0, commaIndex);
                        if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                            return;
                        }
                        n1 = Integer.parseInt(nStr);
                        nStr = elements.substring(commaIndex + 1, index);
                        if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                            return;
                        }
                        n2 = Integer.parseInt(nStr);
                    }
                    nStr = elements.substring(index + 1, elements.length());
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                }
                catch (NumberFormatException e) {
                    return;
                }
                differences.add(new Difference(0, n1, n2, n3, 0));
            } else {
                index = elements.indexOf(99);
                if (index >= 0) {
                    int n4;
                    int n3;
                    int n2;
                    int n1;
                    int commaIndex = elements.lastIndexOf(44, index);
                    try {
                        String nStr;
                        if (commaIndex < 0) {
                            n2 = n1 = Integer.parseInt(elements.substring(0, index));
                        } else {
                            nStr = elements.substring(0, commaIndex);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n1 = Integer.parseInt(nStr);
                            nStr = elements.substring(commaIndex + 1, index);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n2 = Integer.parseInt(nStr);
                        }
                        commaIndex = elements.indexOf(44, ++index);
                        if (commaIndex < 0) {
                            nStr = elements.substring(index, elements.length());
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n4 = n3 = Integer.parseInt(nStr);
                        } else {
                            nStr = elements.substring(index, commaIndex);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n3 = Integer.parseInt(nStr);
                            nStr = elements.substring(commaIndex + 1, elements.length());
                            n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                    differences.add(new Difference(2, n1, n2, n3, n4));
                }
            }
        }
    }
}

