/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.views.ViewRequest;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.PageMetadata;
import com.cloudant.client.internal.views.PaginationToken;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequester;
import com.cloudant.client.internal.views.ViewResponseImpl;
import java.io.IOException;
import java.util.List;

class ViewRequestImpl<K, V>
implements ViewRequest<K, V> {
    protected final ViewQueryParameters<K, V> viewQueryParameters;

    ViewRequestImpl(ViewQueryParameters<K, V> viewQueryParameters) {
        this.viewQueryParameters = viewQueryParameters;
    }

    @Override
    public ViewResponse<K, V> getResponse() throws IOException {
        return this.getResponse(null);
    }

    @Override
    public ViewResponse<K, V> getResponse(String paginationToken) throws IOException {
        PageMetadata<K, V> pageMetadata = paginationToken != null ? PaginationToken.mergeTokenAndQueryParameters(paginationToken, this.viewQueryParameters) : null;
        return this.makeResponse(pageMetadata);
    }

    @Override
    public V getSingleValue() throws IOException {
        List<V> values = this.getResponse().getValues();
        if (values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected ViewResponseImpl<K, V> makeResponse(PageMetadata<K, V> metadata) throws IOException {
        ViewQueryParameters requestParameters = metadata != null ? metadata.pageRequestParameters : this.viewQueryParameters;
        return new ViewResponseImpl<K, V>(this.viewQueryParameters, ViewRequester.getResponseAsJson(requestParameters), metadata);
    }
}

