/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.model.Document;
import com.cloudant.client.api.views.AllDocsRequest;
import com.cloudant.client.api.views.AllDocsResponse;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.AllDocsRequestImpl;
import com.cloudant.client.internal.views.ViewQueryParameters;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllDocsRequestResponse
implements AllDocsRequest,
AllDocsResponse {
    private final AllDocsRequestImpl request;
    private ViewResponse<String, AllDocsValue> response = null;

    AllDocsRequestResponse(ViewQueryParameters<String, AllDocsValue> parameters) {
        this.request = new AllDocsRequestImpl(parameters);
    }

    @Override
    public AllDocsResponse getResponse() throws IOException {
        this.response = this.request.getResponse();
        return this;
    }

    @Override
    public List<Document> getDocs() {
        return this.response.getDocs();
    }

    @Override
    public Map<String, String> getIdsAndRevs() {
        HashMap<String, String> docIdsAndRevs = new HashMap<String, String>();
        for (ViewResponse.Row<String, AllDocsValue> row : this.response.getRows()) {
            AllDocsValue rev = row.getValue();
            if (rev == null) continue;
            docIdsAndRevs.put(row.getKey(), rev.getRev());
        }
        return docIdsAndRevs;
    }

    @Override
    public <D> List<D> getDocsAs(Class<D> docType) {
        return this.response.getDocsAs(docType);
    }

    @Override
    public List<String> getDocIds() {
        return this.response.getKeys();
    }

    @Override
    public Map<String, String> getErrors() {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (ViewResponse.Row<String, AllDocsValue> row : this.response.getRows()) {
            if (row.getError() == null) continue;
            errors.put(row.getKey(), row.getError());
        }
        return errors;
    }

    @Override
    public Long getTotalRowCount() {
        return this.response.getTotalRowCount();
    }

    public static final class AllDocsValue {
        private String rev = null;
        private boolean deleted = false;

        public String getRev() {
            return this.rev;
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

