/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.query;

import com.cloudant.client.api.query.Field;
import com.cloudant.client.internal.query.InternalIndex;
import com.cloudant.client.internal.query.NamedField;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public class ListableIndex
extends InternalIndex<Definition, Field> {
    protected ListableIndex(String type) {
        super(type);
    }

    public String toString() {
        StringBuilder index = new StringBuilder();
        index.append("ddoc: ");
        index.append(this.getDesignDocumentID());
        index.append(", name: ");
        index.append(this.getName());
        index.append(", type: ");
        index.append(this.getType());
        index.append(", fields: ");
        index.append(this.getFields().toString());
        index.append(", partial_filter_selector: ");
        index.append(this.getPartialFilterSelector());
        return index.toString();
    }

    static class Adapter
    implements JsonDeserializer<Definition> {
        Adapter() {
        }

        public Definition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Definition def = new Definition();
            JsonObject d = json.getAsJsonObject();
            JsonArray fields = d.getAsJsonArray("fields");
            ArrayList<NamedField> namedFields = new ArrayList<NamedField>();
            for (JsonElement field : fields) {
                JsonObject f = field.getAsJsonObject();
                for (Map.Entry fieldEntry : f.entrySet()) {
                    namedFields.add(new NamedField((String)fieldEntry.getKey()));
                }
            }
            def.fields = namedFields;
            return def;
        }
    }

    @JsonAdapter(value=Adapter.class)
    static class Definition
    extends com.cloudant.client.internal.query.Definition<Field> {
        Definition() {
        }
    }
}

