/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.query;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedList;

public class Helpers {
    public static final String SELECTOR = "selector";
    public static final String PARTIAL_FILTER_SELECTOR = "partial_filter_selector";

    public static String quote(Object o) {
        if (o.getClass().equals(String.class)) {
            return String.format("\"%s\"", o);
        }
        return String.format("%s", o);
    }

    public static String quote(Object[] os) {
        return Helpers.quote(os, false);
    }

    public static String quote(Object[] os, boolean single) {
        if (!single && os.length == 1) {
            return Helpers.quote(os[0]);
        }
        return Helpers.quoteInternal(os, ", ", "", "", "[", "]");
    }

    public static String quoteNoSquare(Object[] os) {
        if (os.length == 1) {
            return Helpers.quote(os[0]);
        }
        return Helpers.quoteInternal(os, ", ", "", "", "", "");
    }

    public static String quoteCurly(Object[] os) {
        if (os.length == 1) {
            return String.format("%s%s%s", "{", Helpers.quote(os[0]), "}");
        }
        return Helpers.quoteInternal(os, ", ", "{", "}", "[", "]");
    }

    public static String quoteCurlyNoSquare(Object[] os) {
        return Helpers.quoteInternal(os, ", ", "{", "}", "", "");
    }

    private static String quoteInternal(Object[] os, String joiner, String start, String end, String arrayStart, String arrayEnd) {
        LinkedList<String> ss = new LinkedList<String>();
        for (Object o : os) {
            ss.add(Helpers.quote(o));
        }
        return String.format("%s%s%s%s%s", arrayStart, start, Helpers.joinInternal(end + joiner + start, ss.toArray(new String[0])), end, arrayEnd);
    }

    private static String joinInternal(String delimiter, String ... args) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String arg : args) {
            sb.append(arg);
            if (++i == args.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String enclose(Selector selector) {
        return String.format("{%s}", selector.toString());
    }

    public static String withKey(String key, Selector selector) {
        return String.format("\"%s\": %s", key, Helpers.enclose(selector));
    }

    public static String encloseWithKey(String key, Selector selector) {
        return String.format("{%s}", Helpers.withKey(key, selector));
    }

    public static JsonObject getJsonObjectFromSelector(Selector selector) {
        return (JsonObject)new Gson().fromJson(Helpers.enclose(selector), JsonObject.class);
    }

    public static JsonObject getSelectorFromString(String selectorJson) {
        return Helpers.getSelectorFromString(SELECTOR, selectorJson);
    }

    private static JsonObject getSelectorFromString(String key, String selectorJson) {
        selectorJson = Helpers.sanitizeSelectorString(selectorJson);
        JsonObject selector = Helpers.selectorStringAsJsonObject(key, selectorJson);
        selector = Helpers.extractNestedSelectorObject(key, selector);
        return selector;
    }

    private static String sanitizeSelectorString(String selectorJson) {
        CouchDbUtil.assertNotNull(selectorJson, "selectorJson");
        selectorJson = selectorJson.trim();
        CouchDbUtil.assertNotEmpty(selectorJson, "selectorJson");
        return selectorJson;
    }

    private static JsonObject selectorStringAsJsonObject(String key, String selectorJson) {
        Gson gson = new Gson();
        JsonObject selectorObject = null;
        boolean isObject = true;
        try {
            selectorObject = (JsonObject)gson.fromJson(selectorJson, JsonObject.class);
        }
        catch (JsonParseException e) {
            isObject = false;
        }
        if (!isObject) {
            if (selectorJson.startsWith(key) || selectorJson.startsWith("\"" + key + "\"")) {
                selectorJson = selectorJson.substring(selectorJson.indexOf(":") + 1, selectorJson.length()).trim();
                selectorObject = (JsonObject)gson.fromJson(selectorJson, JsonObject.class);
            } else {
                throw new JsonParseException("selectorJson should be valid json or like \"" + key + "\": {...} ");
            }
        }
        return selectorObject;
    }

    private static JsonObject extractNestedSelectorObject(String key, JsonObject selectorObject) {
        if (selectorObject.has(key)) {
            return selectorObject.get(key).getAsJsonObject();
        }
        return selectorObject;
    }
}

