/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.views;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.api.views.Key;
import com.cloudant.client.api.views.MultipleRequestBuilder;
import com.cloudant.client.api.views.PaginatedRequestBuilder;
import com.cloudant.client.api.views.UnpaginatedRequestBuilder;
import com.cloudant.client.internal.views.MultipleRequestBuilderImpl;
import com.cloudant.client.internal.views.PaginatedRequestBuilderImpl;
import com.cloudant.client.internal.views.UnpaginatedRequestBuilderImpl;
import com.cloudant.client.internal.views.ViewQueryParameters;

public class ViewRequestBuilder {
    private final CloudantClient client;
    private final Database database;
    private final String designDoc;
    private final String viewName;

    public ViewRequestBuilder(CloudantClient client, Database database, String designDoc, String viewName) {
        this.client = client;
        this.database = database;
        this.designDoc = designDoc;
        this.viewName = viewName;
    }

    public <K, V> UnpaginatedRequestBuilder<K, V> newRequest(Key.Type<K> keyType, Class<V> valueType) {
        return new UnpaginatedRequestBuilderImpl<K, V>(this.newViewRequestParameters(keyType.getType(), valueType));
    }

    public <K, V> PaginatedRequestBuilder<K, V> newPaginatedRequest(Key.Type<K> keyType, Class<V> valueType) {
        return new PaginatedRequestBuilderImpl<K, V>(this.newViewRequestParameters(keyType.getType(), valueType));
    }

    public <K, V> MultipleRequestBuilder<K, V> newMultipleRequest(Key.Type<K> keyType, Class<V> valueType) {
        return new MultipleRequestBuilderImpl<K, V>(this.newViewRequestParameters(keyType.getType(), valueType));
    }

    private <K, V> ViewQueryParameters<K, V> newViewRequestParameters(Class<K> keyType, Class<V> valueType) {
        return new ViewQueryParameters<K, V>(this.client, this.database, this.designDoc, this.viewName, keyType, valueType);
    }
}

