/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Type;
import com.cloudant.client.internal.query.Helpers;

public class PredicateExpression {
    private final String op;
    private final Object[] rhs;
    private boolean single;

    private PredicateExpression(String op, Object ... rhs) {
        this.op = op;
        this.rhs = rhs;
    }

    public static PredicateExpression lt(Object rhs) {
        return new PredicateExpression("$lt", rhs);
    }

    public static PredicateExpression lte(Object rhs) {
        return new PredicateExpression("$lte", rhs);
    }

    public static PredicateExpression eq(Object rhs) {
        return new PredicateExpression("$eq", rhs);
    }

    public static PredicateExpression ne(Object rhs) {
        return new PredicateExpression("$ne", rhs);
    }

    public static PredicateExpression gte(Object rhs) {
        return new PredicateExpression("$gte", rhs);
    }

    public static PredicateExpression gt(Object rhs) {
        return new PredicateExpression("$gt", rhs);
    }

    public static PredicateExpression exists(boolean rhs) {
        return new PredicateExpression("$exists", rhs);
    }

    public static PredicateExpression type(Type rhs) {
        return new PredicateExpression("$type", rhs.toString());
    }

    public static PredicateExpression in(Object ... rhs) {
        PredicateExpression ex = new PredicateExpression("$in", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public static PredicateExpression nin(Object ... rhs) {
        PredicateExpression ex = new PredicateExpression("$nin", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public static PredicateExpression size(Long rhs) {
        return new PredicateExpression("$size", rhs);
    }

    public static PredicateExpression mod(Long divisor, Long remainder) {
        return new PredicateExpression("$mod", divisor, remainder);
    }

    public static PredicateExpression regex(String rhs) {
        return new PredicateExpression("$regex", rhs);
    }

    public static PredicateExpression all(Object ... rhs) {
        PredicateExpression ex = new PredicateExpression("$all", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public String toString() {
        return String.format("\"%s\": %s", this.op, Helpers.quote(this.rhs, this.single));
    }
}

