/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.api.query.Type;
import com.cloudant.client.internal.query.Helpers;

public class Expression
implements Selector {
    private final String lhs;
    private final String op;
    private final Object[] rhs;
    private boolean single;

    private Expression(String lhs, String op, Object ... rhs) {
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
    }

    public static Expression lt(String lhs, Object rhs) {
        return new Expression(lhs, "$lt", rhs);
    }

    public static Expression lte(String lhs, Object rhs) {
        return new Expression(lhs, "$lte", rhs);
    }

    public static Expression eq(String lhs, Object rhs) {
        return new Expression(lhs, "$eq", rhs);
    }

    public static Expression ne(String lhs, Object rhs) {
        return new Expression(lhs, "$ne", rhs);
    }

    public static Expression gte(String lhs, Object rhs) {
        return new Expression(lhs, "$gte", rhs);
    }

    public static Expression gt(String lhs, Object rhs) {
        return new Expression(lhs, "$gt", rhs);
    }

    public static Expression exists(String lhs, boolean rhs) {
        return new Expression(lhs, "$exists", rhs);
    }

    public static Expression type(String lhs, Type rhs) {
        return new Expression(lhs, "$type", rhs.toString());
    }

    public static Expression in(String lhs, Object ... rhs) {
        Expression ex = new Expression(lhs, "$in", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public static Expression nin(String lhs, Object ... rhs) {
        Expression ex = new Expression(lhs, "$nin", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public static Expression size(String lhs, Long rhs) {
        return new Expression(lhs, "$size", rhs);
    }

    public static Expression mod(String lhs, Long divisor, Long remainder) {
        return new Expression(lhs, "$mod", divisor, remainder);
    }

    public static Expression regex(String lhs, String rhs) {
        return new Expression(lhs, "$regex", rhs);
    }

    public static Expression all(String lhs, Object ... rhs) {
        Expression ex = new Expression(lhs, "$all", rhs);
        if (rhs.length == 1) {
            ex.single = true;
        }
        return ex;
    }

    public String toString() {
        return String.format("\"%s\": {\"%s\": %s}", this.lhs, this.op, Helpers.quote(this.rhs, this.single));
    }
}

