/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import com.cjcrafter.vivecraft.VSE;
import com.cjcrafter.vivecraft.VivePlayer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.scope.ScopeHandler;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponScopeEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ZoomData {
    private final HandData handData;
    private double zoomAmount;
    private int zoomStacks;
    private boolean zoomNightVision;
    private ItemStack scopeWeaponStack;
    private String scopeWeaponTitle;

    public ZoomData(HandData handData) {
        this.handData = handData;
    }

    public HandData getHandData() {
        return this.handData;
    }

    public boolean isZooming() {
        VivePlayer vive;
        EntityWrapper entityWrapper = this.handData.getEntityWrapper();
        if (Bukkit.getPluginManager().getPlugin("VivecraftSpigot") != null && entityWrapper.isPlayer() && (vive = (VivePlayer)VSE.vivePlayers.get(entityWrapper.getEntity().getUniqueId())) != null && vive.isVR()) {
            return vive.getControllerDir(this.handData.isMainhand() ? 0 : 1).dot(vive.getHMDDir()) > 0.94;
        }
        return this.zoomAmount != 0.0;
    }

    public double getZoomAmount() {
        return this.zoomAmount;
    }

    public void setZoomAmount(double zoomAmount) {
        this.zoomAmount = zoomAmount;
    }

    public int getZoomStacks() {
        return this.zoomStacks;
    }

    public void setZoomStacks(int zoomStacks) {
        this.zoomStacks = Math.max(0, zoomStacks);
    }

    public boolean hasZoomNightVision() {
        return this.zoomNightVision;
    }

    public void setZoomNightVision(boolean zoomNightVision) {
        this.zoomNightVision = zoomNightVision;
    }

    public void ifZoomingForceZoomOut() {
        if (this.isZooming()) {
            if (this.getZoomAmount() == 0.0) {
                return;
            }
            EntityWrapper entityWrapper = this.handData.getEntityWrapper();
            ScopeHandler scopeHandler = WeaponMechanics.getWeaponHandler().getScopeHandler();
            scopeHandler.updateZoom(entityWrapper, this, 0.0);
            this.setZoomStacks(0);
            scopeHandler.useNightVision(entityWrapper, this, false);
            Mechanics zoomOffMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(this.scopeWeaponTitle + ".Scope.Zoom_Off.Mechanics", Mechanics.class);
            WeaponScopeEvent weaponScopeEvent = new WeaponScopeEvent(this.scopeWeaponTitle, this.scopeWeaponStack, entityWrapper.getEntity(), this.getHandData().isMainhand() ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, WeaponScopeEvent.ScopeType.OUT, 0.0, 0, zoomOffMechanics);
            Bukkit.getPluginManager().callEvent((Event)weaponScopeEvent);
            if (weaponScopeEvent.getMechanics() != null) {
                weaponScopeEvent.getMechanics().use(new CastData(entityWrapper.getEntity(), this.scopeWeaponTitle, this.scopeWeaponStack));
            }
        }
        this.setScopeData(null, null);
    }

    public void setScopeData(String weaponTitle, ItemStack weaponStack) {
        this.scopeWeaponTitle = weaponTitle;
        this.scopeWeaponStack = weaponStack;
    }
}

